/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.FieldUtil;
import com.tssap.selena.internal.core.providers.java.Formatter;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.MethodBodyUtil;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.RenameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.internal.core.providers.java.property.InitialValuePropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertyUniqueNameProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.PropertyAdapter;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

public class DisplayRepresentationPropertyProvider
extends ModelAwareProvider
implements PropertyGetProvider,
PropertyUniqueNameProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$uml_representation"};

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        try {
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            StringBuffer representation = new StringBuffer();
            if (javaElement instanceof IField) {
                IField field = (IField)javaElement;
                representation.append(this.getVisibilityPrefix((IMember)field));
                representation.append(field.getElementName());
                representation.append(":");
                representation.append(JDTUtil.getRefType(field));
                String initializer = InitialValuePropertyProvider.getInitializer(field);
                if (initializer != null) {
                    representation.append("=");
                    representation.append(initializer);
                }
            } else if (javaElement instanceof IMethod) {
                IMethod method = (IMethod)javaElement;
                representation.append(this.getVisibilityPrefix((IMember)method));
                representation.append(method.getElementName());
                representation.append(this.getParameters(method));
                if (!method.isConstructor()) {
                    representation.append(":");
                    representation.append(JDTUtil.getRefType(method));
                }
            } else if (javaElement instanceof IType) {
                IType type = (IType)javaElement;
                if (javaElement.getParent() instanceof IType) {
                    representation.append(this.getVisibilityPrefix((IMember)type));
                    representation.append(javaElement.getElementName());
                } else {
                    representation.append(javaElement.getElementName());
                }
            } else if (javaElement instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                String name = packageFragment.getElementName();
                representation.append(NameUtil.getPackageShortName(name));
            }
            return representation.toString();
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (propertyValue == null || propertyValue.length() == 0) {
            return false;
        }
        String value = this.getPropertyValue(element, propertyName);
        if (propertyValue.equals(value)) {
            return true;
        }
        try {
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            if (javaElement instanceof IField) {
                IField field = (IField)javaElement;
                IType type = field.getDeclaringType();
                boolean inInterface = type.isInterface();
                Field fld = new Field(propertyValue, inInterface);
                if (fld.isValid()) {
                    return RenameUtil.canSetName(javaElement, fld.getName());
                }
            } else if (javaElement instanceof IMethod) {
                IMethod method = (IMethod)javaElement;
                IType type = method.getDeclaringType();
                boolean inInterface = type.isInterface();
                Method mth = new Method(propertyValue, inInterface);
                if (mth.isValid()) {
                    IMethod existingMethod = type.getMethod(mth.getName(), mth.getParameterTypeSignature());
                    if (existingMethod != null && existingMethod.exists() && !method.equals(existingMethod)) {
                        return false;
                    }
                    return RenameUtil.canSetName(javaElement, mth.getName(), true);
                }
            } else if (javaElement instanceof IType) {
                IType type = (IType)javaElement;
                boolean inInterface = type.isInterface();
                Type tp = new Type(propertyValue, inInterface);
                if (tp.isValid()) {
                    if (javaElement.getParent() instanceof ICompilationUnit && tp.getVisibility() != 1 && tp.getVisibility() != 0) {
                        return false;
                    }
                    return RenameUtil.canSetName(javaElement, tp.getName());
                }
            } else if (javaElement instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                String name = packageFragment.getElementName();
                name = NameUtil.getPackageShortName(name);
                return RenameUtil.canSetName(javaElement, name);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            JavaProviderPlugin.getDefault().logException(e);
        }
        return false;
    }

    public UniqueName setPropertyValue(Element element, String propertyName, String propertyValue) {
        UniqueName oldUin = element.getUniqueName();
        String oldValue = this.getPropertyValue(element, propertyName);
        if (propertyValue.equals(oldValue)) {
            return oldUin;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        UniqueName result = null;
        try {
            if (javaElement instanceof IField) {
                IField changedField;
                IField field = (IField)javaElement;
                final IType type = field.getDeclaringType();
                boolean inInterface = type.isInterface();
                final Field fld = new Field(propertyValue, inInterface);
                if (RenameUtil.setName(this.myJavaProject, javaElement, fld.getName())) {
                    result = NameUtil.getRenamedUniqueName(oldUin, fld.getName());
                }
                if ((changedField = type.getField(fld.getName())) != null) {
                    PropertyOperationUtil.doPropertyOperation(this.myJavaProject, (IJavaElement)changedField, true, null, null, null, new PropertyOperation(){

                        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
                            if (domNode instanceof IDOMField) {
                                IDOMField domField = (IDOMField)domNode;
                                domField.setFlags(fld.getFlags(domField.getFlags()));
                                String typeName = fld.getType();
                                if (typeName != null && !typeName.equals(domField.getType())) {
                                    if (ImportStatementSupport.isImportStatamentSupported()) {
                                        ImportStatementSupport.addImportStatament(DisplayRepresentationPropertyProvider.this.myModel, javaElement, (IDOMNode)domField, typeName);
                                        IType type2 = ((IField)javaElement).getDeclaringType();
                                        typeName = NameUtil.getTypeShortName(type2, typeName);
                                    }
                                    domField.setType(typeName);
                                    return FieldUtil.fixupFieldInitializer((IJavaElement)type, domField, typeName);
                                }
                                String initializer = fld.getInitializer();
                                if (initializer != null) {
                                    domField.setInitializer(initializer);
                                }
                                return domField.getContents();
                            }
                            return null;
                        }
                    });
                }
            } else if (javaElement instanceof IMethod) {
                IMethod method = (IMethod)javaElement;
                String[] oldParamSignatures = method.getParameterTypes();
                IType type = method.getDeclaringType();
                boolean inInterface = type.isInterface();
                final Method mth = new Method(propertyValue, inInterface);
                if (RenameUtil.setName(this.myJavaProject, javaElement, mth.getName())) {
                    result = NameUtil.getRenamedUniqueName(oldUin, mth.getName());
                }
                final boolean constructor = type.getElementName().equals(mth.getName());
                IMethod changedMethod = type.getMethod(mth.getName(), oldParamSignatures);
                changedMethod.getCompilationUnit().makeConsistent((IProgressMonitor)new NullProgressMonitor());
                if (changedMethod != null) {
                    PropertyOperationUtil.doPropertyOperation(this.myJavaProject, (IJavaElement)changedMethod, true, null, null, null, new PropertyOperation(){

                        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
                            if (domNode instanceof IDOMMethod) {
                                IType type;
                                IDOMMethod domMethod = (IDOMMethod)domNode;
                                domMethod.setFlags(mth.getFlags(domMethod.getFlags()));
                                if (mth.getParameterTypes() != null) {
                                    if (ImportStatementSupport.isImportStatamentSupported()) {
                                        String[] parameterTypes = mth.getParameterTypes();
                                        int i = 0;
                                        while (i < parameterTypes.length) {
                                            ImportStatementSupport.addImportStatament(DisplayRepresentationPropertyProvider.this.myModel, javaElement, domNode, parameterTypes[i]);
                                            ++i;
                                        }
                                        type = ((IMethod)javaElement).getDeclaringType();
                                        domMethod.setParameters(mth.getParameterShortTypes(type), mth.getParameterNames());
                                    } else {
                                        domMethod.setParameters(mth.getParameterTypes(), mth.getParameterNames());
                                    }
                                }
                                if (constructor) {
                                    domMethod.setConstructor(true);
                                } else if (mth.getType() != null) {
                                    IMethod method = (IMethod)javaElement;
                                    String typeName = mth.getType();
                                    if (!typeName.equals(domMethod.getReturnType())) {
                                        type = method.getDeclaringType();
                                        if (ImportStatementSupport.isImportStatamentSupported()) {
                                            ImportStatementSupport.addImportStatament(DisplayRepresentationPropertyProvider.this.myModel, javaElement, domNode, typeName);
                                            typeName = NameUtil.getTypeShortName(type, typeName);
                                        }
                                        ((IDOMMethod)domNode).setReturnType(typeName);
                                        int nesting = Formatter.getNesting((IMember)javaElement);
                                        MethodBodyUtil.fixupMethodBody((IMethod)javaElement, (IDOMMethod)domNode, typeName);
                                        String content = domMethod.getContents();
                                        String newContents = Formatter.formatBody(content, nesting);
                                        content = newContents != null ? newContents : content;
                                        return content;
                                    }
                                }
                                return domMethod.getContents();
                            }
                            return null;
                        }
                    });
                }
            } else if (javaElement instanceof IType) {
                IType changedType;
                IType type = (IType)javaElement;
                IJavaElement parent = type.getParent();
                boolean inInterface = type.isInterface();
                final Type tp = new Type(propertyValue, inInterface);
                String typeName = tp.getName();
                if (RenameUtil.setName(this.myJavaProject, javaElement, typeName)) {
                    typeName = NameUtil.fixupTypeNameForUIN(typeName);
                    result = NameUtil.getRenamedUniqueName(oldUin, typeName);
                }
                if (parent instanceof IType && (changedType = ((IType)parent).getType(tp.getName())) != null) {
                    PropertyOperationUtil.doPropertyOperation(this.myJavaProject, (IJavaElement)changedType, true, null, null, null, new PropertyOperation(){

                        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
                            if (domNode instanceof IDOMType) {
                                IDOMType domType = (IDOMType)domNode;
                                domType.setFlags(tp.getFlags(domType.getFlags()));
                                return domType.getContents();
                            }
                            return null;
                        }
                    });
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return result;
    }

    public Property getProperty(Element element, String propertyName) {
        String result = this.getPropertyValue(element, propertyName);
        return result != null ? new PropertyAdapter(propertyName, result, element) : null;
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public PropertyEnumeration properties(Element element) {
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public boolean isPropertyWritable(Element element, String propertyName) {
        return true;
    }

    private String getVisibilityPrefix(IMember member) {
        String representation = "";
        int flag = 0;
        try {
            flag = member.getFlags();
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        if (Flags.isPublic((int)flag)) {
            return "+";
        }
        if (Flags.isProtected((int)flag)) {
            return "#";
        }
        if (Flags.isPrivate((int)flag)) {
            return "-";
        }
        return "";
    }

    private String getParameters(IMethod method) {
        StringBuffer representation = new StringBuffer();
        String[] parameterNames = null;
        String[] parameterTypes = null;
        try {
            parameterNames = method.getParameterNames();
            parameterTypes = method.getParameterTypes();
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        if (parameterNames != null && parameterNames.length > 0) {
            representation.append("(");
            int i = 0;
            while (i < parameterNames.length) {
                representation.append(parameterNames[i]);
                representation.append(":");
                representation.append(Signature.toString((String)parameterTypes[i]));
                if (i < parameterNames.length - 1) {
                    representation.append(", ");
                }
                ++i;
            }
            representation.append(")");
        }
        return representation.toString();
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isJavaElementUniqueName(uniqueName, false) && !NameUtil.isJavaLinkElementUniqueName(uniqueName, false);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    private static abstract class Member {
        public static final String PUBLIC_DECL = "public ";
        public static final String PROTECTED_DECL = "protected ";
        public static final String PRIVATE_DECL = "private ";
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int UNDEFINITE = 0;
        protected boolean myIsValid = false;
        protected int myVisibility;
        protected String myName;

        private Member() {
        }

        int getVisibility() {
            return this.myVisibility;
        }

        String getName() {
            return this.myName;
        }

        boolean isValid() {
            return this.myIsValid;
        }

        protected boolean isVisibilityValid(char ch, boolean inInterface) {
            if (inInterface) {
                return ch == '+' || Character.isLetter(ch);
            }
            return ch == '+' || ch == '-' || ch == '#' || Character.isLetter(ch);
        }

        protected int getVisibilityFlag(char ch) {
            if (ch == '+') {
                return 1;
            }
            if (ch == '-') {
                return 2;
            }
            if (ch == '#') {
                return 4;
            }
            return 0;
        }

        protected int getFlags(int oldFlags) {
            int newFlag = this.getVisibility();
            if (newFlag == 0) {
                return oldFlags;
            }
            oldFlags = oldFlags & 0xFFFFFFFE & 0xFFFFFFFB & 0xFFFFFFFD;
            return oldFlags | newFlag;
        }
    }

    private static class Type
    extends Member {
        Type(String representation, boolean inInterface) {
            representation = representation.trim();
            if ("".equals(representation)) {
                return;
            }
            char ch = representation.charAt(0);
            if (!this.isVisibilityValid(ch, inInterface)) {
                return;
            }
            this.myVisibility = this.getVisibilityFlag(ch);
            if (this.myVisibility != 0) {
                representation = representation.substring(1);
            }
            this.myName = representation;
            IStatus status = JavaConventions.validateJavaTypeName((String)this.myName);
            if (status.getSeverity() == 4) {
                return;
            }
            this.myIsValid = true;
        }
    }

    private static class Method
    extends Member {
        private String myType;
        private String[] myParameterNames;
        private String[] myParameterTypes;

        Method(String representation, boolean inInterface) {
            representation = representation.trim();
            if ("".equals(representation)) {
                return;
            }
            char ch = representation.charAt(0);
            if (!this.isVisibilityValid(ch, inInterface)) {
                return;
            }
            this.myVisibility = this.getVisibilityFlag(ch);
            if (this.myVisibility != 0) {
                representation = representation.substring(1);
            }
            try {
                representation = this.extractReturnTypeIfAny(representation);
                int leftBracket = Method.getParametersLeftBracket(representation);
                if (leftBracket != -1) {
                    this.myName = representation.substring(0, leftBracket).trim();
                    String parameters = representation.substring(leftBracket).trim();
                    if (!this.parseParameters(parameters)) {
                        return;
                    }
                } else {
                    this.myName = representation.trim();
                }
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            this.myIsValid = this.isMethodNameValid();
        }

        private boolean parseParameters(String parameters) {
            if ((parameters = parameters.trim()).length() < 2) {
                return false;
            }
            parameters = parameters.substring(1);
            int lenght = parameters.length();
            parameters = parameters.substring(0, lenght - 1);
            StringTokenizer st = new StringTokenizer(parameters, ",");
            this.myParameterNames = new String[st.countTokens()];
            this.myParameterTypes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String parameter = st.nextToken().trim();
                int index = parameter.indexOf(58);
                if (index != -1) {
                    this.myParameterNames[i] = parameter.substring(0, index);
                    this.myParameterTypes[i] = parameter.substring(index + 1);
                } else {
                    index = parameter.indexOf(32);
                    if (index != -1) {
                        this.myParameterTypes[i] = parameter.substring(0, index);
                        this.myParameterNames[i] = parameter.substring(index + 1);
                    } else {
                        return false;
                    }
                }
                if (!Method.isParameterNameValid(this.myParameterNames[i]) || !Method.isParameterTypeValid(this.myParameterTypes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        String getType() {
            return this.myType;
        }

        String getSignature() {
            return Signature.createMethodSignature((String[])this.getParameterTypes(), (String)this.getType());
        }

        String[] getParameterTypeSignature() {
            if (this.myParameterTypes != null) {
                String[] typesSignatures = new String[this.myParameterTypes.length];
                int i = 0;
                while (i < this.myParameterTypes.length) {
                    typesSignatures[i] = Signature.createTypeSignature((String)this.myParameterTypes[i], (boolean)false);
                    ++i;
                }
                return typesSignatures;
            }
            return new String[0];
        }

        String[] getParameterNames() {
            return this.myParameterNames;
        }

        String[] getParameterTypes() {
            return this.myParameterTypes;
        }

        String[] getParameterShortTypes(IType type) {
            if (this.myParameterTypes != null) {
                String[] parameterShortTypes = new String[this.myParameterTypes.length];
                int i = 0;
                while (i < parameterShortTypes.length) {
                    parameterShortTypes[i] = NameUtil.getTypeShortName(type, this.myParameterTypes[i]);
                    ++i;
                }
                return parameterShortTypes;
            }
            return new String[0];
        }

        private boolean isMethodNameValid() {
            return JavaConventions.validateMethodName((String)this.myName).getSeverity() != 4;
        }

        private boolean isReturnTypeValid() {
            return TypeNameUtil.isPrimitiveType(this.myType) || TypeNameUtil.isNonPrimitiveType(this.myType) || TypeNameUtil.isVoid(this.myType);
        }

        private String extractReturnTypeIfAny(String representation) {
            int index = representation.lastIndexOf(58);
            if (index != -1) {
                this.myType = representation.substring(index + 1).trim();
                String string = this.myType = "".equals(this.myType) ? null : this.myType;
                if (!this.isReturnTypeValid()) {
                    throw new IllegalArgumentException();
                }
                return representation.substring(0, index);
            }
            if (representation.startsWith("public ")) {
                this.myVisibility = 1;
                representation = representation.substring("public ".length());
            } else if (representation.startsWith("protected ")) {
                this.myVisibility = 4;
                representation = representation.substring("protected ".length());
            } else if (representation.startsWith("private ")) {
                this.myVisibility = 2;
                representation = representation.substring("private ".length());
            }
            index = representation.indexOf(32);
            if (index == -1) {
                return representation;
            }
            String typeCandidate = representation.substring(0, index);
            if (typeCandidate.indexOf(40) != -1) {
                return representation;
            }
            this.myType = typeCandidate;
            if (!this.isReturnTypeValid()) {
                throw new IllegalArgumentException();
            }
            return representation.substring(index + 1);
        }

        private static boolean isParameterNameValid(String parameterName) {
            return JavaConventions.validateIdentifier((String)parameterName).getSeverity() != 4;
        }

        private static boolean isParameterTypeValid(String parameterType) {
            return TypeNameUtil.isPrimitiveType(parameterType) || TypeNameUtil.isNonPrimitiveType(parameterType);
        }

        private static int getParametersLeftBracket(String representation) {
            int leftBracket = representation.indexOf(40);
            int rightBracket = representation.indexOf(41);
            if (leftBracket != -1 || rightBracket != -1) {
                int lastLeftBracket = representation.lastIndexOf(40);
                if (leftBracket != lastLeftBracket) {
                    throw new IllegalArgumentException();
                }
                int rightLeftBracket = representation.lastIndexOf(41);
                if (rightBracket != rightLeftBracket) {
                    throw new IllegalArgumentException();
                }
                if (leftBracket > rightBracket) {
                    throw new IllegalArgumentException();
                }
                return leftBracket;
            }
            return -1;
        }
    }

    private static class Field
    extends Member {
        private String myInitializer;
        private String myType;

        Field(String representation, boolean inInterface) {
            int index;
            representation = representation.trim();
            if ("".equals(representation)) {
                return;
            }
            char ch = representation.charAt(0);
            if (!(representation.startsWith("public ") || representation.startsWith("private ") || representation.startsWith("protected ") || this.isVisibilityValid(ch, inInterface))) {
                return;
            }
            this.myVisibility = this.getVisibilityFlag(ch);
            if (this.myVisibility != 0) {
                representation = representation.substring(1);
            }
            if ((index = representation.indexOf(":")) != -1) {
                this.myName = representation.substring(0, index).trim();
                this.myType = representation.substring(index + 1).trim();
                this.myType = "".equals(this.myType) ? null : this.myType;
                index = this.myType.indexOf("=");
                if (index != -1) {
                    this.myInitializer = this.myType.substring(index + 1).trim();
                    this.myInitializer = this.myInitializer.length() > 0 ? this.myInitializer : null;
                    this.myType = this.myType.substring(0, index).trim();
                }
            } else {
                index = representation.lastIndexOf(32);
                if (index != -1) {
                    this.myName = representation.substring(index + 1).trim();
                    if (this.myName.endsWith(";")) {
                        this.myName = this.myName.substring(0, this.myName.length() - 1);
                    }
                    this.myType = representation.substring(0, index).trim();
                    index = representation.indexOf(32);
                    if (index != -1 && (representation.startsWith("public ") || representation.startsWith("private ") || representation.startsWith("protected "))) {
                        this.myType = this.myType.substring(index + 1).trim();
                        this.myVisibility = representation.startsWith("public ") ? 1 : (representation.startsWith("private ") ? 2 : (representation.startsWith("protected ") ? 4 : 0));
                    }
                } else {
                    this.myName = representation.trim();
                    this.myIsValid = this.isFieldNameValid();
                    return;
                }
            }
            this.myIsValid = this.isFieldNameValid() && this.isFieldTypeValid();
        }

        String getType() {
            return this.myType;
        }

        String getInitializer() {
            return this.myInitializer;
        }

        private boolean isFieldNameValid() {
            IStatus status = JavaConventions.validateFieldName((String)this.myName);
            return status.getSeverity() != 4;
        }

        private boolean isFieldTypeValid() {
            return TypeNameUtil.isPrimitiveType(this.myType) || TypeNameUtil.isNonPrimitiveType(this.myType);
        }
    }
}

