/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class DiagramFolderPropertyProvider
extends AbstractGetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$diagram_folder"};
    private static final String DEF_DIAGRAM_FILE = "";

    public String getPropertyValue(Element element, String propertyName) {
        try {
            UniqueName uniqueName = element.getUniqueName();
            if (NameUtil.isRootUniqueName(uniqueName)) {
                return DEF_DIAGRAM_FILE;
            }
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            if (javaElement instanceof IJavaProject) {
                if (javaElement.isReadOnly()) {
                    return null;
                }
                return DEF_DIAGRAM_FILE;
            }
            if (javaElement instanceof IPackageFragment) {
                if (!this.myModelId.equals(javaElement.getJavaProject().getElementName())) {
                    return DEF_DIAGRAM_FILE;
                }
                IResource resource = javaElement.getCorrespondingResource();
                if (resource != null) {
                    return resource.getProjectRelativePath().toString();
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

