/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.designlinks.DependencyLinkParserCache;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLink;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLinkParser;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.SetPropertyImpl;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;

public class DependencyTagPropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$comment"};

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return propertyName == null || propertyName.startsWith("@") || "$comment".equals(propertyName) || "$description".equals(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        PropertyEnumeration propertyEnumeration;
        if ("$description".equals(propertyName)) {
            propertyName = "$comment";
        }
        if ((propertyEnumeration = this.properties(element, propertyName)).hasMoreElements()) {
            Property property = propertyEnumeration.next();
            return property.getValue();
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        UniqueName uniqueName = element.getUniqueName();
        UniqueName parentUniqueName = NameUtil.getTUINFromDUIN(uniqueName);
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            if (!type.exists() || !ElementUtil.isWritableElement((IJavaElement)type)) {
                return false;
            }
            if (propertyValue == null) {
                return false;
            }
            return !"$comment".equals(propertyName) && !"$description".equals(propertyName);
        }
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        IJavaComment javaComment;
        IDependencyLink dependencyLink = this.getDependencyLink(element);
        if (dependencyLink != null && (javaComment = dependencyLink.getJavaComment()) != null) {
            ITag tag = javaComment.addTag(propertyName, propertyValue);
            javaComment.synchronize(true);
            return new MyTagSetPropertyImpl(element, javaComment, tag);
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        UniqueName uniqueName = element.getUniqueName();
        UniqueName parentUniqueName = NameUtil.getTUINFromDUIN(uniqueName);
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        if (javaElement instanceof IMember) {
            return !javaElement.isReadOnly();
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        IJavaComment javaComment;
        IDependencyLink dependencyLink = this.getDependencyLink(element);
        if (dependencyLink != null && (javaComment = dependencyLink.getJavaComment()) != null) {
            if ("$comment".equals(propertyName) || "$description".equals(propertyName)) {
                javaComment.setComment(propertyValue);
            } else {
                Enumeration enumeration = javaComment.getTags(propertyName);
                if (enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        ITag tag = (ITag)enumeration.nextElement();
                        if (propertyValue != null) {
                            tag.setValue(propertyValue);
                            break;
                        }
                        tag.setValue(propertyValue);
                    }
                } else if (propertyValue != null) {
                    javaComment.addTag(propertyName, propertyValue);
                }
            }
            javaComment.synchronize(true);
        }
    }

    public PropertyEnumeration properties(Element element) {
        IJavaComment javaComment;
        ArrayList<MyCommentSetPropertyImpl> properties = new ArrayList<MyCommentSetPropertyImpl>();
        IDependencyLink dependencyLink = this.getDependencyLink(element);
        if (dependencyLink != null && (javaComment = dependencyLink.getJavaComment()) != null) {
            SetPropertyImpl property;
            if (javaComment.getComment() != null) {
                property = new MyCommentSetPropertyImpl(element, javaComment);
                properties.add((MyCommentSetPropertyImpl)property);
            }
            Enumeration tags = javaComment.getTags();
            while (tags.hasMoreElements()) {
                ITag tag = (ITag)tags.nextElement();
                property = new MyTagSetPropertyImpl(element, javaComment, tag);
                properties.add((MyCommentSetPropertyImpl)property);
            }
        }
        return EnumerationConverter.toPropertyEnumeration(properties.iterator());
    }

    private DependencyTagPropertyProvider getItself() {
        return this;
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    private IDependencyLink getDependencyLink(Element element) {
        IDependencyLinkParser dependencyLinkParser = this.getDependencyLinkParser(element);
        if (dependencyLinkParser != null) {
            UniqueName uniqueName = element.getUniqueName();
            String name = NameUtil.getFNFromDUIN(uniqueName);
            IDependencyLink dependencyLink = dependencyLinkParser.getDependencyLink(name);
            return dependencyLink;
        }
        return null;
    }

    private IDependencyLinkParser getDependencyLinkParser(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        UniqueName parentUniqueName = NameUtil.getTUINFromDUIN(uniqueName);
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            IDependencyLinkParser designLinkParser = DependencyLinkParserCache.get(this.myJavaProject, type);
            return designLinkParser;
        }
        return null;
    }

    private class MyTagSetPropertyImpl
    extends SetPropertyImpl {
        public MyTagSetPropertyImpl(Element element, IJavaComment javaComment, ITag tag) {
            super(element, tag.getName(), tag.getValue());
        }

        public boolean canSetValue(String newValue) {
            return DependencyTagPropertyProvider.this.getItself().canSetPropertyValue(this.myElement, this.myPropertyName, newValue);
        }

        public void setValue(String newValue) {
            super.setValue(newValue);
        }

        public boolean isValid() {
            return true;
        }
    }

    private class MyCommentSetPropertyImpl
    extends SetPropertyImpl {
        private IJavaComment myJavaComment;

        public MyCommentSetPropertyImpl(Element element, IJavaComment javaComment) {
            super(element, "$comment", javaComment.getComment());
            this.myJavaComment = javaComment;
        }

        public boolean canSetValue(String newValue) {
            return DependencyTagPropertyProvider.this.getItself().canSetPropertyValue(this.myElement, this.myPropertyName, newValue);
        }

        public void setValue(String newValue) {
            this.myJavaComment.setComment(newValue);
            this.myJavaComment.synchronize(true);
        }
    }
}

