/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class DeclarationTextPropertyProvider
extends AbstractGetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$declarationText"};

    public String getPropertyValue(Element element, String propertyName) {
        try {
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            if (javaElement instanceof IType) {
                return this.getTypeDeclarationText((IType)javaElement);
            }
            if (javaElement instanceof IMethod) {
                return this.getMethodDeclarationText((IMethod)javaElement);
            }
            if (javaElement instanceof IField) {
                return this.getFieldDeclarationText((IField)javaElement);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    private String getTypeDeclarationText(IType javaType) throws JavaModelException {
        String[] superInterfaceNames;
        int length;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getModifiersAsString(javaType.getFlags()));
        buf.append(" ");
        buf.append(javaType.getElementName());
        String superClassName = javaType.getSuperclassName();
        if (superClassName != null) {
            buf.append(" extends ");
            buf.append(superClassName);
        }
        if ((length = (superInterfaceNames = javaType.getSuperInterfaceNames()).length) > 0) {
            buf.append(" implements ");
            int i = 0;
            while (i < length) {
                buf.append(superInterfaceNames[i]);
                if (i != length - 1) {
                    buf.append(",");
                }
                buf.append(" ");
                ++i;
            }
        }
        return buf.toString();
    }

    private String getMethodDeclarationText(IMethod javaMethod) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getModifiersAsString(javaMethod.getFlags()));
        buf.append(" ");
        if (!javaMethod.isConstructor()) {
            buf.append(Signature.toString((String)javaMethod.getReturnType()));
            buf.append(" ");
        }
        buf.append(javaMethod.getElementName());
        buf.append("(");
        int lenght = javaMethod.getNumberOfParameters();
        if (lenght > 0) {
            int i = 0;
            while (i < lenght) {
                buf.append(Signature.toString((String)javaMethod.getParameterTypes()[i]));
                buf.append(" ");
                buf.append(javaMethod.getParameterNames()[i]);
                if (i < lenght - 1) {
                    buf.append(", ");
                }
                ++i;
            }
        }
        buf.append(")");
        String[] exceptions = javaMethod.getExceptionTypes();
        if (exceptions.length > 0) {
            buf.append(" throws ");
        }
        int i = 0;
        while (i < exceptions.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Signature.toString((String)exceptions[i]));
            ++i;
        }
        return buf.toString();
    }

    private String getFieldDeclarationText(IField javaField) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getModifiersAsString(javaField.getFlags()));
        buf.append(" ");
        buf.append(Signature.toString((String)javaField.getTypeSignature()));
        buf.append(" ");
        buf.append(javaField.getElementName());
        if (javaField.getConstant() != null) {
            buf.append("=");
            buf.append(javaField.getConstant());
        }
        return buf.toString();
    }

    private String getModifiersAsString(int flags) {
        StringBuffer buf = new StringBuffer();
        if (Flags.isPublic((int)flags)) {
            buf.append("public ");
        }
        if (Flags.isProtected((int)flags)) {
            buf.append("protected ");
        }
        if (Flags.isPrivate((int)flags)) {
            buf.append("private ");
        }
        if (Flags.isAbstract((int)flags)) {
            buf.append("abstract ");
        }
        if (Flags.isStatic((int)flags)) {
            buf.append("static ");
        }
        if (Flags.isFinal((int)flags)) {
            buf.append("final ");
        }
        if (Flags.isNative((int)flags)) {
            buf.append("native ");
        }
        if (Flags.isTransient((int)flags)) {
            buf.append("transient ");
        }
        if (Flags.isVolatile((int)flags)) {
            buf.append("volatile ");
        }
        if (Flags.isSynchronized((int)flags)) {
            buf.append("synchronized ");
        }
        return buf.toString().trim();
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

