/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class ConstructorPropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$constructor"};

    public boolean hasProperty(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, element.getUniqueName());
        try {
            if (javaElement instanceof IMethod) {
                return ((IMethod)javaElement).isConstructor();
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return false;
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (this.hasProperty(element, propertyName)) {
            return AbstractGetPropertyProvider.BOOLEAN_STR;
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getBooleanProperty(element, propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (this.isBooleanPropertyValue(propertyValue)) {
            return this.canSetPropertyValue(element, propertyName);
        }
        return false;
    }

    private boolean canSetPropertyValue(Element element, String propertyName) {
        if (!this.canChange(element)) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        return javaElement instanceof IMethod;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        Boolean value = this.getBooleanValue(propertyValue);
        try {
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, false, propertyName, (Object)value, null, (PropertyOperation)new MySetPropertyOperation());
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isMethodUniqueName(uniqueName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    private class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMMethod) {
                IDOMMethod domMethod = (IDOMMethod)domNode;
                domMethod.setConstructor(((Boolean)newPropertyValue).booleanValue());
                return domMethod.getContents();
            }
            return null;
        }
    }
}

