/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.impl.model.elements.PropertyAdapter;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.SingleEnumeration;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class CompositeModifiersPropertyProvider
implements PropertyGetProvider {
    private static final boolean READABLE = true;

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if ((propertyName == null || "modifiers".equals(propertyName)) && element instanceof Element) {
            UniqueName uniqueName = element.getUniqueName();
            return NameUtil.isJavaElementUniqueName(uniqueName, false);
        }
        return false;
    }

    public boolean hasProperty(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element.getModel().getUniqueName(), element.getUniqueName());
        if (!(javaElement instanceof IMember)) {
            return false;
        }
        IMember javaMember = (IMember)javaElement;
        try {
            int flags = javaMember.getFlags();
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        int result = 0;
        IJavaElement javaElement = ElementUtil.getJavaElement(element.getModel().getUniqueName(), element.getUniqueName());
        if (!(javaElement instanceof IMember)) {
            return null;
        }
        IMember javaMember = (IMember)javaElement;
        try {
            IJavaElement parent;
            int flags = javaMember.getFlags();
            if (javaMember instanceof IType && ((IType)javaMember).isInterface() && !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !Flags.isPrivate((int)flags)) {
                result |= 1;
            }
            if ((parent = javaMember.getParent()) instanceof IType && ((IType)parent).isInterface() && !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !Flags.isPrivate((int)flags)) {
                result |= 1;
            }
            if (Flags.isPublic((int)flags)) {
                result |= 1;
            }
            if (Flags.isProtected((int)flags)) {
                result |= 2;
            }
            if (Flags.isPrivate((int)flags)) {
                result |= 4;
            }
            if (Flags.isAbstract((int)flags) && javaMember instanceof IType && ((IType)javaMember).isClass()) {
                result |= 8;
            }
            if (Flags.isDeprecated((int)flags)) {
                result |= 0x10;
            }
            if (Flags.isStatic((int)flags)) {
                result |= 0x20;
            }
            if (Flags.isFinal((int)flags)) {
                result |= 0x40;
            }
            if (Flags.isStrictfp((int)flags)) {
                result |= 0x80;
            }
            if (Flags.isNative((int)flags)) {
                result |= 0x100;
            }
            if (Flags.isTransient((int)flags)) {
                result |= 0x200;
            }
            if (Flags.isVolatile((int)flags)) {
                result |= 0x400;
            }
            if (Flags.isSynchronized((int)flags) && javaMember instanceof IMethod) {
                result |= 0x800;
            }
            if (Flags.isSynthetic((int)flags)) {
                result |= 0x2000;
            }
            if (javaMember.isBinary()) {
                result |= 0x1000;
            }
            return Integer.toString(result);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    public Property getProperty(Element element, String propertyName) {
        String value = this.getPropertyValue(element, propertyName);
        if (value == null) {
            return null;
        }
        return new PropertyAdapter(propertyName, value, element);
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "modifiers");
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property property = this.getProperty(element, propertyName);
        if (property == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        return SingleEnumeration.createPropertyEnumeration((Property)property);
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }
}

