/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.Formatter;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class BodyPropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$body"};

    public String getPropertyValue(Element element, String propertyName) {
        try {
            IDOMMethod domMethod;
            String source;
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            if (javaElement instanceof IMethod && (source = ((IMethod)javaElement).getSource()) != null && (domMethod = new DOMFactory().createMethod(source)) != null) {
                String body = domMethod.getBody();
                return ";".equals(body) ? null : body.trim();
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!this.canChange(element)) {
            return false;
        }
        if (propertyValue == null) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (!(javaElement instanceof IMethod)) {
            return false;
        }
        IType type = (IType)javaElement.getParent();
        try {
            return type.isClass();
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return false;
        }
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, false, propertyName, (Object)propertyValue, null, (PropertyOperation)new MySetPropertyOperation());
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isMethodUniqueName(uniqueName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    private class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMMethod) {
                String newBody = (String)newPropertyValue;
                if (!(newBody = newBody.trim()).startsWith("{")) {
                    newBody = "{" + newBody;
                }
                if (!newBody.endsWith("}")) {
                    newBody = newBody + "}";
                }
                ((IDOMMethod)domNode).setBody(newBody);
                String content = domNode.getContents();
                int nesting = Formatter.getNesting((IMember)javaElement);
                String newContents = Formatter.formatBody(content, nesting);
                content = newContents != null ? newContents : content;
                return content;
            }
            return null;
        }
    }
}

