/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.SetPropertyImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.extension.PropertySetProvider;
import org.eclipse.jdt.core.IJavaElement;

abstract class AbstractSetPropertyProvider
extends AbstractGetPropertyProvider
implements PropertySetProvider {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();

    AbstractSetPropertyProvider() {
    }

    public boolean isPropertyWritable(Element element, String propertyName) {
        return true;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    protected boolean canChange(Element element) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement == null) {
            return false;
        }
        return ElementUtil.isWritableElement(javaElement);
    }

    protected Property getStringProperty(Element element, String propertyName) {
        if (!this.hasProperty(element, propertyName)) {
            return null;
        }
        String propertyValue = this.getPropertyValue(element, propertyName);
        return new SetPropertyImpl(element, propertyName, propertyValue);
    }

    protected Property getBooleanProperty(Element element, String propertyName) {
        if (!this.hasProperty(element, propertyName)) {
            return null;
        }
        return new SetPropertyImpl(element, propertyName, AbstractGetPropertyProvider.BOOLEAN_VALUE);
    }

    protected boolean isBooleanPropertyValue(String propertyValue) {
        return propertyValue == null || TRUE.equals(propertyValue) || FALSE.equals(propertyValue);
    }

    protected Boolean getBooleanValue(String propertyValue) {
        if (propertyValue != null) {
            return Boolean.valueOf(propertyValue);
        }
        return Boolean.FALSE;
    }
}

