/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.GetPropertyImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;

abstract class AbstractGetPropertyProvider
extends ModelAwareProvider
implements PropertyGetProvider {
    public static final Boolean BOOLEAN_VALUE = Boolean.TRUE;
    public static final String BOOLEAN_STR = BOOLEAN_VALUE.toString();

    AbstractGetPropertyProvider() {
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        UniqueName uniqueName = element.getUniqueName();
        if (!this.isApplicable(uniqueName)) {
            return false;
        }
        if (propertyName == null) {
            return true;
        }
        Object[] names = this.getPropertyNames();
        return ArrayUtil.contains(names, propertyName);
    }

    public PropertyEnumeration properties(Element element) {
        String[] names = this.getPropertyNames();
        ArrayList<Property> arl = new ArrayList<Property>(names.length);
        int i = 0;
        while (i < names.length) {
            Property property = this.getProperty(element, names[i]);
            if (property != null) {
                arl.add(property);
            }
            ++i;
        }
        return EnumerationConverter.toPropertyEnumeration(arl.iterator());
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        if (propertyName == null) {
            return this.properties(element);
        }
        PropertyEnumeration properties = this.properties(element);
        ArrayList<Property> arl = new ArrayList<Property>(3);
        while (properties.hasMoreElements()) {
            Property property = properties.next();
            if (!propertyName.equals(property.getName())) continue;
            arl.add(property);
        }
        return EnumerationConverter.toPropertyEnumeration(arl.iterator());
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        PropertyEnumeration propertyEnumeration = this.properties(element, propertyName);
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            String value = property.getValue();
            if (!(value == null ? value == propertyValue : value.equals(propertyValue))) continue;
            return true;
        }
        return false;
    }

    protected Property getStringProperty(Element element, String propertyName) {
        if (!this.hasProperty(element, propertyName)) {
            return null;
        }
        return new GetPropertyImpl(element, propertyName, this.getPropertyValue(element, propertyName));
    }

    protected Property getBooleanProperty(Element element, String propertyName) {
        if (!this.hasProperty(element, propertyName)) {
            return null;
        }
        return new GetPropertyImpl(element, propertyName, BOOLEAN_VALUE);
    }

    protected String getWholeValue(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuffer wholeValue = new StringBuffer(1024);
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                wholeValue.append(values[i]);
                if (i < values.length - 1) {
                    wholeValue.append(",");
                }
            }
            ++i;
        }
        return wholeValue.toString();
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isJavaUniqueName(uniqueName) || uniqueName.equals(this.myModelUniqueName);
    }

    protected abstract String[] getPropertyNames();

    public abstract Property getProperty(Element var1, String var2);

    public abstract String getPropertyValue(Element var1, String var2);
}

