/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.inheritance;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

public class InheritanceUtil {
    private static final MRUCacheSuperHierarchy myHierarchyCache = new MRUCacheSuperHierarchy(10);
    private static final IProgressMonitor NULL_PROGRESS = new NullProgressMonitor();

    public static String getInheritanceMetaclass(IType source, IType dest) {
        if (source == null || dest == null) {
            return null;
        }
        try {
            if (source.isInterface()) {
                return dest.isInterface() ? "Generalization Link" : null;
            }
            return dest.isInterface() ? "Implementation Link" : "Generalization Link";
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean hasNoInheritanceCycle(IType subClass, IType superClass) {
        if (subClass.equals(superClass)) {
            return false;
        }
        try {
            return !myHierarchyCache.getHierarchy(superClass).contains(subClass);
        }
        catch (JavaModelException ex) {
            JavaProviderPlugin.getDefault().getLog().log(ex.getStatus());
            return true;
        }
    }

    private static class MRUCacheSuperHierarchy {
        private final Map myEntryMap;
        private final LinkedList myEntryQueue;
        private final int mySize;

        public MRUCacheSuperHierarchy(int size) {
            this.myEntryMap = new HashMap(size * 4 / 3);
            this.myEntryQueue = new LinkedList();
            this.mySize = size;
        }

        public boolean hasHierarchyFor(IType type) {
            return this.myEntryMap.containsKey(type);
        }

        public ITypeHierarchy getHierarchy(IType type) throws JavaModelException {
            Object value = this.myEntryMap.get(type);
            if (value != null) {
                return (ITypeHierarchy)value;
            }
            return this.internalAddHierarchy(type);
        }

        private ITypeHierarchy internalAddHierarchy(IType type) throws JavaModelException {
            ITypeHierarchy th = type.newSupertypeHierarchy(NULL_PROGRESS);
            if (this.myEntryQueue.size() == this.mySize) {
                this.myEntryMap.remove((IType)this.myEntryQueue.removeLast());
            }
            this.myEntryMap.put(type, th);
            this.myEntryQueue.addFirst(type);
            return th;
        }
    }
}

