/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.inheritance;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.inheritance.Messages;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ConstraintsViolationException;
import com.tssap.selena.model.extension.PropertyConstraintsProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;

public class FinalInheritanceConstraintProvider
implements PropertyConstraintsProvider {
    private final String DESCRIPTION = Messages.getString("FinalInheritanceConstraintProvider.Description");

    public void checkPropertyValue(Element element, String propertyName, String propertyValue) throws ConstraintsViolationException {
        if (propertyValue == null) {
            return;
        }
        try {
            IType t = (IType)ElementUtil.getJavaElement(element);
            String[][] resolved = t.resolveType(propertyValue);
            if (resolved == null) {
                return;
            }
            UniqueName superClassUin = NameUtil.getResolvedTypeUniqueName(element.getModel(), Signature.toQualifiedName((String[])resolved[0]));
            Element superClass = element.getModel().findElement(superClassUin);
            if (superClass == null) {
                return;
            }
            if (superClass.hasProperty("$final")) {
                throw new ConstraintsViolationException(this.DESCRIPTION);
            }
        }
        catch (CoreException ex) {
            JavaProviderPlugin.getDefault().getLog().log((IStatus)new Status(2, ex.getStatus().getPlugin(), ex.getStatus().getCode(), ex.getStatus().getMessage(), ex.getStatus().getException()));
        }
    }
}

