/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.inheritance;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.inheritance.Messages;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.extension.ConstraintsViolationException;
import com.tssap.selena.model.extension.ExistenceConstraintsProvider;
import com.tssap.selena.model.extension.PropertyConstraintsProvider;
import com.tssap.selena.model.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class CyclicInheritanceConstraintsProvider
implements ExistenceConstraintsProvider,
PropertyConstraintsProvider {
    private static final String DESCRIPTION = Messages.getString("CyclicInheritanceConstraintsProvider.CycleInheritanceDescription");

    public void checkConstraintsForUniqueName(Entity parent, String shapeType, Entity template) throws ConstraintsViolationException {
        Entity target;
        if (("Generalization Link".equals(shapeType) || "Implementation Link".equals(shapeType)) && (target = this.getTargetFromTemplate(template)) != null && NameUtil.isJavaElementUniqueName(target.getUniqueName(), false)) {
            IJavaElement javaParent = ElementUtil.getJavaElement((Element)parent);
            IJavaElement javaTarget = ElementUtil.getJavaElement((Element)target);
            if (javaParent instanceof IType && javaTarget instanceof IType && CyclicInheritanceConstraintsProvider.isSuperType((IType)javaTarget, (IType)javaParent)) {
                throw new ConstraintsViolationException(DESCRIPTION);
            }
        }
    }

    public void checkPropertyValue(Element element, String propertyName, String propertyValue) throws ConstraintsViolationException {
        if (propertyValue == null) {
            return;
        }
        IType javaElement = (IType)ElementUtil.getJavaElement(element);
        StringTokenizer st = new StringTokenizer(propertyValue, ",");
        while (st.hasMoreTokens()) {
            HashSet candidates = CyclicInheritanceConstraintsProvider.resolveSingleName(javaElement, st.nextToken(), Collections.EMPTY_MAP);
            if (candidates == null) continue;
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                IType nextCandidate = (IType)it.next();
                if (!javaElement.equals(nextCandidate) && !CyclicInheritanceConstraintsProvider.isSuperType(nextCandidate, javaElement)) continue;
                throw new ConstraintsViolationException(DESCRIPTION);
            }
        }
    }

    private Entity getTargetFromTemplate(Entity template) {
        if (template == null) {
            return null;
        }
        ElementEnumeration supplierEnum = template.participants("Supplier");
        return supplierEnum.hasMoreElements() ? (Entity)supplierEnum.next() : null;
    }

    private static boolean isSuperType(IType child, IType parent) {
        boolean isParentInterface;
        if ("java.lang.Object".equals(parent.getElementName())) {
            return true;
        }
        try {
            if (!parent.isStructureKnown() || !child.isStructureKnown()) {
                return false;
            }
            isParentInterface = parent.isInterface();
        }
        catch (JavaModelException e) {
            return false;
        }
        if (isParentInterface) {
            return CyclicInheritanceConstraintsProvider.isSuperInterface(child, parent, new HashMap());
        }
        return CyclicInheritanceConstraintsProvider.isSuperClass(child, parent, new HashMap());
    }

    private static boolean isSuperClass(IType child, IType parent, HashMap processedQualifiedNames) {
        if (processedQualifiedNames.containsKey(child.getFullyQualifiedName())) {
            return false;
        }
        HashSet directSuperClasses = CyclicInheritanceConstraintsProvider.getDirectSuperClasses(child, processedQualifiedNames);
        if (directSuperClasses == null || directSuperClasses.isEmpty()) {
            return false;
        }
        Iterator it = directSuperClasses.iterator();
        while (it.hasNext()) {
            IType cur;
            block8: {
                cur = (IType)it.next();
                if (cur.getFullyQualifiedName().equals(parent.getFullyQualifiedName())) {
                    return true;
                }
                try {
                    if (!cur.isStructureKnown() || cur.isInterface()) {
                        processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
                    }
                    break block8;
                }
                catch (JavaModelException e) {
                    processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
                }
                continue;
            }
            if (CyclicInheritanceConstraintsProvider.isSuperClass(cur, parent, processedQualifiedNames)) {
                return true;
            }
            processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
        }
        return false;
    }

    private static boolean isSuperInterface(IType child, IType parent, HashMap processedQualifiedNames) {
        HashSet directSuperClasses;
        if (processedQualifiedNames.containsKey(child.getFullyQualifiedName())) {
            return false;
        }
        HashSet directSuperInterfaces = CyclicInheritanceConstraintsProvider.getDirectSuperInterfaces(child, processedQualifiedNames);
        if (directSuperInterfaces != null && !directSuperInterfaces.isEmpty()) {
            Iterator it = directSuperInterfaces.iterator();
            while (it.hasNext()) {
                IType cur;
                block15: {
                    cur = (IType)it.next();
                    if (cur.getFullyQualifiedName().equals(parent.getFullyQualifiedName())) {
                        return true;
                    }
                    try {
                        if (!cur.isStructureKnown() || cur.isClass()) {
                            processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
                        }
                        break block15;
                    }
                    catch (JavaModelException e) {
                        processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
                    }
                    continue;
                }
                if (CyclicInheritanceConstraintsProvider.isSuperInterface(cur, parent, processedQualifiedNames)) {
                    return true;
                }
                processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
            }
        }
        if ((directSuperClasses = CyclicInheritanceConstraintsProvider.getDirectSuperClasses(child, processedQualifiedNames)) == null || directSuperClasses.isEmpty()) {
            return false;
        }
        Iterator it = directSuperClasses.iterator();
        while (it.hasNext()) {
            IType cur;
            block16: {
                cur = (IType)it.next();
                if (cur.getFullyQualifiedName().equals(parent.getFullyQualifiedName())) {
                    return true;
                }
                try {
                    if (!cur.isStructureKnown()) {
                        processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
                    }
                    break block16;
                }
                catch (JavaModelException e) {
                    processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
                }
                continue;
            }
            if (CyclicInheritanceConstraintsProvider.isSuperInterface(cur, parent, processedQualifiedNames)) {
                return true;
            }
            processedQualifiedNames.put(cur.getFullyQualifiedName(), cur);
        }
        return false;
    }

    private static HashSet getDirectSuperClasses(IType type, HashMap toSkip) {
        String superClassName;
        try {
            superClassName = type.getSuperclassName();
        }
        catch (JavaModelException e) {
            return null;
        }
        return CyclicInheritanceConstraintsProvider.resolveSingleName(type, superClassName, toSkip);
    }

    private static HashSet getDirectSuperInterfaces(IType type, HashMap toSkip) {
        String[] superInterfacesNames;
        HashSet result = null;
        try {
            superInterfacesNames = type.getSuperInterfaceNames();
        }
        catch (JavaModelException e) {
            return null;
        }
        if (superInterfacesNames == null || superInterfacesNames.length == 0) {
            return null;
        }
        int i = 0;
        while (i < superInterfacesNames.length) {
            HashSet cur = CyclicInheritanceConstraintsProvider.resolveSingleName(type, superInterfacesNames[i], toSkip);
            if (cur != null) {
                if (result == null) {
                    result = new HashSet();
                }
                result.addAll(cur);
            }
            ++i;
        }
        return result;
    }

    private static HashSet resolveSingleName(IType base, String singleName, Map toSkip) {
        String[][] allResolved;
        if (singleName == null) {
            return null;
        }
        HashSet<IType> result = null;
        try {
            allResolved = base.resolveType(singleName);
        }
        catch (JavaModelException e) {
            return null;
        }
        if (allResolved == null || allResolved.length == 0) {
            return null;
        }
        int i = 0;
        while (i < allResolved.length) {
            block10: {
                String curQualifiedName;
                String[] cur = allResolved[i];
                Assert.isLegal((cur.length == 2 ? 1 : 0) != 0);
                String string = curQualifiedName = "".equals(cur[0]) ? cur[1] : cur[0] + "." + cur[1];
                if (!toSkip.containsKey(curQualifiedName)) {
                    IType curType = null;
                    try {
                        curType = base.getJavaProject().findType(curQualifiedName);
                    }
                    catch (JavaModelException e) {
                        break block10;
                    }
                    if (curType != null && curType.exists()) {
                        if (result == null) {
                            result = new HashSet<IType>(allResolved.length * 2);
                        }
                        result.add(curType);
                    }
                }
            }
            ++i;
        }
        return result;
    }
}

