/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.editor;

import com.tssap.selena.internal.core.providers.java.editor.IJavaEditorListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JavaEditorPart {
    private static int F_OPENED = 1;
    private static int F_SAVED = 2;
    private static int F_CHANGED = 3;
    private static int F_CLOSED = 4;
    private static boolean ourIsAdded;
    private static ArrayList ourJavaEditorListeners;
    private static IWorkingCopyManager ourWorkingCopyManager;

    public static void startup() {
        ourJavaEditorListeners = new ArrayList();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ourWorkingCopyManager = JavaUI.getWorkingCopyManager();
            }
        });
        JavaEditorPart.listenPartService();
    }

    public static void shutdown() {
    }

    public static synchronized void addJavaEditorListener(IJavaEditorListener javaEditorListener) {
        if (javaEditorListener != null && !ourJavaEditorListeners.contains(javaEditorListener)) {
            ourJavaEditorListeners.add(javaEditorListener);
            JavaEditorPart.initialNotifyListener(javaEditorListener);
        }
    }

    public static synchronized void removeJavaEditorListener(IJavaEditorListener javaEditorListener) {
        if (javaEditorListener != null) {
            ((AbstractCollection)ourJavaEditorListeners).remove(javaEditorListener);
        }
    }

    private static JavaEditor[] getJavaEditors() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return new JavaEditor[0];
        }
        IPartService partService = window.getPartService();
        if (partService == null) {
            return new JavaEditor[0];
        }
        IWorkbenchPage[] pages = window.getPages();
        ArrayList<CompilationUnitEditor> editors = new ArrayList<CompilationUnitEditor>();
        int i = 0;
        while (i < pages.length) {
            IEditorPart[] editorParts = pages[i].getEditors();
            int j = 0;
            while (j < editorParts.length) {
                if (editorParts[i] instanceof CompilationUnitEditor) {
                    CompilationUnitEditor cuEditor = (CompilationUnitEditor)editorParts[i];
                    editors.add(cuEditor);
                }
                ++j;
            }
            ++i;
        }
        return editors.toArray(new JavaEditor[editors.size()]);
    }

    private static void initialNotifyListener(final IJavaEditorListener javaEditorListener) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                JavaEditor[] editors = JavaEditorPart.getJavaEditors();
                int i = 0;
                while (i < editors.length) {
                    JavaEditorPart.notifyListeners((IWorkbenchPart)editors[i], javaEditorListener, F_OPENED);
                    ++i;
                }
            }
        });
    }

    private static void listenPartService() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (!ourIsAdded && window != null) {
            IPartService partService = window.getPartService();
            if (partService == null) {
                return;
            }
            IWorkbenchPage[] pages = window.getPages();
            int i = 0;
            while (i < pages.length) {
                IEditorReference[] ers = pages[i].getEditorReferences();
                int j = 0;
                while (j < ers.length) {
                    String id = ers[j].getId();
                    if ("org.eclipse.jdt.ui.CompilationUnitEditor".equals(id)) {
                        IEditorPart p = ers[j].getEditor(true);
                        JavaEditorPart.addSaveListener((IWorkbenchPart)p);
                    }
                    ++j;
                }
                ++i;
            }
            partService.addPartListener(new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                    JavaEditorPart.addSaveListener(part);
                    JavaEditorPart.notifyListeners(part, F_OPENED);
                }

                public void partClosed(IWorkbenchPart part) {
                    JavaEditorPart.notifyListeners(part, F_CLOSED);
                }
            });
            ourIsAdded = true;
        }
    }

    private static void addSaveListener(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            final IEditorPart editorPart = (IEditorPart)part;
            editorPart.addPropertyListener(new IPropertyListener(){
                private boolean myIsChanged = false;

                public void propertyChanged(Object source, int propId) {
                    if (!editorPart.isDirty() && propId == 257) {
                        if (this.myIsChanged) {
                            JavaEditorPart.notifyListeners((IWorkbenchPart)editorPart, F_SAVED);
                        }
                        this.myIsChanged = false;
                    } else if (editorPart.isDirty() && propId == 257) {
                        JavaEditorPart.notifyListeners((IWorkbenchPart)editorPart, F_CHANGED);
                        this.myIsChanged = true;
                    }
                }
            });
        }
    }

    private static void notifyListeners(IWorkbenchPart part, int kind) {
        ArrayList arrayList = ourJavaEditorListeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < ourJavaEditorListeners.size()) {
                IJavaEditorListener javaEditorListener = (IJavaEditorListener)ourJavaEditorListeners.get(i);
                JavaEditorPart.notifyListeners(part, javaEditorListener, kind);
                ++i;
            }
        }
    }

    private static void notifyListeners(IWorkbenchPart part, IJavaEditorListener javaEditorListener, int kind) {
        if (part instanceof IEditorPart) {
            ICompilationUnit compilationUnit;
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            if (ourWorkingCopyManager != null && (compilationUnit = ourWorkingCopyManager.getWorkingCopy(input)) != null && compilationUnit.exists()) {
                boolean isDirty = editorPart.isDirty();
                if (kind == F_OPENED) {
                    javaEditorListener.compilationUnitOpened(compilationUnit);
                } else if (kind == F_SAVED) {
                    javaEditorListener.compilationUnitSaved(compilationUnit);
                } else if (kind == F_CHANGED) {
                    javaEditorListener.compilationUnitChanged(compilationUnit);
                } else if (kind == F_CLOSED) {
                    javaEditorListener.compilationUnitClosed(compilationUnit, isDirty);
                }
            }
        }
    }

    private static IPartService getPartService() {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null) {
            int i = 0;
            while (i < windows.length) {
                IPartService partService = windows[i].getPartService();
                if (partService != null) {
                    return partService;
                }
                ++i;
            }
        }
        return null;
    }
}

