/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.designlinks;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;

abstract class LnkExtractorContext {
    private static final State myInType = new InType();
    private static final State myInComment = new ProbablyInComment();
    private static final State myInMultilineComment = new InMultilineComment();
    private static final State myInSingleLineComment = new InSingleLineComment();
    private static final State myInJavadoc = new InJavadoc();
    private static final State myInDesignComment = new InDesignComment();
    private static final State myInBareComment = new InBareComment();
    private static final State myProbablyBareCommentEnd = new ProbablyBareCommentEnd();
    private static final State myProbablyJavadocEnd = new ProbablyJavadocEnd();
    private static final State myProbablyDesignCommentEnd = new ProbablyDesignCommentEnd();
    private static final State myProbablyDesignCommentFollow1 = new ProbablyDesignCommentFollow1();
    private static final State myProbablyDesignCommentFollow2 = new ProbablyDesignCommentFollow2();
    private static final State myProbablyDesignCommentFollow3 = new ProbablyDesignCommentFollow3();
    private String mySourceCode;
    private StringBuffer myComment;
    private int myCommentStart;
    private int myCurrentPos;

    LnkExtractorContext(String sourceCode) {
        this.mySourceCode = sourceCode;
        this.clearComment();
        this.myCurrentPos = -1;
    }

    void run() {
        int size = this.mySourceCode.length() - 1;
        State aState = myInType;
        while (this.myCurrentPos < size) {
            aState = aState.nextChar(this);
        }
    }

    private char getNext() {
        ++this.myCurrentPos;
        return this.mySourceCode.charAt(this.myCurrentPos);
    }

    private void startComment() {
        this.myComment = new StringBuffer();
        this.myCommentStart = this.myCurrentPos;
    }

    private void clearComment() {
        this.myComment = null;
        this.myCommentStart = -1;
    }

    private void commentEnd() {
        this.oneMoreDesignComment(this.myComment.toString(), this.myCommentStart, this.myCurrentPos);
        this.clearComment();
    }

    private void appendCurrent() {
        this.myComment.append(this.mySourceCode.charAt(this.myCurrentPos));
    }

    private void appendNext() {
        this.myComment.append(this.mySourceCode.charAt(this.myCurrentPos + 1));
    }

    private void appendToComment(String s) {
        this.myComment.append(s);
    }

    protected abstract void oneMoreDesignComment(String var1, int var2, int var3);

    private static class ProbablyDesignCommentFollow3
    implements State {
        private ProbablyDesignCommentFollow3() {
        }

        public State nextChar(LnkExtractorContext context) {
            char next = context.getNext();
            if (next == '#') {
                context.appendToComment(JavaProviderPlugin.EOL + "/*#");
                return myInDesignComment;
            }
            if (next == '*') {
                context.startComment();
                context.appendToComment("/**");
                return myInJavadoc;
            }
            context.clearComment();
            return myInBareComment;
        }
    }

    private static class ProbablyDesignCommentFollow2
    implements State {
        private ProbablyDesignCommentFollow2() {
        }

        public State nextChar(LnkExtractorContext context) {
            char next = context.getNext();
            if (next == '*') {
                return myProbablyDesignCommentFollow3;
            }
            context.clearComment();
            if (next == '/') {
                return myInSingleLineComment;
            }
            return myInType;
        }
    }

    private static class ProbablyDesignCommentFollow1
    implements State {
        private ProbablyDesignCommentFollow1() {
        }

        public State nextChar(LnkExtractorContext context) {
            char next = context.getNext();
            if (Character.isWhitespace(next)) {
                return this;
            }
            if (next == '/') {
                return myProbablyDesignCommentFollow2;
            }
            context.clearComment();
            return myInType;
        }
    }

    private static class ProbablyDesignCommentEnd
    implements State {
        private ProbablyDesignCommentEnd() {
        }

        public State nextChar(LnkExtractorContext context) {
            context.appendNext();
            if (context.getNext() == '/') {
                context.commentEnd();
                return myInType;
            }
            return myInDesignComment;
        }
    }

    private static class ProbablyJavadocEnd
    implements State {
        private ProbablyJavadocEnd() {
        }

        public State nextChar(LnkExtractorContext context) {
            context.appendNext();
            if (context.getNext() == '/') {
                return myProbablyDesignCommentFollow1;
            }
            return myInJavadoc;
        }
    }

    private static class ProbablyBareCommentEnd
    implements State {
        private ProbablyBareCommentEnd() {
        }

        public State nextChar(LnkExtractorContext context) {
            if (context.getNext() == '/') {
                return myInType;
            }
            return myInBareComment;
        }
    }

    private static class InDesignComment
    implements State {
        private InDesignComment() {
        }

        public State nextChar(LnkExtractorContext context) {
            context.appendNext();
            if (context.getNext() == '*') {
                return myProbablyDesignCommentEnd;
            }
            return this;
        }
    }

    private static class InJavadoc
    implements State {
        private InJavadoc() {
        }

        public State nextChar(LnkExtractorContext context) {
            context.appendNext();
            if (context.getNext() == '*') {
                return myProbablyJavadocEnd;
            }
            return this;
        }
    }

    private static class InBareComment
    implements State {
        private InBareComment() {
        }

        public State nextChar(LnkExtractorContext context) {
            if (context.getNext() == '*') {
                return myProbablyBareCommentEnd;
            }
            return this;
        }
    }

    private static class InMultilineComment
    implements State {
        private InMultilineComment() {
        }

        public State nextChar(LnkExtractorContext context) {
            char next = context.getNext();
            if (next == '*') {
                context.appendCurrent();
                return myInJavadoc;
            }
            if (next == '#') {
                context.appendCurrent();
                return myInDesignComment;
            }
            return myInBareComment;
        }
    }

    private static class InSingleLineComment
    implements State {
        private InSingleLineComment() {
        }

        public State nextChar(LnkExtractorContext context) {
            char ch = context.getNext();
            if (ch == '\n' || ch == '\r') {
                return myInType;
            }
            return this;
        }
    }

    private static class ProbablyInComment
    implements State {
        private ProbablyInComment() {
        }

        public State nextChar(LnkExtractorContext context) {
            char next = context.getNext();
            if (next == '*') {
                context.appendCurrent();
                return myInMultilineComment;
            }
            if (next == '/') {
                return myInSingleLineComment;
            }
            return myInType;
        }
    }

    private static class InType
    implements State {
        private InType() {
        }

        public State nextChar(LnkExtractorContext context) {
            if (context.getNext() == '/') {
                context.startComment();
                context.appendCurrent();
                return myInComment;
            }
            return this;
        }
    }

    private static interface State {
        public State nextChar(LnkExtractorContext var1);
    }
}

