/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.designlinks;

import com.tssap.selena.internal.core.providers.java.designlinks.IExSourceReference;
import com.tssap.selena.internal.core.providers.java.designlinks.LnkExtractorContext;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;

class LinkExtractor {
    private Collection myDesignLinks;

    public static ISourceReference[] getLinks(String typeSource, int fileOffSet) {
        LinkExtractor dlp = new LinkExtractor();
        dlp.parse(typeSource, fileOffSet);
        return dlp.getDesignLinks();
    }

    public void parse(String sourceCode, final int fileOffSet) {
        this.myDesignLinks = new ArrayList();
        int size = sourceCode.length();
        new LnkExtractorContext(sourceCode){

            protected void oneMoreDesignComment(String comment, int commentStart, int commentEnd) {
                NaiveSourceRangeImpl sourceRange = new NaiveSourceRangeImpl(commentStart, commentEnd - commentStart + 1);
                NaiveSourceRangeImpl fileSourceRange = new NaiveSourceRangeImpl(fileOffSet + commentStart, comment.length());
                LinkExtractor.this.myDesignLinks.add(new NaiveSourceReferenceImpl(comment, sourceRange, fileSourceRange));
            }
        }.run();
    }

    public ISourceReference[] getDesignLinks() {
        return this.myDesignLinks.toArray(new ISourceReference[this.myDesignLinks.size()]);
    }

    private static class NaiveSourceReferenceImpl
    implements IExSourceReference {
        private final String mySource;
        private final ISourceRange mySourceRange;
        private final ISourceRange myFileSourceRange;

        private NaiveSourceReferenceImpl(String source, ISourceRange sourceRange, ISourceRange fileSourceRange) {
            this.mySource = source;
            this.mySourceRange = sourceRange;
            this.myFileSourceRange = fileSourceRange;
        }

        public boolean exists() {
            return true;
        }

        public String getSource() throws JavaModelException {
            return this.mySource;
        }

        public ISourceRange getSourceRange() throws JavaModelException {
            return this.mySourceRange;
        }

        public ISourceRange getFileSourceRange() {
            return this.myFileSourceRange;
        }
    }

    private static class NaiveSourceRangeImpl
    implements ISourceRange {
        private final int myOffset;
        private final int myLength;

        private NaiveSourceRangeImpl(int offset, int length) {
            this.myOffset = offset;
            this.myLength = length;
            if (this.myOffset < 0 || this.myLength <= 0) {
                throw new IllegalArgumentException("offset:" + offset + ", length:" + length);
            }
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getLength() {
            return this.myLength;
        }
    }
}

