/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.designlinks;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.Formatter;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.designlinks.DependencyLinkImpl;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLink;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLinkParser;
import com.tssap.selena.internal.core.providers.java.designlinks.LinkExtractor;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ISynchronizer;
import com.tssap.selena.java.javacomment.internal.JavaCommentsPlugin;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;
import org.eclipse.jdt.internal.core.jdom.DOMBuilder;
import org.eclipse.jdt.internal.core.jdom.DOMNode;

public class DependencyLinkParserImpl
implements IDependencyLinkParser {
    private IType myType;
    private IJavaProject myJavaProject;
    private HashMap myDependencyLinks;
    private final ArrayList myLinksOrder = new ArrayList();
    private static final String COMMENT_PREFIX = "/*";
    private static final String LINK_PREFIX = "/*#";
    private static final String LINK_POSTFIX = "*/";
    private static final char COMMENT_SPECIAL_CHAR = '*';
    private static final char TAB = '\t';
    private static final char LR = '\r';
    private static final char LN = '\n';

    public DependencyLinkParserImpl(IJavaProject javaProject, IType type) {
        this.myType = type;
        this.myJavaProject = javaProject;
    }

    public boolean canAddDependencyLink(String name, String type) {
        return this.isWritable() && this.isValid();
    }

    public void addDependencyLink(String name, String type) {
        if (this.canAddDependencyLink(name, type)) {
            IJavaComment javaComment = this.getJavaComment(null);
            DependencyLinkImpl dependencyLink = new DependencyLinkImpl(this, name, type, javaComment);
            String linkContent = this.getLinkContent(dependencyLink);
            ISourceReference linkSourceReference = this.findNextSourceReference(linkContent);
            if (linkSourceReference != null) {
                dependencyLink.setSourceReference(linkSourceReference);
                this.putDependencyLink(linkSourceReference, dependencyLink);
                this.markAsChanged();
            } else {
                System.err.println("can not find source range for new dependency link");
            }
        }
    }

    boolean isWritable() {
        return ElementUtil.isWritableElement((IJavaElement)this.myType);
    }

    boolean isValid() {
        return this.myType.exists();
    }

    public IDependencyLink getDependencyLink(String name) {
        if (name != null && name.length() != 0) {
            Enumeration enumeration = this.getDependencyLinks();
            while (enumeration.hasMoreElements()) {
                IDependencyLink dependencyLink = (IDependencyLink)enumeration.nextElement();
                if (!name.equals(dependencyLink.getName())) continue;
                return dependencyLink;
            }
        }
        return null;
    }

    public Enumeration getDependencyLinks() {
        if (this.myDependencyLinks == null) {
            this.myDependencyLinks = new HashMap();
            this.myLinksOrder.clear();
            try {
                String source = this.myType.getSource();
                int offset = this.myType.getSourceRange().getOffset();
                if (source != null && source.indexOf(LINK_PREFIX) != -1) {
                    ISourceReference[] sourceReferences = LinkExtractor.getLinks(source, offset);
                    int i = 0;
                    while (i < sourceReferences.length) {
                        ISourceReference sourceReference = sourceReferences[i];
                        this.parseDependencyLinks(sourceReference);
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        if (this.myDependencyLinks.isEmpty()) {
            return EmptyEnumeration.getEnumeration();
        }
        Iterator itr = this.myDependencyLinks.values().iterator();
        Hashtable<IDependencyLink, IDependencyLink> allDependencyLinks = new Hashtable<IDependencyLink, IDependencyLink>();
        while (itr.hasNext()) {
            IDependencyLink dependencyLink = (IDependencyLink)itr.next();
            allDependencyLinks.put(dependencyLink, dependencyLink);
        }
        return allDependencyLinks.elements();
    }

    public void markAsChanged() {
        try {
            String newContent = this.getTypeContent();
            if (newContent != null) {
                PropertyOperationUtil.doPropertyOperation(this.myJavaProject, (IJavaElement)this.myType, true, null, (Object)newContent, null, (PropertyOperation)new MySetPropertyOperation());
                this.myDependencyLinks = null;
                this.myLinksOrder.clear();
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    private void parseDependencyLinks(ISourceReference sourceReference) {
        String rawContent;
        try {
            rawContent = sourceReference.getSource();
        }
        catch (JavaModelException e) {
            return;
        }
        String clearedContent = DependencyLinkParserImpl.getSubstringBetween(rawContent, LINK_PREFIX, LINK_POSTFIX);
        if (clearedContent == null) {
            return;
        }
        clearedContent = this.removeSpecialCharsters(clearedContent);
        String leadingComment = rawContent.substring(0, rawContent.indexOf(LINK_PREFIX));
        IJavaComment javaComment = this.getJavaComment(leadingComment);
        String linkName = null;
        String linkType = null;
        StringTokenizer fieldParser = new StringTokenizer(clearedContent, " ;\n\r\t");
        while (fieldParser.hasMoreTokens()) {
            linkType = linkName;
            linkName = fieldParser.nextToken();
        }
        if (linkType == null || linkName == null) {
            return;
        }
        DependencyLinkImpl dependencyLink = new DependencyLinkImpl(this, linkName, linkType, javaComment, sourceReference);
        this.putDependencyLink(sourceReference, dependencyLink);
    }

    private void putDependencyLink(ISourceReference sourceReference, IDependencyLink dependencyLink) {
        this.myDependencyLinks.put(sourceReference, dependencyLink);
        this.myLinksOrder.add(sourceReference);
    }

    private String getTypeContent() {
        try {
            String source = this.myType.getSource();
            this.myType.getNameRange();
            String newSource = "";
            int prevOffSet = 0;
            int i = 0;
            while (i < this.myLinksOrder.size()) {
                ISourceReference sourceReference = (ISourceReference)this.myLinksOrder.get(i);
                ISourceRange sourceRange = sourceReference.getSourceRange();
                newSource = newSource + source.substring(prevOffSet, sourceRange.getOffset());
                prevOffSet = sourceRange.getOffset() + sourceRange.getLength();
                IDependencyLink dependencyLink = (IDependencyLink)this.myDependencyLinks.get(sourceReference);
                String newContent = "";
                IJavaComment javaComment = dependencyLink.getJavaComment();
                if (javaComment != null && javaComment.getContent() != null) {
                    newContent = newContent + javaComment.getContent() + JavaProviderPlugin.EOL;
                }
                if (dependencyLink.getName() != null) {
                    newContent = newContent + this.getLinkContent(dependencyLink) + JavaProviderPlugin.EOL;
                }
                newSource = newSource + newContent;
                if (i == this.myLinksOrder.size() - 1) {
                    newSource = newSource + source.substring(prevOffSet, source.length());
                }
                ++i;
            }
            return newSource.length() > 0 ? newSource : null;
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    private String getLinkContent(IDependencyLink dependencyLink) {
        return LINK_PREFIX + dependencyLink.getType() + " " + dependencyLink.getName() + LINK_POSTFIX;
    }

    private ISourceReference findNextSourceReference(String source) {
        try {
            if (!this.myLinksOrder.isEmpty()) {
                ISourceReference lastLinkReference = (ISourceReference)this.myLinksOrder.get(this.myLinksOrder.size() - 1);
                ISourceRange lastRange = lastLinkReference.getSourceRange();
                return new NotExistsSourceReference(source, lastRange.getOffset() + lastRange.getLength());
            }
            if (this.myType.hasChildren()) {
                IJavaElement[] children = this.myType.getChildren();
                int minMemberOffset = Integer.MAX_VALUE;
                int i = 0;
                while (i < children.length) {
                    ISourceRange curSourceRange;
                    IJavaElement curChild = children[i];
                    if (curChild instanceof IMember && (curSourceRange = ((IMember)curChild).getSourceRange()).getOffset() < minMemberOffset) {
                        minMemberOffset = curSourceRange.getOffset();
                    }
                    ++i;
                }
                return new NotExistsSourceReference(source, minMemberOffset - this.myType.getSourceRange().getOffset());
            }
            IDOMType domType = new DOMBuilder().createType(this.myType.getSource().toCharArray());
            if (domType instanceof DOMNode) {
                int firstInsertPos = ((DOMNode)domType).getInsertionPosition();
                System.out.println("will be inserted after : " + this.myType.getSource().substring(firstInsertPos));
                return new NotExistsSourceReference(source, firstInsertPos);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    private IJavaComment getJavaComment(final String content) {
        IJavaComment javaComment = JavaCommentsPlugin.getDefault().getJavaCommentParser();
        javaComment.setSynchronizer(new ISynchronizer(){

            public String doSynchronizeFrom() {
                return content;
            }

            public void doSynchronizeTo(String content2) {
                DependencyLinkParserImpl.this.markAsChanged();
            }
        });
        return javaComment;
    }

    private String removeSpecialCharsters(String line) {
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch != '*' && !Character.isWhitespace(ch) && ch != '\t' && ch != '\r' && ch != '\n') break;
            ++i;
        }
        return line.substring(i, line.length()).trim();
    }

    private static String getSubstringBetween(String source, String startSeparator, String endSeparator) {
        int startIndex = source.indexOf(startSeparator);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = source.indexOf(endSeparator, startIndex + startSeparator.length());
        if (endIndex == -1) {
            return null;
        }
        return source.substring(startIndex + startSeparator.length(), endIndex);
    }

    private class NotExistsSourceReference
    implements ISourceReference {
        private String mySource;
        private int myStartOffSet;

        public NotExistsSourceReference(String source, int offset) {
            this.mySource = source;
            this.myStartOffSet = offset;
        }

        public boolean exists() {
            return false;
        }

        public String getSource() throws JavaModelException {
            return this.mySource;
        }

        public ISourceRange getSourceRange() throws JavaModelException {
            return new ISourceRange(this){
                private final /* synthetic */ NotExistsSourceReference this$1;
                {
                    this.this$1 = this$1;
                }

                public int getLength() {
                    return 0;
                }

                public int getOffset() {
                    return NotExistsSourceReference.access$100(this.this$1);
                }
            };
        }

        static /* synthetic */ int access$100(NotExistsSourceReference x0) {
            return x0.myStartOffSet;
        }
    }

    private class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMMember) {
                IDOMMember domMember = (IDOMMember)domNode;
                String newContent = (String)newPropertyValue;
                int nesting = Formatter.getNesting((IMember)javaElement);
                String contents = Formatter.formatBody(newContent, nesting);
                newContent = contents != null ? contents : newContent;
                return newContent;
            }
            return null;
        }
    }
}

