/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.designlinks;

import com.tssap.selena.internal.core.providers.java.designlinks.DependencyLinkParserImpl;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLink;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLinkParser;
import com.tssap.selena.java.javacomment.IJavaComment;
import org.eclipse.jdt.core.ISourceReference;

class DependencyLinkImpl
implements IDependencyLink {
    private ISourceReference mySourceReference;
    private String myName;
    private String myType;
    private IJavaComment myJavaComment;
    private DependencyLinkParserImpl myDesignLinkParser;

    DependencyLinkImpl(IDependencyLinkParser designLinkParser, String name, String type, IJavaComment javaComment) {
        this(designLinkParser, name, type, javaComment, null);
    }

    DependencyLinkImpl(IDependencyLinkParser designLinkParser, String name, String type, IJavaComment javaComment, ISourceReference sourceReference) {
        this.myDesignLinkParser = (DependencyLinkParserImpl)designLinkParser;
        this.myJavaComment = javaComment;
        this.myName = name;
        this.myType = type;
        this.mySourceReference = sourceReference;
    }

    public void setSourceReference(ISourceReference sourceReference) {
        this.mySourceReference = sourceReference;
    }

    public boolean isReadOnly() {
        return !this.myDesignLinkParser.isWritable();
    }

    public void delete() {
        if (!this.isReadOnly()) {
            this.myJavaComment = null;
            this.myName = null;
            this.myDesignLinkParser.markAsChanged();
        }
    }

    public boolean exist() {
        return this.myDesignLinkParser.isValid();
    }

    public IJavaComment getJavaComment() {
        if (this.myJavaComment == null) {
            // empty if block
        }
        return this.myJavaComment;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String newName) {
        if (!this.isReadOnly()) {
            this.myName = newName;
            this.myDesignLinkParser.markAsChanged();
        }
    }

    public String getType() {
        return this.myType;
    }

    public void setType(String newType) {
        if (!this.isReadOnly()) {
            this.myType = newType;
            this.myDesignLinkParser.markAsChanged();
        }
    }

    public ISourceReference getSourceReference() {
        return this.mySourceReference;
    }
}

