/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.ElementsCache;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.internal.core.providers.java.SRTOptionListener;
import com.tssap.selena.internal.core.providers.java.WorkingCopyUtil;
import com.tssap.selena.internal.core.providers.java.delta.CompilationUnitPatcher;
import com.tssap.selena.internal.core.providers.java.delta.JdtDeltaTreeProvider;
import com.tssap.selena.internal.core.providers.java.editor.IJavaEditorListener;
import com.tssap.selena.internal.core.providers.java.editor.JavaEditorPart;
import com.tssap.selena.model.elements.Model;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class WorkingCopyPatcher
implements SRTOptionListener {
    private IJavaEditorListener myJavaEditorListener;
    private static WorkingCopyPatcher ourWorkingCopyPatcher;

    private WorkingCopyPatcher() {
    }

    public static void startup() {
        ourWorkingCopyPatcher = new WorkingCopyPatcher();
        JavaProviderPlugin.addSRTOptionListener(ourWorkingCopyPatcher);
    }

    public static void shutdown() {
        JavaProviderPlugin.removeSRTOptionListener(ourWorkingCopyPatcher);
    }

    public synchronized void onSRT() {
        this.myJavaEditorListener = new MyJavaEditorListener();
        JavaEditorPart.addJavaEditorListener(this.myJavaEditorListener);
    }

    public synchronized void offSRT() {
        JavaEditorPart.removeJavaEditorListener(this.myJavaEditorListener);
        this.myJavaEditorListener = null;
    }

    private class MyJavaEditorListener
    implements IJavaEditorListener {
        private ArrayList myProcessedCompilationUnit = new ArrayList();

        private MyJavaEditorListener() {
        }

        public void compilationUnitOpened(ICompilationUnit compilationUnit) {
        }

        public void compilationUnitChanged(ICompilationUnit compilationUnit) {
            IJavaProject javaProject = compilationUnit.getJavaProject();
            IJavaProject[] javaProjects = ProjectUtil.getReferencingProjects(javaProject);
            if (!this.myProcessedCompilationUnit.contains(compilationUnit.getHandleIdentifier())) {
                Model[] models = ProjectUtil.getReferencingModels(javaProjects);
                int i = 0;
                while (i < models.length) {
                    Model model = models[i];
                    ElementsCache elementsCache = ElementCacheAccess.getElementsCache(model.getUniqueName());
                    WorkingCopyUtil.processWorkingCopy(elementsCache, (IJavaElement)compilationUnit, true);
                    ++i;
                }
                this.myProcessedCompilationUnit.add(compilationUnit.getHandleIdentifier());
            }
            CompilationUnitPatcher.addDropingCompilationUnit(compilationUnit, javaProjects);
            CompilationUnitPatcher.asyncDropCompilationUnitCache();
        }

        public void compilationUnitSaved(ICompilationUnit compilationUnit) {
            this.closed(compilationUnit);
            JdtDeltaTreeProvider.putSkippingCompilationUnit(compilationUnit);
        }

        public void compilationUnitClosed(ICompilationUnit compilationUnit, boolean isDirty) {
            this.closed(compilationUnit);
        }

        private void closed(ICompilationUnit compilationUnit) {
            String handleIdentifier = compilationUnit.getHandleIdentifier();
            if (this.myProcessedCompilationUnit.contains(handleIdentifier)) {
                IJavaProject javaProject = compilationUnit.getJavaProject();
                IJavaProject[] javaProjects = ProjectUtil.getReferencingProjects(javaProject);
                Model[] models = ProjectUtil.getReferencingModels(javaProjects);
                int i = 0;
                while (i < models.length) {
                    Model model = models[i];
                    ElementsCache elementsCache = ElementCacheAccess.getElementsCache(model.getUniqueName());
                    WorkingCopyUtil.processWorkingCopy(elementsCache, (IJavaElement)compilationUnit, false);
                    elementsCache.dropTemporarilyTopLevelChildren(compilationUnit);
                    ++i;
                }
                ((AbstractCollection)this.myProcessedCompilationUnit).remove(handleIdentifier);
            }
        }
    }
}

