/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.internal.core.providers.java.delta.JdtModelDeltaNode;
import com.tssap.selena.internal.java.diff.JavaDiffElement;
import com.tssap.selena.internal.java.diff.TypeInspector;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMType;

abstract class TotalyChangedTypeInspector
implements TypeInspector {
    protected boolean myIsTotal;
    protected String myRoot;
    protected Model myModel;
    protected String myTypeName;
    protected String myTypeFullName;
    protected String myPackageName;
    protected ICompilationUnit myCompilationUnit;
    protected IJavaProject myJavaProject;
    protected IType myType;
    protected ArrayList myDeltaNodes = new ArrayList();

    TotalyChangedTypeInspector(Model model, IJavaProject javaProject, ICompilationUnit compilationUnit, String root) {
        this.myCompilationUnit = compilationUnit;
        this.myJavaProject = javaProject;
        this.myRoot = root;
        this.myModel = model;
        this.myPackageName = compilationUnit.getParent().getElementName();
        this.myPackageName = this.myPackageName.length() > 0 ? this.myPackageName + "." : this.myPackageName;
        this.myTypeName = compilationUnit.getElementName();
        int index = this.myTypeName.indexOf(".java");
        this.myTypeName = this.myTypeName.substring(0, index);
        this.myTypeFullName = this.myPackageName + this.myTypeName;
        this.myType = compilationUnit.getType(this.myTypeName);
        this.myType = this.myType != null && this.myType.exists() ? this.myType : null;
    }

    public void inspectImport(JavaDiffElement type) {
        this.myIsTotal = true;
    }

    public void inspectField(JavaDiffElement field) {
        try {
            IJavaElement javaElement;
            IDOMField newDomField;
            String content = field.getSource();
            if (content != null && (newDomField = new DOMFactory().createField(content)) != null && this.myType != null && (javaElement = newDomField.getJavaElement((IJavaElement)this.myType)) instanceof IField) {
                IField fld = (IField)javaElement;
                UniqueName uniqueName = NameUtil.getFieldUniqueName(this.myJavaProject, fld);
                JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, uniqueName, uniqueName, this.getNodeKind(), true);
                this.myDeltaNodes.add(deltaNode);
                if (TypeNameUtil.isNonPrimitiveType(newDomField.getType())) {
                    uniqueName = NameUtil.getAssociationNodeUniqueName(this.myJavaProject, fld);
                    deltaNode = new JdtModelDeltaNode(this.myModel, uniqueName, uniqueName, this.getNodeKind(), true);
                    this.myDeltaNodes.add(deltaNode);
                }
            }
        }
        catch (Exception e) {
            this.myIsTotal = true;
        }
    }

    public void inspectMethod(JavaDiffElement method) {
        try {
            IJavaElement javaElement;
            IDOMMethod newDomMethod;
            String content = method.getSource();
            if (content != null && (newDomMethod = new DOMFactory().createMethod(content)) != null && this.myType != null && (javaElement = newDomMethod.getJavaElement((IJavaElement)this.myType)) instanceof IMethod) {
                UniqueName uniqueName = NameUtil.getMethodUniqueName(this.myJavaProject, (IMethod)javaElement);
                JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, uniqueName, uniqueName, this.getNodeKind(), true);
                this.myDeltaNodes.add(deltaNode);
            }
        }
        catch (Exception e) {
            this.myIsTotal = true;
        }
    }

    public void inspectType(JavaDiffElement type) {
        UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myRoot, this.myTypeFullName);
        JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, uniqueName, uniqueName, this.getNodeKind(), true);
        this.myDeltaNodes.add(deltaNode);
    }

    public void inspectInnerType(JavaDiffElement innerType) {
        try {
            IJavaElement javaElement;
            IDOMType newDomType;
            String content = innerType.getSource();
            if (content != null && (newDomType = new DOMFactory().createType(content)) != null && this.myType != null && (javaElement = newDomType.getJavaElement((IJavaElement)this.myType)) instanceof IType) {
                UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, (IType)javaElement);
                JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, uniqueName, uniqueName, this.getNodeKind(), true);
                this.myDeltaNodes.add(deltaNode);
            }
        }
        catch (Exception e) {
            this.myIsTotal = true;
        }
    }

    public void inspectSupplementaryType(JavaDiffElement supplementaryType) {
        try {
            IJavaElement javaElement;
            IDOMType domType;
            String content = supplementaryType.getSource();
            if (content != null && (domType = new DOMFactory().createType(content)) != null && this.myCompilationUnit != null && (javaElement = domType.getJavaElement((IJavaElement)this.myCompilationUnit)) instanceof IType) {
                UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, (IType)javaElement);
                JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, uniqueName, uniqueName, this.getNodeKind(), true);
                this.myDeltaNodes.add(deltaNode);
            }
        }
        catch (Exception e) {
            this.myIsTotal = true;
        }
    }

    public void inspectJavaDoc(JavaDiffElement javadoc) {
        this.myIsTotal = true;
    }

    public void inspectDesignComment(JavaDiffElement designComment) {
        this.myIsTotal = true;
    }

    public boolean isTotalUpdate() {
        return this.myIsTotal;
    }

    public ArrayList getDeltaNodes() {
        return this.myDeltaNodes;
    }

    protected abstract ModelDeltaNodeKind getNodeKind();
}

