/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.editor.IJavaEditorListener;
import com.tssap.selena.internal.core.providers.java.editor.JavaEditorPart;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;

public class ProcessedCompilationUnits {
    private static IJavaEditorListener myJavaEditorListener = null;
    private static HashMap myProcessedCompilationUnit = new HashMap();

    public static void startup() {
        IJavaEditorListener javaEditorListener = ProcessedCompilationUnits.getJavaEditorListener();
        JavaEditorPart.addJavaEditorListener(javaEditorListener);
    }

    public static void shutdown() {
        IJavaEditorListener javaEditorListener = ProcessedCompilationUnits.getJavaEditorListener();
        JavaEditorPart.removeJavaEditorListener(javaEditorListener);
    }

    static boolean isProcessed(ICompilationUnit compilationUnit, IJavaProject javaProject) {
        Object obj = myProcessedCompilationUnit.get(compilationUnit.getHandleIdentifier());
        if (obj != null) {
            ArrayList list = (ArrayList)obj;
            return list.contains(javaProject);
        }
        return false;
    }

    static void setProcessed(ICompilationUnit compilationUnit, IJavaProject javaProject) {
        Object obj = myProcessedCompilationUnit.get(compilationUnit.getHandleIdentifier());
        if (obj != null) {
            ArrayList list = (ArrayList)obj;
            list.add(javaProject);
        }
    }

    static void unsetProcessed(ICompilationUnit compilationUnit, IJavaProject javaProject) {
        Object obj = myProcessedCompilationUnit.get(compilationUnit.getHandleIdentifier());
        if (obj != null) {
            ArrayList list = (ArrayList)obj;
            ((AbstractCollection)list).remove(javaProject);
        }
    }

    private static IJavaEditorListener getJavaEditorListener() {
        myJavaEditorListener = new MyJavaEditorListener();
        return myJavaEditorListener;
    }

    private static class MyJavaEditorListener
    implements IJavaEditorListener {
        private MyJavaEditorListener() {
        }

        public void compilationUnitOpened(ICompilationUnit compilationUnit) {
            myProcessedCompilationUnit.put(compilationUnit.getHandleIdentifier(), new ArrayList());
        }

        public void compilationUnitChanged(ICompilationUnit compilationUnit) {
        }

        public void compilationUnitSaved(ICompilationUnit compilationUnit) {
        }

        public void compilationUnitClosed(ICompilationUnit compilationUnit, boolean isDirty) {
            myProcessedCompilationUnit.remove(compilationUnit.getHandleIdentifier());
        }
    }
}

