/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class NonPublicTypesPatcher
implements ModelAccessListener {
    private static HashMap ourCu2Types = new HashMap();
    private static NonPublicTypesPatcher ourNonPublicTypesPatcher;

    private NonPublicTypesPatcher() {
    }

    public static void startup() {
        ourNonPublicTypesPatcher = new NonPublicTypesPatcher();
        ModelAccess.addModelAccessListener((ModelAccessListener)ourNonPublicTypesPatcher);
    }

    public static void shutdown() {
        ModelAccess.removeModelAccessListener((ModelAccessListener)ourNonPublicTypesPatcher);
    }

    public void modelCreated(ModelAccessEvent event) {
    }

    public void modelRemoved(ModelAccessEvent event) {
        UniqueName modelUniqueName = event.getModel().getUniqueName();
        String projectName = ModelUinSupport.getProjectId((UniqueName)modelUniqueName);
        String handleIdentifierPart = "=" + projectName + "/<";
        Set set = ((HashMap)ourCu2Types.clone()).keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String handleIdentifier = (String)iter.next();
            if (!handleIdentifier.startsWith(handleIdentifierPart)) continue;
            ourCu2Types.remove(handleIdentifier);
        }
    }

    public static String[] getTypes(ICompilationUnit compilationUnit) {
        return (String[])ourCu2Types.get(compilationUnit.getHandleIdentifier());
    }

    public static void dropTypes(ICompilationUnit compilationUnit) {
        ourCu2Types.remove(compilationUnit.getHandleIdentifier());
    }

    public static void cacheNonPublicTypes(ICompilationUnit compilationUnit) {
        if (compilationUnit == null && !compilationUnit.exists()) {
            return;
        }
        try {
            String publicClassName = compilationUnit.getElementName();
            int index = publicClassName.indexOf(".java");
            publicClassName = publicClassName.substring(0, index);
            IType[] types = compilationUnit.getTypes();
            if (types != null && types.length > 0) {
                ArrayList<String> list = new ArrayList<String>();
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    if (!publicClassName.equals(type.getElementName())) {
                        list.add(type.getElementName());
                    }
                    ++i;
                }
                if (list.size() > 0) {
                    String[] typesNames = list.toArray(new String[list.size()]);
                    ourCu2Types.put(compilationUnit.getHandleIdentifier(), typesNames);
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }
}

