/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IRootManager;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class JdtModelDeltaNode
extends DefaultModelDeltaNode {
    private UniqueName myOriginalUniqueName;
    private IProject myProject;

    public JdtModelDeltaNode(Model model, UniqueName uniqueName, ModelDeltaNodeKind kind, boolean node) {
        super(model, uniqueName, kind, node);
        this.setOriginalUniqueName(uniqueName);
    }

    public JdtModelDeltaNode(Model model, UniqueName uniqueName, UniqueName originalUniqueName, ModelDeltaNodeKind kind, boolean node) {
        super(model, uniqueName, kind, node);
        this.setOriginalUniqueName(originalUniqueName);
    }

    public void setOriginalUniqueName(UniqueName originalUin) {
        this.myOriginalUniqueName = originalUin;
    }

    public UniqueName getOriginalElementUniqueName() {
        return this.myOriginalUniqueName;
    }

    public UniqueName getParentUniqueName() {
        IRootRelativePath relativePath;
        UniqueName uniqueName = this.getElementUniqueName();
        if (NameUtil.isJavaElementUniqueName(uniqueName, false) || NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            return NameUtil.getParentUniqueName(this.getModel().getUniqueName(), uniqueName);
        }
        Element element = this.getElement();
        if (element != null && element.getParent() != null) {
            return element.getParent().getUniqueName();
        }
        IRootManager rootManager = this.getRootManager();
        if (rootManager != null && (relativePath = rootManager.extractRootRelativePath(uniqueName)) != null) {
            RootRelativePath parentPath = RootRelativePath.valueOf((IPath)relativePath.removeLastSegments(1));
            return parentPath.isEmpty() ? this.getModel().getUniqueName() : rootManager.getUniqueName((IRootRelativePath)parentPath);
        }
        return null;
    }

    public TreeModelDeltaNode createParentDeltaNode() {
        return new JdtModelDeltaNode(this.getModel(), this.getParentUniqueName(), ModelDeltaNodeKind.UNKNOWN, true);
    }

    public void mergeModelDeltaNodes(ModelDeltaNode modelDeltaNode) {
        super.mergeModelDeltaNodes(modelDeltaNode);
        UniqueName uniqueName = this.getElementUniqueName();
        if (uniqueName.equals(modelDeltaNode.getElementUniqueName())) {
            UniqueName elementUniqueName = modelDeltaNode.getElementUniqueName();
            UniqueName originalElementUniqueName = modelDeltaNode.getOriginalElementUniqueName();
            if (originalElementUniqueName != null && !elementUniqueName.equals(originalElementUniqueName)) {
                this.myOriginalUniqueName = originalElementUniqueName;
            }
        }
    }

    private IProject getProject() {
        if (this.myProject == null) {
            this.myProject = ModelUinSupport.getProject((UniqueName)this.getModel().getUniqueName());
        }
        return this.myProject;
    }

    private IRootManager getRootManager() {
        return this.getProject() == null ? null : RootManagerAccess.getRootManager((IProject)this.getProject());
    }
}

