/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.CodeUtil;
import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.LinksCache;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.internal.core.providers.java.delta.AddedTypeInspector;
import com.tssap.selena.internal.core.providers.java.delta.ChangedTypeInspector;
import com.tssap.selena.internal.core.providers.java.delta.CompilationUnitStates;
import com.tssap.selena.internal.core.providers.java.delta.DeletedTypeInspector;
import com.tssap.selena.internal.core.providers.java.delta.DumpUtil;
import com.tssap.selena.internal.core.providers.java.delta.JdtDeltaTreeProvider;
import com.tssap.selena.internal.core.providers.java.delta.JdtModelDeltaNode;
import com.tssap.selena.internal.core.providers.java.delta.NonPublicTypesPatcher;
import com.tssap.selena.internal.core.providers.java.delta.ProcessedCompilationUnits;
import com.tssap.selena.internal.core.providers.java.property.JavaCommentsParsersCache;
import com.tssap.selena.internal.core.providers.java.property.TagPropertyProvider;
import com.tssap.selena.internal.java.diff.JavaDiffElement;
import com.tssap.selena.internal.java.diff.JavaDiffRequestor;
import com.tssap.selena.internal.java.diff.JavaDifferencer;
import com.tssap.selena.internal.java.diff.JavaSourceContentsState;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JdtDeltaTreeProvider
extends ModelAwareProvider
implements DeltaTreeProvider {
    private static String ourSkippingCompilationUnit = "";
    private static ArrayList ourProjectsList = new ArrayList();
    private MyModelDeltaNode myModelDeltaNode;
    private LinksCache myLinksCache;
    private Object FLAG = new Object();

    public void registered(Model model) {
        super.registered(model);
        this.initModelDelta();
        this.myLinksCache = ElementCacheAccess.getLinksCache(this.myModelUniqueName);
    }

    public void unregistered(Model model) {
        this.myLinksCache = null;
        if (this.myModelDeltaNode != null) {
            this.myModelDeltaNode.cleanUp();
            this.myModelDeltaNode = null;
        }
        super.unregistered(model);
    }

    public ModelDeltaNode getModelChanges() {
        MyModelDeltaNode toBeReturned = this.myModelDeltaNode;
        if (JavaProviderPlugin.isProviderDumpEnabled()) {
            DumpUtil.dumpModelDelta((ModelDeltaNode)toBeReturned, 0, this.getClass());
        }
        this.initModelDelta();
        return toBeReturned;
    }

    private void initModelDelta() {
        Object object = this.FLAG;
        synchronized (object) {
            if (this.myModelDeltaNode != null) {
                this.myModelDeltaNode.cleanUp();
            }
            this.myModelDeltaNode = new MyModelDeltaNode(this.myModel);
        }
    }

    static void putSkippingCompilationUnit(ICompilationUnit compilationUnit) {
        String string = ourSkippingCompilationUnit;
        synchronized (string) {
            IJavaProject javaProject = compilationUnit.getJavaProject();
            Object[] projectsNames = ProjectUtil.getReferencingProjectsNames(javaProject);
            ourProjectsList = ArrayUtil.toList(projectsNames);
            ourSkippingCompilationUnit = compilationUnit.getHandleIdentifier();
        }
    }

    private static boolean hasSkippingCompilationUnit(ICompilationUnit compilationUnit, IJavaProject javaProject) {
        String string = ourSkippingCompilationUnit;
        synchronized (string) {
            String handleIdentifier = compilationUnit.getHandleIdentifier();
            String projectName = javaProject.getElementName();
            if (ourSkippingCompilationUnit.equals(handleIdentifier) && ourProjectsList.contains(projectName)) {
                ((AbstractCollection)ourProjectsList).remove(projectName);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private class ChangedMethod {
        private String myName;
        private String mySignature;
        private UniqueName myUniqueName;
        private String myTypeHandleIdentifier;

        ChangedMethod(IJavaProject javaProject, IMethod method) {
            this.myUniqueName = NameUtil.getMethodUniqueName(javaProject, method);
            this.myTypeHandleIdentifier = method.getDeclaringType().getHandleIdentifier();
            this.myName = method.getElementName();
            String handleIdentifier = method.getHandleIdentifier();
            String name = "~" + this.myName;
            int index = handleIdentifier.indexOf(name);
            if (index != -1) {
                this.mySignature = handleIdentifier.substring(index + name.length());
            }
        }

        public String getName() {
            return this.myName;
        }

        public String getSignature() {
            return this.mySignature;
        }

        public String getTypeHandleIdentifier() {
            return this.myTypeHandleIdentifier;
        }

        public UniqueName getUniqueName() {
            return this.myUniqueName;
        }
    }

    class MyModelDeltaNode
    extends RootModelDeltaNode
    implements IElementChangedListener {
        private ArrayList myAddedMethods = new ArrayList();

        public MyModelDeltaNode(Model model) {
            super(model);
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        }

        private void cleanUp() {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }

        public void elementChanged(ElementChangedEvent event) {
            Object object = JdtDeltaTreeProvider.this.FLAG;
            synchronized (object) {
                if (JavaProviderPlugin.isJDTDumpEnabled()) {
                    DumpUtil.dumpJDTDelta(event.getDelta(), 0, ((Object)((Object)this)).getClass());
                }
                this.processDelta(event.getDelta());
                if (this.hasChildren()) {
                    JdtDeltaTreeProvider.this.myModel.getExtensionManager().modelContentsChanged();
                }
            }
        }

        private void addDelta(UniqueName modelUniqueName, UniqueName uniqueName, ModelDeltaNodeKind kind) {
            this.addDelta(modelUniqueName, uniqueName, uniqueName, kind, true);
        }

        private void addDelta(UniqueName modelUniqueName, UniqueName uniqueName, UniqueName originalUniqueName, ModelDeltaNodeKind kind) {
            this.addDelta(modelUniqueName, uniqueName, originalUniqueName, kind, true);
        }

        private void addDelta(UniqueName modelUniqueName, UniqueName uniqueName, ModelDeltaNodeKind kind, boolean node) {
            this.addDelta(modelUniqueName, uniqueName, uniqueName, kind, node);
        }

        private void addDelta(UniqueName modelUniqueName, UniqueName uniqueName, UniqueName originalUniqueName, ModelDeltaNodeKind kind, boolean node) {
            Model model = modelUniqueName == null ? this.getModel() : ModelAccess.createModel((UniqueName)modelUniqueName);
            JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(model, uniqueName, originalUniqueName, kind, node);
            this.addDeltaNode((TreeModelDeltaNode)deltaNode);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processDelta(IJavaElementDelta delta) {
            IJavaElementDelta[] childrenDeltas;
            IJavaElement javaElement = delta.getElement();
            if (javaElement.getElementType() > 2) {
                String projectName = javaElement.getJavaProject().getElementName();
                Object[] referencedProjectsNames = ProjectUtil.getReferencedProjectsNames(JdtDeltaTreeProvider.this.myJavaProject);
                if (ArrayUtil.contains(referencedProjectsNames, projectName)) {
                    ICompilationUnit compilationUnit;
                    if (javaElement.getElementType() == 5) {
                        compilationUnit = (ICompilationUnit)javaElement;
                        if (JdtDeltaTreeProvider.hasSkippingCompilationUnit(compilationUnit, JdtDeltaTreeProvider.this.myJavaProject)) {
                            if (ProcessedCompilationUnits.isProcessed(compilationUnit, JdtDeltaTreeProvider.this.myJavaProject) && !this.isJustRenamed(delta)) {
                                ProcessedCompilationUnits.unsetProcessed(compilationUnit, JdtDeltaTreeProvider.this.myJavaProject);
                                return;
                            }
                            ProcessedCompilationUnits.unsetProcessed(compilationUnit, JdtDeltaTreeProvider.this.myJavaProject);
                        } else {
                            ProcessedCompilationUnits.setProcessed(compilationUnit, JdtDeltaTreeProvider.this.myJavaProject);
                        }
                    }
                    if (javaElement.getElementType() > 4) {
                        compilationUnit = JDTUtil.getCompilationUnit(javaElement);
                        if (compilationUnit == null) return;
                        boolean isChangesFromEditor = EditorUtil.isChangedFromEditor(javaElement);
                        if (JavaProviderPlugin.isSRTEnabled() ? isChangesFromEditor && !EditorUtil.isEditorDirty(javaElement) : isChangesFromEditor) {
                            return;
                        }
                    } else {
                        this.processRefPackageDelta(delta);
                    }
                    try {
                        this.processElementDelta(delta);
                    }
                    catch (JavaModelException e) {
                        JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                    }
                }
            }
            if ((childrenDeltas = delta.getAffectedChildren()) == null) return;
            int i = 0;
            while (i < childrenDeltas.length) {
                this.processDelta(childrenDeltas[i]);
                ++i;
            }
        }

        private void processRefPackageDelta(IJavaElementDelta delta) {
            IJavaElement javaElement = delta.getElement();
            if (javaElement instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                String rootLocation = this.getRootLocation(javaElement);
                if ("ref".equals(rootLocation)) {
                    UniqueName uniqueName;
                    UniqueName originalUniqueName = uniqueName = NameUtil.getRefPackageUniqueName(packageFragment);
                    switch (delta.getKind()) {
                        case 1: {
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, originalUniqueName, ModelDeltaNodeKind.NEW);
                            break;
                        }
                        case 2: {
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, originalUniqueName, ModelDeltaNodeKind.DELETED);
                        }
                    }
                }
            }
        }

        private void processElementDelta(IJavaElementDelta delta) throws JavaModelException {
            IJavaElement javaElement = delta.getElement();
            boolean changesFromEditor = EditorUtil.isChangedFromEditor(javaElement);
            String rootLocation = this.getRootLocation(javaElement);
            switch (delta.getKind()) {
                case 1: {
                    UniqueName originalUniqueName;
                    UniqueName uniqueName;
                    if (this.isDuplicatedElement(javaElement, true)) {
                        return;
                    }
                    if (javaElement instanceof IPackageFragment) {
                        return;
                    }
                    IJavaElement movedFromElement = delta.getMovedFromElement();
                    if (changesFromEditor) {
                        if (javaElement instanceof IType) {
                            IType type = (IType)javaElement;
                            originalUniqueName = uniqueName = NameUtil.getTypeUniqueName(JdtDeltaTreeProvider.this.myJavaProject, type);
                            if (this.isJustRenamed(delta)) {
                                originalUniqueName = NameUtil.getTypeUniqueName(JdtDeltaTreeProvider.this.myJavaProject, (IType)movedFromElement);
                            }
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, originalUniqueName, ModelDeltaNodeKind.NEW);
                            this.addedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, (IJavaElement)type, changesFromEditor);
                        } else if (javaElement instanceof IMethod) {
                            IMethod method = (IMethod)javaElement;
                            this.myAddedMethods.add(new ChangedMethod(JdtDeltaTreeProvider.this.myJavaProject, method));
                            originalUniqueName = uniqueName = NameUtil.getMethodUniqueName(JdtDeltaTreeProvider.this.myJavaProject, method);
                            if (this.isJustRenamed(delta)) {
                                originalUniqueName = NameUtil.getMethodUniqueName(JdtDeltaTreeProvider.this.myJavaProject, (IMethod)movedFromElement);
                            }
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, originalUniqueName, ModelDeltaNodeKind.NEW);
                        } else if (javaElement instanceof IField) {
                            IField field = (IField)javaElement;
                            originalUniqueName = uniqueName = NameUtil.getFieldUniqueName(JdtDeltaTreeProvider.this.myJavaProject, field);
                            if (this.isJustRenamed(delta)) {
                                originalUniqueName = NameUtil.getFieldUniqueName(JdtDeltaTreeProvider.this.myJavaProject, (IField)movedFromElement);
                            }
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, ModelDeltaNodeKind.NEW);
                            this.addedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, (IJavaElement)field, changesFromEditor);
                        }
                    } else {
                        Element newElement;
                        if (javaElement instanceof IMethod) {
                            this.myAddedMethods.add(new ChangedMethod(JdtDeltaTreeProvider.this.myJavaProject, (IMethod)javaElement));
                        }
                        if ((newElement = ElementUtil.getModelElement(JdtDeltaTreeProvider.this.myModelUniqueName, javaElement)) != null) {
                            originalUniqueName = uniqueName = newElement.getUniqueName();
                            if (this.isJustRenamed(delta)) {
                                originalUniqueName = NameUtil.getJavaElementUniqueName(JdtDeltaTreeProvider.this.myJavaProject, movedFromElement);
                            }
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, originalUniqueName, ModelDeltaNodeKind.NEW);
                            if (javaElement instanceof IMember) {
                                this.addedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, javaElement, changesFromEditor);
                            }
                        }
                    }
                    if (!(javaElement instanceof ICompilationUnit)) break;
                    if (!changesFromEditor) {
                        ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                        IType[] types = compilationUnit.getTypes();
                        int i = 0;
                        while (i < types.length) {
                            String typeName;
                            int index;
                            UniqueName uniqueName2;
                            UniqueName originalUniqueName2 = uniqueName2 = NameUtil.getTypeUniqueName(JdtDeltaTreeProvider.this.myJavaProject, types[i]);
                            if (this.isJustRenamed(delta) && (index = (typeName = (compilationUnit = (ICompilationUnit)delta.getMovedFromElement()).getElementName()).lastIndexOf(".java")) != -1) {
                                typeName = typeName.substring(0, index);
                                typeName = NameUtil.fixupTypeNameForUIN(typeName);
                                String packageFullName = compilationUnit.getParent().getElementName();
                                typeName = "".equals(packageFullName) ? typeName : packageFullName + "." + typeName;
                                originalUniqueName2 = NameUtil.getTypeUniqueName(rootLocation, typeName);
                            }
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName2, originalUniqueName2, ModelDeltaNodeKind.NEW);
                            this.addedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, javaElement, changesFromEditor);
                            ++i;
                        }
                    }
                    return;
                }
                case 4: {
                    Element changedElement = ElementUtil.getModelElement(JdtDeltaTreeProvider.this.myModelUniqueName, javaElement);
                    int flags = delta.getFlags();
                    if (changedElement != null) {
                        UniqueName uniqueName = changedElement.getUniqueName();
                        if (!NameUtil.isJavaElementUniqueName(uniqueName, false)) break;
                        if (javaElement instanceof IType) {
                            if (flags != 2 && flags != 2048) break;
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, ModelDeltaNodeKind.CHANGED);
                            if (flags != 2048) break;
                            this.changedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, javaElement, changesFromEditor);
                            break;
                        }
                        if (!(javaElement instanceof IMethod) && !(javaElement instanceof IField) || flags != 2 && flags != 1) break;
                        this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, ModelDeltaNodeKind.CHANGED);
                        if (flags != 1) break;
                        this.changedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, javaElement, changesFromEditor);
                        break;
                    }
                    if (javaElement instanceof ICompilationUnit && !changesFromEditor && delta.getAffectedChildren().length == 0) {
                        ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                        ChangedTypeInspector changedInspector = new ChangedTypeInspector(JdtDeltaTreeProvider.this.myModel, JdtDeltaTreeProvider.this.myJavaProject, compilationUnit, "src");
                        AddedTypeInspector addedInspector = new AddedTypeInspector(JdtDeltaTreeProvider.this.myModel, JdtDeltaTreeProvider.this.myJavaProject, compilationUnit, "src");
                        DeletedTypeInspector deletedInspector = new DeletedTypeInspector(JdtDeltaTreeProvider.this.myModel, JdtDeltaTreeProvider.this.myJavaProject, compilationUnit, "src");
                        try {
                            JavaDifferencer.process(new JavaDiffRequestor(this, compilationUnit, addedInspector, changedInspector, deletedInspector){
                                private final /* synthetic */ ICompilationUnit val$compilationUnit;
                                private final /* synthetic */ AddedTypeInspector val$addedInspector;
                                private final /* synthetic */ ChangedTypeInspector val$changedInspector;
                                private final /* synthetic */ DeletedTypeInspector val$deletedInspector;
                                private final /* synthetic */ MyModelDeltaNode this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$compilationUnit = val$compilationUnit;
                                    this.val$addedInspector = val$addedInspector;
                                    this.val$changedInspector = val$changedInspector;
                                    this.val$deletedInspector = val$deletedInspector;
                                }

                                public JavaSourceContentsState getSourceContentsState() {
                                    return new JavaSourceContentsState(this){
                                        private final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        public String getLastState() {
                                            return CompilationUnitStates.getLastState(1.access$4900(this.this$2));
                                        }

                                        public String getPreviousState() {
                                            return CompilationUnitStates.getPreviousState(1.access$4900(this.this$2));
                                        }

                                        public ICompilationUnit getCompilationUnit() {
                                            return 1.access$4900(this.this$2);
                                        }
                                    };
                                }

                                public void added(JavaDiffElement element) {
                                    element.admit(this.val$addedInspector);
                                }

                                public void changed(JavaDiffElement element) {
                                    element.admit(this.val$changedInspector);
                                }

                                public void deleted(JavaDiffElement element) {
                                    element.admit(this.val$deletedInspector);
                                }

                                static /* synthetic */ ICompilationUnit access$4900(1 x0) {
                                    return x0.val$compilationUnit;
                                }
                            });
                            if (changedInspector.isTotalUpdate() || addedInspector.isTotalUpdate() || deletedInspector.isTotalUpdate()) {
                                this.updateCompilationUnit(compilationUnit, changesFromEditor, true);
                            } else {
                                ArrayList deltaNodes = addedInspector.getDeltaNodes();
                                Iterator iter = ((AbstractList)deltaNodes).iterator();
                                while (iter.hasNext()) {
                                    TreeModelDeltaNode deltaNode = (TreeModelDeltaNode)iter.next();
                                    this.addDeltaNode(deltaNode);
                                }
                                deltaNodes = changedInspector.getDeltaNodes();
                                Iterator iter2 = ((AbstractList)deltaNodes).iterator();
                                while (iter2.hasNext()) {
                                    TreeModelDeltaNode deltaNode = (TreeModelDeltaNode)iter2.next();
                                    this.addDeltaNode(deltaNode);
                                }
                                deltaNodes = deletedInspector.getDeltaNodes();
                                Iterator iter3 = ((AbstractList)deltaNodes).iterator();
                                while (iter3.hasNext()) {
                                    TreeModelDeltaNode deltaNode = (TreeModelDeltaNode)iter3.next();
                                    this.addDeltaNode(deltaNode);
                                }
                            }
                            this.updateCompilationUnit(compilationUnit, changesFromEditor, false);
                        }
                        catch (CoreException e) {
                            this.updateCompilationUnit(compilationUnit, changesFromEditor, true);
                        }
                        break;
                    }
                    switch (flags) {
                        case 64: {
                            if (!(javaElement instanceof IPackageFragmentRoot)) break;
                            this.makeTotallyChanged();
                            break;
                        }
                        case 128: {
                            if (!(javaElement instanceof IPackageFragmentRoot)) break;
                            this.makeTotallyChanged();
                        }
                    }
                    break;
                }
                case 2: {
                    if (this.isDuplicatedElement(javaElement, false)) {
                        return;
                    }
                    IJavaElement movedToElement = delta.getMovedToElement();
                    if (javaElement instanceof ICompilationUnit) {
                        if (!changesFromEditor) {
                            IPackageFragment packageFragment = (IPackageFragment)javaElement.getParent();
                            String packageFullName = NameUtil.getPackageQualifiedName(packageFragment);
                            ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                            String typeName = compilationUnit.getElementName();
                            int index = typeName.indexOf(".java");
                            if (index != -1) {
                                UniqueName uniqueName;
                                typeName = typeName.substring(0, index);
                                typeName = NameUtil.fixupTypeNameForUIN(typeName);
                                typeName = "".equals(packageFullName) ? typeName : packageFullName + "." + typeName;
                                UniqueName originalUniqueName = uniqueName = NameUtil.getTypeUniqueName(rootLocation, typeName);
                                if (this.isJustRenamed(delta)) {
                                    ICompilationUnit newCompilationUnit = (ICompilationUnit)delta.getMovedToElement();
                                    IType newType = newCompilationUnit.getTypes()[0];
                                    originalUniqueName = NameUtil.getTypeUniqueName(JdtDeltaTreeProvider.this.myJavaProject, newType);
                                }
                                this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, originalUniqueName, ModelDeltaNodeKind.DELETED);
                            }
                            String[] oldTypesNames = NonPublicTypesPatcher.getTypes(compilationUnit);
                            IType[] addedTypes = JdtDeltaTreeProvider.this.myElementsCache.getAddedTemporarilyTopLevelChildren(compilationUnit);
                            IType[] removedTypes = JdtDeltaTreeProvider.this.myElementsCache.getRemovedTemporarilyTopLevelChildren(compilationUnit);
                            String[] addedTypesNames = this.getNames(addedTypes);
                            String[] removedTypesNames = this.getNames(removedTypes);
                            ArrayList typesNames = this.buildsDifference(oldTypesNames, addedTypesNames, removedTypesNames);
                            int i = 0;
                            while (i < typesNames.size()) {
                                String oldTypeName = (String)typesNames.get(i);
                                typeName = "".equals(packageFullName) ? oldTypeName : packageFullName + "." + oldTypeName;
                                UniqueName uniqueName = NameUtil.getTypeUniqueName(rootLocation, typeName);
                                this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, uniqueName, ModelDeltaNodeKind.DELETED);
                                ++i;
                            }
                        }
                        return;
                    }
                    if (javaElement instanceof IType) {
                        IType type = (IType)javaElement;
                        UniqueName uniqueName = NameUtil.getTypeUniqueName(JdtDeltaTreeProvider.this.myJavaProject, type);
                        UniqueName originalUniqueName = this.isJustRenamed(delta) ? NameUtil.getTypeUniqueName(JdtDeltaTreeProvider.this.myJavaProject, (IType)movedToElement) : uniqueName;
                        this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, originalUniqueName, ModelDeltaNodeKind.DELETED);
                        this.removedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, (IJavaElement)type, changesFromEditor);
                        break;
                    }
                    if (javaElement instanceof IMethod) {
                        IMethod method = (IMethod)javaElement;
                        UniqueName uniqueName = NameUtil.getMethodUniqueName(JdtDeltaTreeProvider.this.myJavaProject, method);
                        UniqueName originalUniqueName = this.isJustRenamed(delta) ? NameUtil.getMethodUniqueName(JdtDeltaTreeProvider.this.myJavaProject, (IMethod)movedToElement) : uniqueName;
                        ChangedMethod removedMethod = new ChangedMethod(JdtDeltaTreeProvider.this.myJavaProject, method);
                        boolean isRenamed = false;
                        Iterator iter = ((AbstractList)this.myAddedMethods).iterator();
                        while (iter.hasNext()) {
                            ChangedMethod addedMethod = (ChangedMethod)iter.next();
                            if (!addedMethod.getTypeHandleIdentifier().equals(removedMethod.getTypeHandleIdentifier()) || !addedMethod.getName().equals(removedMethod.getName()) && !addedMethod.getSignature().equals(removedMethod.getSignature())) continue;
                            UniqueName addedUniqueName = addedMethod.getUniqueName();
                            UniqueName removedUniqueName = removedMethod.getUniqueName();
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, addedUniqueName, removedUniqueName, ModelDeltaNodeKind.NEW);
                            this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, removedUniqueName, addedUniqueName, ModelDeltaNodeKind.DELETED);
                            isRenamed = true;
                        }
                        if (isRenamed) break;
                        this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, uniqueName, originalUniqueName, ModelDeltaNodeKind.DELETED);
                        break;
                    }
                    if (!(javaElement instanceof IField)) break;
                    IField field = (IField)javaElement;
                    UniqueName uniqueName = NameUtil.getFieldUniqueName(JdtDeltaTreeProvider.this.myJavaProject, field);
                    UniqueName originalUniqueName = this.isJustRenamed(delta) ? NameUtil.getFieldUniqueName(JdtDeltaTreeProvider.this.myJavaProject, (IField)movedToElement) : uniqueName;
                    this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, originalUniqueName, uniqueName, ModelDeltaNodeKind.DELETED);
                    this.removedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, (IJavaElement)field, changesFromEditor);
                }
            }
        }

        public void updateCompilationUnit(ICompilationUnit compilationUnit, boolean changesFromEditor, boolean isTotalUpdate) throws JavaModelException {
            IType[] types = compilationUnit.getAllTypes();
            int i = 0;
            while (i < types.length) {
                IType type = types[i];
                if (isTotalUpdate) {
                    UniqueName typeUniqueName = NameUtil.getTypeUniqueName(JdtDeltaTreeProvider.this.myJavaProject, type);
                    this.addDelta(JdtDeltaTreeProvider.this.myModelUniqueName, typeUniqueName, ModelDeltaNodeKind.TOTALLY_CHANGED);
                }
                this.changedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, (IJavaElement)type, changesFromEditor);
                IField[] fields = type.getFields();
                int j = 0;
                while (j < fields.length) {
                    this.changedLink(JdtDeltaTreeProvider.this.myJavaProject, JdtDeltaTreeProvider.this.myModelUniqueName, (IJavaElement)fields[j], changesFromEditor);
                    ++j;
                }
                ++i;
            }
        }

        private boolean isDuplicatedElement(IJavaElement javaElement, boolean whileAdding) throws JavaModelException {
            IJavaElement parentElement;
            String handleIdentifier = javaElement.getHandleIdentifier();
            if (javaElement instanceof IMember && (parentElement = javaElement.getParent()) instanceof IParent) {
                IJavaElement[] chidren = ((IParent)parentElement).getChildren();
                if (whileAdding) {
                    int n = 0;
                    int i = 0;
                    while (i < chidren.length) {
                        if (chidren[i].getHandleIdentifier().equals(handleIdentifier)) {
                            ++n;
                        }
                        ++i;
                    }
                    return n > 1;
                }
                int i = 0;
                while (i < chidren.length) {
                    if (chidren[i].getHandleIdentifier().equals(handleIdentifier)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return false;
        }

        private boolean isJustRenamed(IJavaElementDelta delta) {
            return (0x10 & delta.getFlags()) > 0 || (0x20 & delta.getFlags()) > 0;
        }

        private String[] getNames(IType[] types) {
            if (types != null) {
                String[] names = new String[types.length];
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    names[i] = type.getElementName();
                    names[i] = NameUtil.fixupTypeNameForUIN(names[i]);
                    ++i;
                }
                return names;
            }
            return new String[0];
        }

        private ArrayList buildsDifference(String[] typesNames, String[] addedTypesNames, String[] removedTypesNames) {
            ArrayList oldList = ArrayUtil.toList(typesNames);
            int i = 0;
            while (i < removedTypesNames.length) {
                ((AbstractCollection)oldList).remove(removedTypesNames[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < addedTypesNames.length) {
                oldList.add(addedTypesNames[i2]);
                ++i2;
            }
            return oldList;
        }

        private void addedLink(IJavaProject javaProject, UniqueName modelUniqueName, IJavaElement javaElement, boolean temporarilyChanges) throws JavaModelException {
            if (javaElement instanceof IField) {
                IField field = (IField)javaElement;
                String newType = CodeUtil.getFieldType(field);
                if (newType != null) {
                    UniqueName uniqueName = NameUtil.getAssociationNodeUniqueName(javaProject, field);
                    if (newType != null) {
                        this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyAssociationLink(field, newType);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.addPermanentAssociationLink(field, newType);
                        }
                    }
                }
            } else if (javaElement instanceof IType) {
                IType type = (IType)javaElement;
                if (type.isClass()) {
                    String[] newSuperInterfaceNames;
                    String newSuperclassName = type.getSuperclassName();
                    if (newSuperclassName != null) {
                        UniqueName uniqueName = NameUtil.getGeneralizationNodeUniqueName(javaProject, type, newSuperclassName);
                        this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                        String[] values = new String[]{newSuperclassName};
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyGeneralizationLinks(type, values);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.addPermanentGeneralizationLinks(type, values);
                        }
                    }
                    if ((newSuperInterfaceNames = type.getSuperInterfaceNames()).length != 0) {
                        int i = 0;
                        while (i < newSuperInterfaceNames.length) {
                            UniqueName uniqueName = NameUtil.getImplementaionNodeUniqueName(javaProject, type, newSuperInterfaceNames[i]);
                            this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                            ++i;
                        }
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyImplementationLinks(type, newSuperInterfaceNames);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.addPermanentImplementationLinks(type, newSuperInterfaceNames);
                        }
                    }
                } else {
                    String[] newSuperInterfaceNames = type.getSuperInterfaceNames();
                    if (newSuperInterfaceNames.length != 0) {
                        int i = 0;
                        while (i < newSuperInterfaceNames.length) {
                            UniqueName uniqueName = NameUtil.getImplementaionNodeUniqueName(javaProject, type, newSuperInterfaceNames[i]);
                            this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                            ++i;
                        }
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyGeneralizationLinks(type, newSuperInterfaceNames);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.addPermanentGeneralizationLinks(type, newSuperInterfaceNames);
                        }
                    }
                }
            }
        }

        private void changedLink(IJavaProject javaProject, UniqueName modelUniqueName, IJavaElement javaElement, boolean temporarilyChanges) throws JavaModelException {
            if (javaElement instanceof IField) {
                Enumeration enumeration;
                IJavaComment javaComments;
                IField field = (IField)javaElement;
                UniqueName uniqueName = NameUtil.getAssociationNodeUniqueName(javaProject, field);
                Element element = ElementUtil.getModelElement(modelUniqueName, (IJavaElement)field);
                String refType = null;
                if (element != null && (javaComments = JavaCommentsParsersCache.get(element)).hasTags("@associates") && (enumeration = javaComments.getTags("@associates")).hasMoreElements()) {
                    ITag tag = (ITag)enumeration.nextElement();
                    refType = tag.getValue();
                    refType = TagPropertyProvider.fromDUIN(refType);
                }
                String newType = refType == null ? CodeUtil.getFieldType(field) : refType;
                String oldType = JdtDeltaTreeProvider.this.myLinksCache.getAssociationLinkType(field);
                if (newType != null || oldType != null) {
                    if (newType == null && oldType != null) {
                        this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.DELETED, false);
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.removeTemporarilyAssociationLink(field);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.removePermanentAssociationLink(field);
                        }
                    } else if (newType != null && oldType == null) {
                        this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyAssociationLink(field, newType);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.addPermanentAssociationLink(field, newType);
                        }
                    } else if (!newType.equals(oldType)) {
                        this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.CHANGED, false);
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyAssociationLink(field, newType);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.addPermanentAssociationLink(field, newType);
                        }
                    }
                }
            } else if (javaElement instanceof IType) {
                IType type = (IType)javaElement;
                if (type.isClass()) {
                    String oldSuperclassName;
                    String newSuperclassName = type.getSuperclassName();
                    String[] oldSuperclassNames = JdtDeltaTreeProvider.this.myLinksCache.getGeneralizationLinks(type);
                    String string = oldSuperclassName = oldSuperclassNames.length > 0 ? oldSuperclassNames[0] : null;
                    if (newSuperclassName != null || oldSuperclassName != null) {
                        String[] values;
                        UniqueName uniqueName;
                        if (newSuperclassName == null && oldSuperclassName != null) {
                            uniqueName = NameUtil.getGeneralizationNodeUniqueName(javaProject, type, oldSuperclassName);
                            this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.DELETED, false);
                            if (temporarilyChanges) {
                                JdtDeltaTreeProvider.this.myLinksCache.removeTemporarilyGeneralizationLinks(type);
                            } else {
                                JdtDeltaTreeProvider.this.myLinksCache.removePermanentGeneralizationLinks(type);
                            }
                        } else if (newSuperclassName != null && oldSuperclassName == null) {
                            uniqueName = NameUtil.getGeneralizationNodeUniqueName(javaProject, type, newSuperclassName);
                            this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                            values = new String[]{newSuperclassName};
                            if (temporarilyChanges) {
                                JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyGeneralizationLinks(type, values);
                            } else {
                                JdtDeltaTreeProvider.this.myLinksCache.addPermanentGeneralizationLinks(type, values);
                            }
                        } else if (!newSuperclassName.equals(oldSuperclassName)) {
                            uniqueName = NameUtil.getGeneralizationNodeUniqueName(javaProject, type, newSuperclassName);
                            this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                            uniqueName = NameUtil.getGeneralizationNodeUniqueName(javaProject, type, oldSuperclassName);
                            this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.DELETED, false);
                            values = new String[]{newSuperclassName};
                            if (temporarilyChanges) {
                                JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyGeneralizationLinks(type, values);
                            } else {
                                JdtDeltaTreeProvider.this.myLinksCache.addPermanentGeneralizationLinks(type, values);
                            }
                        }
                    }
                    Object[] newSuperInterfaceNames = type.getSuperInterfaceNames();
                    Object[] oldSuperInterfaceNames = JdtDeltaTreeProvider.this.myLinksCache.getImplementationLinks(type);
                    if (newSuperInterfaceNames.length != 0 || oldSuperInterfaceNames.length != 0) {
                        int i = 0;
                        while (i < newSuperInterfaceNames.length) {
                            if (!ArrayUtil.contains(oldSuperInterfaceNames, newSuperInterfaceNames[i])) {
                                UniqueName uniqueName = NameUtil.getImplementaionNodeUniqueName(javaProject, type, newSuperInterfaceNames[i]);
                                this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                            }
                            ++i;
                        }
                        int i2 = 0;
                        while (i2 < oldSuperInterfaceNames.length) {
                            if (!ArrayUtil.contains(newSuperInterfaceNames, oldSuperInterfaceNames[i2])) {
                                UniqueName uniqueName = NameUtil.getImplementaionNodeUniqueName(javaProject, type, (String)oldSuperInterfaceNames[i2]);
                                this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.DELETED, false);
                            }
                            ++i2;
                        }
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyImplementationLinks(type, (String[])newSuperInterfaceNames);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.addPermanentImplementationLinks(type, (String[])newSuperInterfaceNames);
                        }
                    }
                } else {
                    Object[] newSuperInterfaceNames = type.getSuperInterfaceNames();
                    Object[] oldSuperInterfaceNames = JdtDeltaTreeProvider.this.myLinksCache.getGeneralizationLinks(type);
                    if (newSuperInterfaceNames.length != 0 || oldSuperInterfaceNames.length != 0) {
                        int i = 0;
                        while (i < newSuperInterfaceNames.length) {
                            if (!ArrayUtil.contains(oldSuperInterfaceNames, newSuperInterfaceNames[i])) {
                                UniqueName uniqueName = NameUtil.getGeneralizationNodeUniqueName(javaProject, type, newSuperInterfaceNames[i]);
                                this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.NEW, false);
                            }
                            ++i;
                        }
                        int i3 = 0;
                        while (i3 < oldSuperInterfaceNames.length) {
                            if (!ArrayUtil.contains(newSuperInterfaceNames, oldSuperInterfaceNames[i3])) {
                                UniqueName uniqueName = NameUtil.getGeneralizationNodeUniqueName(javaProject, type, (String)oldSuperInterfaceNames[i3]);
                                this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.DELETED, false);
                            }
                            ++i3;
                        }
                        if (temporarilyChanges) {
                            JdtDeltaTreeProvider.this.myLinksCache.addTemporarilyGeneralizationLinks(type, (String[])newSuperInterfaceNames);
                        } else {
                            JdtDeltaTreeProvider.this.myLinksCache.addPermanentGeneralizationLinks(type, (String[])newSuperInterfaceNames);
                        }
                    }
                }
            }
        }

        private void removedLink(IJavaProject javaProject, UniqueName modelUniqueName, IJavaElement javaElement, boolean temporarilyChanges) {
            if (javaElement instanceof IField) {
                IField field = (IField)javaElement;
                String oldType = JdtDeltaTreeProvider.this.myLinksCache.getAssociationLinkType(field);
                if (oldType != null) {
                    UniqueName uniqueName = NameUtil.getAssociationNodeUniqueName(javaProject, field);
                    this.addDelta(modelUniqueName, uniqueName, ModelDeltaNodeKind.DELETED, false);
                    if (temporarilyChanges) {
                        JdtDeltaTreeProvider.this.myLinksCache.removeTemporarilyAssociationLink(field);
                    } else {
                        JdtDeltaTreeProvider.this.myLinksCache.removePermanentAssociationLink(field);
                    }
                }
            } else if (javaElement instanceof IType) {
                IType type = (IType)javaElement;
                if (temporarilyChanges) {
                    JdtDeltaTreeProvider.this.myLinksCache.removeTemporarilyGeneralizationLinks(type);
                    JdtDeltaTreeProvider.this.myLinksCache.removeTemporarilyImplementationLinks(type);
                } else {
                    JdtDeltaTreeProvider.this.myLinksCache.removePermanentGeneralizationLinks(type);
                    JdtDeltaTreeProvider.this.myLinksCache.removePermanentImplementationLinks(type);
                }
            }
        }

        private boolean hasGeneralizationLink(IType type) throws JavaModelException {
            String[] superInterfaceNames;
            String superClassName;
            return type.isClass() ? (superClassName = type.getSuperclassName()) != null : (superInterfaceNames = type.getSuperInterfaceNames()) != null && superInterfaceNames.length > 0;
        }

        private boolean hasImplementaionLink(IType type) throws JavaModelException {
            String[] superInterfaceNames;
            return type.isClass() && (superInterfaceNames = type.getSuperInterfaceNames()) != null && superInterfaceNames.length > 0;
        }

        private String getRootLocation(IJavaElement javaElement) {
            if (javaElement.getJavaProject().equals(JdtDeltaTreeProvider.this.myJavaProject)) {
                return "src";
            }
            return "ref";
        }
    }
}

