/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import java.util.Enumeration;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;

class DumpUtil {
    DumpUtil() {
    }

    static void dumpModelDelta(ModelDeltaNode modelDeltaNode, int indent, Class clazz) {
        if (indent == 0) {
            System.err.println("Provider " + clazz.getName());
        }
        System.err.print(DumpUtil.getIndent(indent) + "UniqueName " + modelDeltaNode.getElementUniqueName() + " element " + modelDeltaNode.getElement());
        if (modelDeltaNode.isTotallyChanged()) {
            System.err.print(" - totally changed");
        }
        if (modelDeltaNode.isNew()) {
            System.err.print(" - added");
        }
        if (modelDeltaNode.isChanged()) {
            System.err.print(" - changed");
        }
        if (modelDeltaNode.isDeleted()) {
            System.err.print(" - deleted");
        }
        UniqueName originalUniqueName = modelDeltaNode.getOriginalElementUniqueName();
        System.err.print(" - original element " + originalUniqueName);
        System.err.println("");
        Enumeration enumeration = modelDeltaNode.changedChildren();
        while (enumeration.hasMoreElements()) {
            modelDeltaNode = (ModelDeltaNode)enumeration.nextElement();
            DumpUtil.dumpModelDelta(modelDeltaNode, indent + 1, clazz);
        }
    }

    static void dumpJDTDelta(IJavaElementDelta delta, int indent, Class clazz) {
        ICompilationUnit compilationUnit;
        if (indent == 0) {
            System.err.println("Provider " + clazz.getName());
        }
        IJavaElement javaElement = delta.getElement();
        System.err.print(DumpUtil.getIndent(indent) + "JavaElement " + javaElement.getElementName());
        switch (delta.getKind()) {
            case 1: {
                System.err.print(" - added ");
                break;
            }
            case 4: {
                System.err.print(" - changed ");
                break;
            }
            case 2: {
                System.err.print(" - removed ");
            }
        }
        int flags = delta.getFlags();
        if ((flags & 0x10) != 0) {
            System.err.print(" - moved from " + delta.getMovedFromElement().getElementName());
        } else if ((flags & 0x20) != 0) {
            System.err.print(" - moved to " + delta.getMovedToElement().getElementName());
        }
        boolean changesFromEditor = EditorUtil.isChangedFromEditor(javaElement);
        if (changesFromEditor) {
            System.err.print(" - changesFromEditor");
        }
        if ((compilationUnit = JDTUtil.getCompilationUnit(javaElement)) != null) {
            System.err.print(" - isWorkingCopy " + compilationUnit.isWorkingCopy());
        }
        System.err.println("");
        IJavaElementDelta[] javaElementDeltas = delta.getAffectedChildren();
        int i = 0;
        while (i < javaElementDeltas.length) {
            DumpUtil.dumpJDTDelta(javaElementDeltas[i], indent + 1, clazz);
            ++i;
        }
    }

    static String getIndent(int indent) {
        String inds = "";
        int i = 0;
        while (i < indent) {
            inds = "\t" + inds;
            ++i;
        }
        return inds;
    }
}

