/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.delta.DumpUtil;
import com.tssap.selena.internal.core.providers.java.delta.JdtModelDeltaNode;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class DeltaPatcherTreeProvider
extends ModelAwareProvider
implements DeltaTreeProvider {
    private RootModelDeltaNode myModelDeltaNode;
    private static Object FLAG = new Object();
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int TOTALLY_CHANGED = 3;
    public static final int CHANGED = 4;
    private static HashMap myDeltaProviders = new HashMap();
    private static HashMap myJDTAdditionalDeltas = new HashMap();
    private static HashMap myModelAdditionalDeltas = new HashMap();

    public void registered(Model model) {
        myDeltaProviders.put(model, this);
        super.registered(model);
        this.myModelDeltaNode = new RootModelDeltaNode(this.myModel);
    }

    public void unregistered(Model model) {
        myJDTAdditionalDeltas.remove(model);
        myModelAdditionalDeltas.remove(model);
        myDeltaProviders.remove(model);
        super.unregistered(model);
    }

    public ModelDeltaNode getModelChanges() {
        Object object = FLAG;
        synchronized (object) {
            RootModelDeltaNode toBeReturned = this.myModelDeltaNode;
            if (JavaProviderPlugin.isProviderDumpEnabled()) {
                DumpUtil.dumpModelDelta((ModelDeltaNode)toBeReturned, 0, this.getClass());
            }
            this.myModelDeltaNode = new RootModelDeltaNode(this.myModel);
            RootModelDeltaNode rootModelDeltaNode = toBeReturned;
            return rootModelDeltaNode;
        }
    }

    private RootModelDeltaNode getRootModelDeltaNode() {
        Object object = FLAG;
        synchronized (object) {
            RootModelDeltaNode rootModelDeltaNode = this.myModelDeltaNode;
            return rootModelDeltaNode;
        }
    }

    public static void modelChanged(IJavaProject javaProject) {
        Object object = FLAG;
        synchronized (object) {
            UniqueName uniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
            Model model = ModelAccess.createModel((UniqueName)uniqueName);
            DeltaPatcherTreeProvider.modelChanged(model);
        }
    }

    public static void modelChanged(Model model) {
        Object object = FLAG;
        synchronized (object) {
            RootModelDeltaNode modelDeltaNode;
            DeltaPatcherTreeProvider deltaPatcherTreeProvider = (DeltaPatcherTreeProvider)myDeltaProviders.get(model);
            if (deltaPatcherTreeProvider != null && (modelDeltaNode = deltaPatcherTreeProvider.getRootModelDeltaNode()) != null) {
                TreeModelDeltaNode[] deltaNodes = DeltaPatcherTreeProvider.getAdditionalModelElementDelta(model);
                int i = 0;
                while (i < deltaNodes.length) {
                    modelDeltaNode.addDeltaNode(deltaNodes[i]);
                    ++i;
                }
                deltaPatcherTreeProvider.addChangedElement();
                if (modelDeltaNode.hasChildren()) {
                    model.getExtensionManager().modelContentsChanged();
                }
            }
        }
    }

    private void addChangedElement() {
        IJavaElementDelta[] additionalDelta = DeltaPatcherTreeProvider.getAdditionalJavaElementDelta(this.myJavaProject);
        int i = 0;
        while (i < additionalDelta.length) {
            int kind = additionalDelta[i].getKind();
            ModelDeltaNodeKind nodeKind = null;
            if (kind == 1) {
                nodeKind = ModelDeltaNodeKind.NEW;
            } else if (kind == 4) {
                nodeKind = ModelDeltaNodeKind.CHANGED;
            } else if (kind == 3) {
                nodeKind = ModelDeltaNodeKind.TOTALLY_CHANGED;
            } else if (kind == 2) {
                nodeKind = ModelDeltaNodeKind.DELETED;
            }
            IJavaElement javaElement = additionalDelta[i].getElement();
            UniqueName uniqueName = null;
            if (javaElement instanceof ICompilationUnit) {
                IType[] types;
                try {
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                    types = compilationUnit.getAllTypes();
                }
                catch (JavaModelException e) {
                    types = new IType[]{};
                }
                int j = 0;
                while (j < types.length) {
                    uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, types[j]);
                    if (uniqueName != null) {
                        this.addDelta(uniqueName, ModelDeltaNodeKind.TOTALLY_CHANGED, true);
                    }
                    ++j;
                }
            } else {
                if (javaElement instanceof IField) {
                    uniqueName = NameUtil.getFieldUniqueName(this.myJavaProject, (IField)javaElement);
                } else if (javaElement instanceof IMethod) {
                    uniqueName = NameUtil.getMethodUniqueName(this.myJavaProject, (IMethod)javaElement);
                } else if (javaElement instanceof IType) {
                    uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, (IType)javaElement);
                }
                if (uniqueName != null && nodeKind != null) {
                    this.addDelta(uniqueName, nodeKind, true);
                }
            }
            ++i;
        }
    }

    private void addDelta(UniqueName uniqueName, ModelDeltaNodeKind kind, boolean node) {
        if (this.myModelDeltaNode != null) {
            JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, uniqueName, kind, node);
            this.myModelDeltaNode.addDeltaNode((TreeModelDeltaNode)deltaNode);
        }
    }

    public static void putAdditionalModelElementDelta(Model model, UniqueName uniqueName, ModelDeltaNodeKind kind, boolean node) {
        JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(model, uniqueName, kind, node);
        ArrayList<JdtModelDeltaNode> list = (ArrayList<JdtModelDeltaNode>)myModelAdditionalDeltas.get(model);
        if (list == null) {
            list = new ArrayList<JdtModelDeltaNode>();
            myModelAdditionalDeltas.put(model, list);
        }
        list.add(deltaNode);
    }

    public static void putAdditionalMovedDelta(Model model, UniqueName oldUniqueName, UniqueName newUniqueName) {
        JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(model, oldUniqueName, ModelDeltaNodeKind.DELETED, true);
        deltaNode.setOriginalUniqueName(newUniqueName);
        ArrayList<JdtModelDeltaNode> list = (ArrayList<JdtModelDeltaNode>)myModelAdditionalDeltas.get(model);
        if (list == null) {
            list = new ArrayList<JdtModelDeltaNode>();
            myModelAdditionalDeltas.put(model, list);
        }
        list.add(deltaNode);
    }

    static TreeModelDeltaNode[] getAdditionalModelElementDelta(Model model) {
        ArrayList list = (ArrayList)myModelAdditionalDeltas.remove(model);
        if (list != null) {
            return list.toArray(new TreeModelDeltaNode[list.size()]);
        }
        return new TreeModelDeltaNode[0];
    }

    public static void putAdditionalJavaElementDelta(IJavaProject javaProject, IJavaElement javaElement, int kind) {
        HashMap<IJavaElement, Integer> map = (HashMap<IJavaElement, Integer>)myJDTAdditionalDeltas.get(javaElement.getJavaProject());
        if (map == null) {
            map = new HashMap<IJavaElement, Integer>();
            myJDTAdditionalDeltas.put(javaProject, map);
        }
        if (EditorUtil.isChangedFromEditor(javaElement)) {
            Integer intg = (Integer)map.get(javaElement);
            if (intg == null) {
                map.put(javaElement, new Integer(kind));
            } else {
                int oldKind = intg;
                if (oldKind > kind) {
                    map.put(javaElement, new Integer(kind));
                }
            }
        }
    }

    static IJavaElementDelta[] getAdditionalJavaElementDelta(IJavaProject javaProject) {
        HashMap map = (HashMap)myJDTAdditionalDeltas.remove(javaProject);
        if (map != null) {
            ArrayList<MyJavaElementDelta> list = new ArrayList<MyJavaElementDelta>();
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                IJavaElement javaElement = (IJavaElement)iterator.next();
                Integer integer = (Integer)map.get(javaElement);
                int kind = integer;
                list.add(new MyJavaElementDelta(javaElement, kind));
                ++i;
            }
            return list.toArray(new IJavaElementDelta[list.size()]);
        }
        return new IJavaElementDelta[0];
    }

    private static class MyJavaElementDelta
    implements IJavaElementDelta {
        private IJavaElement myJavaElement;
        private int myKind;

        public MyJavaElementDelta(IJavaElement javaElement, int kind) {
            this.myJavaElement = javaElement;
            this.myKind = kind;
        }

        public IJavaElementDelta[] getAddedChildren() {
            return new IJavaElementDelta[0];
        }

        public IJavaElementDelta[] getAffectedChildren() {
            return new IJavaElementDelta[0];
        }

        public IJavaElementDelta[] getChangedChildren() {
            return new IJavaElementDelta[0];
        }

        public IJavaElement getElement() {
            return this.myJavaElement;
        }

        public int getFlags() {
            return 0;
        }

        public int getKind() {
            return this.myKind;
        }

        public IJavaElement getMovedFromElement() {
            return null;
        }

        public IJavaElement getMovedToElement() {
            return null;
        }

        public IJavaElementDelta[] getRemovedChildren() {
            return new IJavaElementDelta[0];
        }

        public IResourceDelta[] getResourceDeltas() {
            return new IResourceDelta[0];
        }
    }
}

