/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public class DeletedClassesDeltaPatch {
    public static void deletedClassesDeltaPatch(IJavaProject javaProject, IJavaElementDelta delta, boolean allProjects, boolean markAsChanged) {
        int kind = delta.getKind();
        IJavaElement javaElement = delta.getElement();
        IJavaElement movedToElement = delta.getMovedToElement();
        IJavaProject[] javaProjects = new IJavaProject[]{javaProject};
        if (allProjects) {
            javaProjects = ProjectUtil.getReferencingProjects(javaProject);
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject curJavaProject = javaProjects[i];
            Model model = ElementUtil.getModel(curJavaProject);
            if (kind == 2 && javaElement instanceof IPackageFragment && movedToElement instanceof IPackageFragment && !javaElement.getElementName().equals(movedToElement.getElementName())) {
                IPackageFragment movedToPackageFragment = (IPackageFragment)movedToElement;
                String packageQualifiedName = NameUtil.getPackageQualifiedName((IPackageFragment)javaElement);
                IType[] types = JDTUtil.getAllTypes(curJavaProject, movedToPackageFragment, false);
                String root = NameUtil.getRootLocation(curJavaProject, javaElement);
                int j = 0;
                while (j < types.length) {
                    IType type = types[j];
                    String typeName = type.getElementName();
                    String oldTypeQualifiedName = packageQualifiedName.length() > 0 ? packageQualifiedName + "." + typeName : typeName;
                    UniqueName newUniqueName = NameUtil.getTypeUniqueName(curJavaProject, type);
                    UniqueName oldUniqueName = NameUtil.getTypeUniqueName(root, oldTypeQualifiedName);
                    DeltaPatcherTreeProvider.putAdditionalMovedDelta(model, oldUniqueName, newUniqueName);
                    ++j;
                }
                if (markAsChanged) {
                    UniqueName packageUniqueName = javaProject.getElementName().equals(curJavaProject.getElementName()) ? NameUtil.getPackageUniqueName((IPackageFragment)javaElement) : NameUtil.getRefPackageUniqueName((IPackageFragment)javaElement);
                    DeltaPatcherTreeProvider.putAdditionalModelElementDelta(model, packageUniqueName, ModelDeltaNodeKind.CHANGED, false);
                }
                DeltaPatcherTreeProvider.modelChanged(model);
            }
            ++i;
        }
    }
}

