/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.SRTOptionListener;
import com.tssap.selena.internal.core.providers.java.editor.IJavaEditorListener;
import com.tssap.selena.internal.core.providers.java.editor.JavaEditorPart;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;

public class CompilationUnitStates
implements SRTOptionListener {
    private static IJavaEditorListener myJavaEditorListener = null;
    private static HashMap mCompilationUnitContents = new HashMap();
    private static CompilationUnitStates myCompilationUnitStates;

    private CompilationUnitStates() {
    }

    public static void startup() {
        myCompilationUnitStates = new CompilationUnitStates();
        JavaProviderPlugin.addSRTOptionListener(myCompilationUnitStates);
    }

    public static void shutdown() {
        JavaProviderPlugin.removeSRTOptionListener(myCompilationUnitStates);
    }

    public synchronized void onSRT() {
        IJavaEditorListener javaEditorListener = CompilationUnitStates.getJavaEditorListener();
        JavaEditorPart.addJavaEditorListener(javaEditorListener);
    }

    public synchronized void offSRT() {
        mCompilationUnitContents.clear();
        JavaEditorPart.removeJavaEditorListener(myJavaEditorListener);
    }

    public static String getPreviousState(ICompilationUnit compilationUnit) {
        String contents = CompilationUnitStates.getEditorPreviousState(compilationUnit);
        if (contents == null) {
            contents = CompilationUnitStates.getResourcePreviousState(compilationUnit);
        }
        if (contents == null) {
            return CompilationUnitStates.getLastState(compilationUnit);
        }
        return contents;
    }

    public static String getLastState(ICompilationUnit compilationUnit) {
        try {
            return compilationUnit.getBuffer().getContents();
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    private static String getEditorPreviousState(ICompilationUnit compilationUnit) {
        return (String)mCompilationUnitContents.get(compilationUnit.getHandleIdentifier());
    }

    private static String getResourcePreviousState(ICompilationUnit compilationUnit) {
        try {
            String lastContents = compilationUnit.getBuffer().getContents();
            IFile resource = (IFile)compilationUnit.getUnderlyingResource();
            ResourceNode base = new ResourceNode((IResource)resource);
            IFileState[] states = resource.getHistory(null);
            if (states != null && states.length > 0) {
                HistoryItem prev = new HistoryItem((ITypedElement)base, states[0]);
                String prevContents = CompilationUnitStates.getStreamContentAsString(prev.getContents());
                if (prevContents != null) {
                    return prevContents;
                }
                return lastContents;
            }
            return CompilationUnitStates.getLastState(compilationUnit);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        catch (CoreException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    private static IJavaEditorListener getJavaEditorListener() {
        if (myJavaEditorListener == null) {
            myJavaEditorListener = new MyJavaEditorListener();
        }
        return myJavaEditorListener;
    }

    private static String getStreamContentAsString(InputStream in) {
        return Utilities.readString((InputStream)in);
    }

    private static class MyJavaEditorListener
    implements IJavaEditorListener {
        private MyJavaEditorListener() {
        }

        public void compilationUnitOpened(ICompilationUnit compilationUnit) {
        }

        public void compilationUnitChanged(ICompilationUnit compilationUnit) {
            try {
                HashMap hashMap = mCompilationUnitContents;
                synchronized (hashMap) {
                    String contents = compilationUnit.getBuffer().getContents();
                    mCompilationUnitContents.put(compilationUnit.getHandleIdentifier(), contents);
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }

        public void compilationUnitSaved(ICompilationUnit compilationUnit) {
            HashMap hashMap = mCompilationUnitContents;
            synchronized (hashMap) {
                this.compilationUnitClosed(compilationUnit, false);
            }
        }

        public void compilationUnitClosed(ICompilationUnit compilationUnit, boolean isDirty) {
            mCompilationUnitContents.remove(compilationUnit.getHandleIdentifier());
        }
    }
}

