/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.internal.core.providers.java.delta.DropCacheListener;
import com.tssap.selena.internal.core.providers.java.delta.NonPublicTypesPatcher;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CompilationUnitPatcher
implements IElementChangedListener {
    private static HashMap ourProcessingCompilationUnits = new HashMap();
    private static ArrayList ourDropCacheListeners = new ArrayList();
    private static CompilationUnitPatcher ourCompilationUnitPatcher;

    private CompilationUnitPatcher() {
    }

    public static void startup() {
        ourCompilationUnitPatcher = new CompilationUnitPatcher();
        JavaCore.addElementChangedListener((IElementChangedListener)ourCompilationUnitPatcher);
    }

    public static void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)ourCompilationUnitPatcher);
    }

    public static synchronized void addWorkingCopyDropCacheListener(DropCacheListener dropCacheListener) {
        ourDropCacheListeners.add(dropCacheListener);
    }

    public static synchronized void removeWorkingCopyDropCacheListener(DropCacheListener dropCacheListener) {
        ((AbstractCollection)ourDropCacheListeners).remove(dropCacheListener);
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processElement(event.getDelta());
        CompilationUnitPatcher.asyncDropCompilationUnitCache();
    }

    private void processElement(IJavaElementDelta delta) {
        IJavaElementDelta[] childrenDeltas;
        IJavaElement javaElement = delta.getElement();
        int elementType = javaElement.getElementType();
        if (elementType > 2) {
            if (elementType > 5) {
                return;
            }
            IJavaProject javaProject = javaElement.getJavaProject();
            switch (delta.getKind()) {
                case 4: {
                    if (!(javaElement instanceof ICompilationUnit)) break;
                    IJavaProject[] javaProjects = ProjectUtil.getReferencingProjects(javaProject);
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                    CompilationUnitPatcher.addDropingCompilationUnit(compilationUnit, javaProjects);
                    ICompilationUnit originalCompilationUnit = (ICompilationUnit)compilationUnit.getOriginalElement();
                    if (originalCompilationUnit != null) break;
                    NonPublicTypesPatcher.cacheNonPublicTypes(compilationUnit);
                    break;
                }
                case 2: {
                    if (!(javaElement instanceof ICompilationUnit)) break;
                    IJavaProject[] javaProjects = ProjectUtil.getReferencingProjects(javaProject);
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                    CompilationUnitPatcher.addDropingCompilationUnit(compilationUnit, javaProjects);
                    ICompilationUnit originalCompilationUnit = (ICompilationUnit)compilationUnit.getOriginalElement();
                    if (originalCompilationUnit != null) break;
                    EditorUtil.closeEditor(javaElement, true);
                }
            }
        }
        if ((childrenDeltas = delta.getAffectedChildren()) != null) {
            int i = 0;
            while (i < childrenDeltas.length) {
                this.processElement(childrenDeltas[i]);
                ++i;
            }
        }
    }

    public static void addDropingCompilationUnit(ICompilationUnit compilationUnit, IJavaProject[] javaProjects) {
        ourProcessingCompilationUnits.put(compilationUnit, javaProjects);
    }

    public static void asyncDropCompilationUnitCache() {
        if (!ourProcessingCompilationUnits.isEmpty()) {
            Set keys = ourProcessingCompilationUnits.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                ICompilationUnit compilationUnit = (ICompilationUnit)iter.next();
                IJavaProject[] javaProjects = (IJavaProject[])ourProcessingCompilationUnits.get(compilationUnit);
                int i = 0;
                while (i < javaProjects.length) {
                    try {
                        CompilationUnitPatcher.dropCompilationUnitCache(compilationUnit, javaProjects[i]);
                    }
                    catch (JavaModelException e) {
                        JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                    }
                    ++i;
                }
            }
            ourProcessingCompilationUnits.clear();
        }
    }

    private static void dropCompilationUnitCache(ICompilationUnit compilationUnit, IJavaProject javaProject) throws JavaModelException {
        if (compilationUnit != null && compilationUnit.exists()) {
            IJavaElement[] javaElements = compilationUnit.getChildren();
            int i = 0;
            while (i < javaElements.length) {
                CompilationUnitPatcher.dropMemberCache(javaProject, javaElements[i]);
                ++i;
            }
        }
    }

    private static void dropMemberCache(IJavaProject javaProject, IJavaElement javaElement) throws JavaModelException {
        UniqueName uniqueName = NameUtil.getJavaElementUniqueName(javaProject, javaElement);
        if (uniqueName != null) {
            UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
            Model model = ModelAccess.getModel((UniqueName)modelUniqueName);
            CompilationUnitPatcher.notifyListeners(model, uniqueName);
            if (javaElement instanceof IParent) {
                IJavaElement[] javaElements = ((IParent)javaElement).getChildren();
                int i = 0;
                while (i < javaElements.length) {
                    CompilationUnitPatcher.dropMemberCache(javaProject, javaElements[i]);
                    ++i;
                }
            }
        }
    }

    private static void notifyListeners(Model model, UniqueName uniqueName) {
        ArrayList arrayList = ourDropCacheListeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < ourDropCacheListeners.size()) {
                DropCacheListener ourDropCacheListener = (DropCacheListener)ourDropCacheListeners.get(i);
                ourDropCacheListener.dropCache(model, uniqueName);
                ++i;
            }
        }
    }
}

