/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

class CompareDeclarationUtil {
    CompareDeclarationUtil() {
    }

    static void compareCompilationUnit(ICompilationUnit newCompilationUnit, ICompilationUnit oldCompilationUnit, IResultOperation resultOperation) {
        String handleIdentifier;
        Iterator iter;
        if (resultOperation == null || newCompilationUnit == null || !newCompilationUnit.exists() || oldCompilationUnit == null || !oldCompilationUnit.exists()) {
            return;
        }
        HashMap newMembers = CompareDeclarationUtil.getMembers(newCompilationUnit);
        HashMap oldMembers = CompareDeclarationUtil.getMembers(oldCompilationUnit);
        Set newSet = newMembers.keySet();
        Set oldSet = oldMembers.keySet();
        ArrayList<String> addedMembers = new ArrayList<String>();
        ArrayList<String> changedMembers = new ArrayList<String>();
        ArrayList<String> removedMembers = new ArrayList<String>();
        Iterator iter2 = newSet.iterator();
        while (iter2.hasNext()) {
            String handleIdentifier2 = (String)iter2.next();
            if (oldSet.contains(handleIdentifier2)) {
                changedMembers.add(handleIdentifier2);
                continue;
            }
            addedMembers.add(handleIdentifier2);
        }
        Iterator iter3 = oldSet.iterator();
        while (iter3.hasNext()) {
            String handleIdentifier3 = (String)iter3.next();
            if (newSet.contains(handleIdentifier3)) continue;
            removedMembers.add(handleIdentifier3);
        }
        ArrayList tempChangedMembers = (ArrayList)changedMembers.clone();
        changedMembers.clear();
        if (!tempChangedMembers.isEmpty()) {
            iter = ((AbstractList)tempChangedMembers).iterator();
            while (iter.hasNext()) {
                IJavaElement oldJavaElement;
                handleIdentifier = (String)iter.next();
                IJavaElement newJavaElement = (IJavaElement)newMembers.get(handleIdentifier);
                if (CompareDeclarationUtil.compareJavaElement(newJavaElement, oldJavaElement = (IJavaElement)oldMembers.get(handleIdentifier))) continue;
                changedMembers.add(handleIdentifier);
            }
        }
        iter = ((AbstractList)addedMembers).iterator();
        while (iter.hasNext()) {
            handleIdentifier = (String)iter.next();
            IJavaElement javaElement = (IJavaElement)newMembers.get(handleIdentifier);
            resultOperation.resultOperation(javaElement, ModelDeltaNodeKind.NEW);
        }
        Iterator iter4 = ((AbstractList)changedMembers).iterator();
        while (iter4.hasNext()) {
            String handleIdentifier4 = (String)iter4.next();
            IJavaElement javaElement = (IJavaElement)newMembers.get(handleIdentifier4);
            resultOperation.resultOperation(javaElement, ModelDeltaNodeKind.CHANGED);
        }
        Iterator iter5 = ((AbstractList)removedMembers).iterator();
        while (iter5.hasNext()) {
            String handleIdentifier5 = (String)iter5.next();
            IJavaElement javaElement = (IJavaElement)oldMembers.get(handleIdentifier5);
            resultOperation.resultOperation(javaElement, ModelDeltaNodeKind.DELETED);
        }
    }

    private static HashMap getMembers(ICompilationUnit compilationUnit) {
        HashMap map = new HashMap();
        try {
            CompareDeclarationUtil.getMembers(map, (IJavaElement)compilationUnit);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return map;
    }

    private static void getMembers(HashMap map, IJavaElement javaElement) throws JavaModelException {
        if (javaElement instanceof IMember) {
            map.put(javaElement.getHandleIdentifier(), javaElement);
        }
        if (javaElement instanceof IParent) {
            IJavaElement[] javaElements = ((IParent)javaElement).getChildren();
            int i = 0;
            while (i < javaElements.length) {
                CompareDeclarationUtil.getMembers(map, javaElements[i]);
                ++i;
            }
        }
    }

    private static boolean compareJavaElement(IJavaElement newJavaElement, IJavaElement oldJavaElement) {
        if (newJavaElement instanceof IMember && oldJavaElement instanceof IMember && newJavaElement.getElementType() == oldJavaElement.getElementType()) {
            try {
                if (newJavaElement instanceof IType) {
                    Object[] oldSuperInterfaceNames;
                    IType newType = (IType)newJavaElement;
                    IType oldType = (IType)oldJavaElement;
                    if (newType.getFlags() != oldType.getFlags()) {
                        return false;
                    }
                    String newSuperclassName = oldType.getSuperclassName();
                    String oldSuperclassName = oldType.getSuperclassName();
                    if (newSuperclassName == null && oldSuperclassName != null || newSuperclassName != null && !newSuperclassName.equals(oldSuperclassName)) {
                        return false;
                    }
                    Object[] newSuperInterfaceNames = oldType.getSuperInterfaceNames();
                    if (!Arrays.equals(newSuperInterfaceNames, oldSuperInterfaceNames = oldType.getSuperInterfaceNames())) {
                        return false;
                    }
                    if (!CompareDeclarationUtil.compareComments((IMember)newType, (IMember)oldType)) {
                        return false;
                    }
                } else if (newJavaElement instanceof IMethod) {
                    Object[] oldExceptions;
                    IMethod newMethod = (IMethod)newJavaElement;
                    IMethod oldMethod = (IMethod)oldJavaElement;
                    if (newMethod.getFlags() != oldMethod.getFlags()) {
                        return false;
                    }
                    if (!newMethod.getSignature().equals(oldMethod.getSignature())) {
                        return false;
                    }
                    Object[] newExceptions = newMethod.getExceptionTypes();
                    if (!Arrays.equals(newExceptions, oldExceptions = oldMethod.getExceptionTypes())) {
                        return false;
                    }
                    if (CompareDeclarationUtil.compareComments((IMember)newMethod, (IMember)newMethod)) {
                        return false;
                    }
                } else if (newJavaElement instanceof IField) {
                    IField newField = (IField)newJavaElement;
                    IField oldField = (IField)oldJavaElement;
                    String newSource = newField.getSource();
                    String oldSource = oldField.getSource();
                    return newSource.equals(oldSource);
                }
                return true;
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return false;
    }

    private static boolean compareComments(IMember newMember, IMember oldMember) throws JavaModelException {
        String newSource = newMember.getSource();
        String oldSource = oldMember.getSource();
        ISourceRange newSourceRange = newMember.getSourceRange();
        ISourceRange oldSourceRange = oldMember.getSourceRange();
        int newSourceOffset = newSourceRange.getOffset();
        int oldSourceOffset = oldSourceRange.getOffset();
        ISourceRange newNameRange = newMember.getNameRange();
        ISourceRange oldNameRange = oldMember.getNameRange();
        int newNameOffset = newNameRange.getOffset();
        int oldNameOffset = oldNameRange.getOffset();
        int newOffset = newNameOffset - newSourceOffset;
        int oldOffset = oldNameOffset - oldSourceOffset;
        String newCommentSource = newSource.substring(0, newOffset);
        String oldCommentSource = oldSource.substring(0, oldOffset);
        return newCommentSource.equals(oldCommentSource);
    }

    static interface IResultOperation {
        public void resultOperation(IJavaElement var1, ModelDeltaNodeKind var2);
    }
}

