/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.internal.core.providers.java.SRTOptionListener;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.editor.IJavaEditorListener;
import com.tssap.selena.internal.core.providers.java.editor.JavaEditorPart;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jdt.core.BufferChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class CommentDeltaPatcher
implements SRTOptionListener {
    private IBufferChangedListener ourBufferChangedListener = new IBufferChangedListener(){

        public void bufferChanged(BufferChangedEvent event) {
            IOpenable openable = event.getBuffer().getOwner();
            try {
                ICompilationUnit compilationUnit;
                String projectName;
                UniqueName modelUniqueName;
                Model model;
                if (!event.getBuffer().isClosed() && openable instanceof ICompilationUnit && openable.isOpen() && (model = ModelAccess.getModel((UniqueName)(modelUniqueName = ModelUinSupport.createModelUin((String)(projectName = (compilationUnit = (ICompilationUnit)openable).getJavaProject().getElementName()))))) != null) {
                    int startOffset = event.getOffset();
                    int endOffset = startOffset + event.getLength();
                    IType[] types = compilationUnit.getTypes();
                    IType lastFoundMember = null;
                    int i = 0;
                    while (i < types.length) {
                        IType type = types[i];
                        if (this.isChangesInMember((IJavaElement)type, startOffset, endOffset)) {
                            lastFoundMember = type;
                        }
                        IJavaElement[] javaElements = type.getChildren();
                        int j = 0;
                        while (j < javaElements.length) {
                            IJavaElement javaElement = javaElements[j];
                            if (this.isChangesInMember(javaElement, startOffset, endOffset)) {
                                lastFoundMember = (IMember)javaElement;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (lastFoundMember != null) {
                        CommentDeltaPatcher.this.addDelta(lastFoundMember);
                    } else {
                        int j = 0;
                        while (j < types.length) {
                            IType type = types[j];
                            CommentDeltaPatcher.this.addDelta((IMember)type);
                            ++j;
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }

        private boolean isChangesInMember(IJavaElement javaElement, int startOffset, int endOffset) throws JavaModelException {
            if (javaElement instanceof IMember) {
                int nameStartOffset;
                ISourceRange nameRange;
                IMember member = (IMember)javaElement;
                ISourceRange sourceRange = member.getSourceRange();
                int memberStartOffset = sourceRange.getOffset();
                int memberEndOffset = memberStartOffset + sourceRange.getLength();
                if (memberStartOffset <= startOffset && endOffset <= memberEndOffset && (nameRange = member.getNameRange()) != null && endOffset < (nameStartOffset = nameRange.getOffset())) {
                    return true;
                }
            }
            return false;
        }
    };
    private HashMap myCompilationUnit2Member = new HashMap();
    private IJavaEditorListener myJavaEditorListener = null;
    private static CommentDeltaPatcher ourCommentDeltaPatcher;

    private CommentDeltaPatcher() {
    }

    public static void startup() {
        ourCommentDeltaPatcher = new CommentDeltaPatcher();
        JavaProviderPlugin.addSRTOptionListener(ourCommentDeltaPatcher);
    }

    public static void shutdown() {
        JavaProviderPlugin.removeSRTOptionListener(ourCommentDeltaPatcher);
    }

    public void onSRT() {
        IJavaEditorListener javaEditorListener = this.getJavaEditorListener();
        JavaEditorPart.addJavaEditorListener(javaEditorListener);
    }

    public void offSRT() {
        JavaEditorPart.removeJavaEditorListener(this.myJavaEditorListener);
    }

    private IJavaEditorListener getJavaEditorListener() {
        this.myJavaEditorListener = new MyJavaEditorListener();
        return this.myJavaEditorListener;
    }

    private void addDelta(IMember member) {
        ICompilationUnit compilationUnit = member.getCompilationUnit();
        ArrayList<IMember> list = (ArrayList<IMember>)this.myCompilationUnit2Member.get(compilationUnit.getHandleIdentifier());
        if (list == null) {
            list = new ArrayList<IMember>();
            this.myCompilationUnit2Member.put(compilationUnit.getHandleIdentifier(), list);
        }
        list.add(member);
    }

    private ArrayList getDeltas(ICompilationUnit compilationUnit) {
        ArrayList list = (ArrayList)this.myCompilationUnit2Member.remove(compilationUnit.getHandleIdentifier());
        if (list != null) {
            return list;
        }
        return new ArrayList();
    }

    private class MyJavaEditorListener
    implements IJavaEditorListener {
        private ArrayList myProcessedCompilationUnit = new ArrayList();

        private MyJavaEditorListener() {
        }

        public void compilationUnitOpened(ICompilationUnit compilationUnit) {
            try {
                IBuffer buffer = compilationUnit.getBuffer();
                buffer.addBufferChangedListener(CommentDeltaPatcher.this.ourBufferChangedListener);
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }

        public void compilationUnitChanged(ICompilationUnit compilationUnit) {
        }

        public void compilationUnitSaved(ICompilationUnit compilationUnit) {
            this.addDelta(compilationUnit);
        }

        public void compilationUnitClosed(ICompilationUnit compilationUnit, boolean isDirty) {
            try {
                IBuffer buffer = compilationUnit.getBuffer();
                buffer.removeBufferChangedListener(CommentDeltaPatcher.this.ourBufferChangedListener);
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
            this.addDelta(compilationUnit);
        }

        private void addDelta(ICompilationUnit compilationUnit) {
            IJavaProject javaProject = compilationUnit.getJavaProject();
            IJavaProject[] javaProjects = ProjectUtil.getReferencingProjects(javaProject);
            int i = 0;
            while (i < javaProjects.length) {
                javaProject = javaProjects[i];
                ArrayList list = CommentDeltaPatcher.this.getDeltas(compilationUnit);
                Iterator iter = ((AbstractList)list).iterator();
                while (iter.hasNext()) {
                    IMember member = (IMember)iter.next();
                    DeltaPatcherTreeProvider.putAdditionalJavaElementDelta(javaProject, (IJavaElement)member, 4);
                    DeltaPatcherTreeProvider.modelChanged(javaProject);
                }
                ++i;
            }
        }
    }
}

