/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.internal.core.providers.java.SRTOptionListener;
import com.tssap.selena.internal.core.providers.java.delta.CompareDeclarationUtil;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.editor.IJavaEditorListener;
import com.tssap.selena.internal.core.providers.java.editor.JavaEditorPart;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class CloseEditorPatcher
implements SRTOptionListener {
    private IJavaEditorListener myJavaEditorListener;
    private static CloseEditorPatcher ourCloseEditorPatcher;

    private CloseEditorPatcher() {
    }

    public static void startup() {
        ourCloseEditorPatcher = new CloseEditorPatcher();
        JavaProviderPlugin.addSRTOptionListener(ourCloseEditorPatcher);
    }

    public static void shutdown() {
        JavaProviderPlugin.removeSRTOptionListener(ourCloseEditorPatcher);
    }

    public void onSRT() {
        IJavaEditorListener javaEditorListener = this.getJavaEditorListener();
        JavaEditorPart.addJavaEditorListener(javaEditorListener);
    }

    public void offSRT() {
        JavaEditorPart.removeJavaEditorListener(this.myJavaEditorListener);
    }

    private IJavaEditorListener getJavaEditorListener() {
        if (this.myJavaEditorListener == null) {
            this.myJavaEditorListener = new MyCloseEditorListener();
        }
        return this.myJavaEditorListener;
    }

    private void buildDifferencialDelta(IJavaProject javaProject, ICompilationUnit compilationUnit) {
        MyResultOperation resultOperation = new MyResultOperation(javaProject);
        ICompilationUnit oldCompilationUnit = compilationUnit;
        ICompilationUnit newCompilationUnit = (ICompilationUnit)compilationUnit.getOriginalElement();
        CompareDeclarationUtil.compareCompilationUnit(newCompilationUnit, oldCompilationUnit, resultOperation);
    }

    private class MyResultOperation
    implements CompareDeclarationUtil.IResultOperation {
        private IJavaProject myJavaProject;
        private Model myModel;

        MyResultOperation(IJavaProject javaProject) {
            this.myJavaProject = javaProject;
            UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
            this.myModel = ModelAccess.createModel((UniqueName)modelUniqueName);
        }

        public void resultOperation(IJavaElement javaElement, ModelDeltaNodeKind kind) {
            UniqueName uniqueName = NameUtil.getJavaElementUniqueName(this.myJavaProject, javaElement);
            if (uniqueName != null) {
                DeltaPatcherTreeProvider.putAdditionalModelElementDelta(this.myModel, uniqueName, kind, true);
            }
        }
    }

    private class MyCloseEditorListener
    implements IJavaEditorListener {
        private MyCloseEditorListener() {
        }

        public void compilationUnitOpened(ICompilationUnit compilationUnit) {
        }

        public void compilationUnitChanged(ICompilationUnit compilationUnit) {
        }

        public void compilationUnitSaved(ICompilationUnit compilationUnit) {
        }

        public void compilationUnitClosed(ICompilationUnit compilationUnit, boolean isDirty) {
            IJavaProject javaProject = compilationUnit.getJavaProject();
            if (isDirty) {
                IJavaProject[] javaProjects = ProjectUtil.getReferencingProjects(javaProject);
                int i = 0;
                while (i < javaProjects.length) {
                    IJavaProject jProject = javaProjects[i];
                    CloseEditorPatcher.this.buildDifferencialDelta(jProject, compilationUnit);
                    DeltaPatcherTreeProvider.modelChanged(jProject);
                    ++i;
                }
            }
        }
    }
}

