/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.delta.JdtModelDeltaNode;
import com.tssap.selena.internal.core.providers.java.delta.TotalyChangedTypeInspector;
import com.tssap.selena.internal.java.diff.JavaDiffElement;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.util.Arrays;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMType;

class ChangedTypeInspector
extends TotalyChangedTypeInspector {
    ChangedTypeInspector(Model model, IJavaProject javaProject, ICompilationUnit compilationUnit, String root) {
        super(model, javaProject, compilationUnit, root);
    }

    public void inspectField(JavaDiffElement field) {
        try {
            String content = field.getSource();
            String originalSource = field.getOriginalSource();
            if (content != null && originalSource != null) {
                IJavaElement javaElement;
                IDOMField newDomField = new DOMFactory().createField(content);
                IDOMField oldDomField = new DOMFactory().createField(originalSource);
                if (newDomField != null && oldDomField != null && this.myType != null && (javaElement = newDomField.getJavaElement((IJavaElement)this.myType)) instanceof IField) {
                    String oldName;
                    UniqueName uniqueName = NameUtil.getFieldUniqueName(this.myJavaProject, (IField)javaElement);
                    String newName = newDomField.getName();
                    if (newName.equals(oldName = oldDomField.getName())) {
                        this.addChangeDeltaNode(uniqueName);
                    } else {
                        UniqueName addedUniqueName = uniqueName;
                        String st = uniqueName.toString();
                        int index = st.lastIndexOf(newName);
                        st = st.substring(0, index) + oldName;
                        UniqueName removedUniqueName = ModelAccess.createUniqueName((String)st);
                        JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, addedUniqueName, removedUniqueName, ModelDeltaNodeKind.NEW, true);
                        this.myDeltaNodes.add(deltaNode);
                        deltaNode = new JdtModelDeltaNode(this.myModel, removedUniqueName, addedUniqueName, ModelDeltaNodeKind.DELETED, true);
                        this.myDeltaNodes.add(deltaNode);
                    }
                }
            }
        }
        catch (Exception e) {
            this.myIsTotal = true;
        }
    }

    public void inspectMethod(JavaDiffElement method) {
        try {
            String content = method.getSource();
            String originalSource = method.getOriginalSource();
            if (content != null && originalSource != null) {
                IJavaElement javaElement;
                IDOMMethod newDomMethod = new DOMFactory().createMethod(content);
                IDOMMethod oldDomMethod = new DOMFactory().createMethod(originalSource);
                if (newDomMethod != null && oldDomMethod != null && this.myType != null && (javaElement = newDomMethod.getJavaElement((IJavaElement)this.myType)) instanceof IMethod) {
                    String oldName;
                    IMethod jMethod = (IMethod)javaElement;
                    String newName = newDomMethod.getName();
                    if (newName == null) {
                        newName = this.myType.getElementName();
                    }
                    if ((oldName = oldDomMethod.getName()) == null) {
                        oldName = this.myType.getElementName();
                    }
                    UniqueName newUniqueName = NameUtil.getMethodUniqueName(this.myJavaProject, jMethod);
                    Object[] parameterTypes = newDomMethod.getParameterTypes();
                    Object[] oldParameterTypes = oldDomMethod.getParameterTypes();
                    if (!newName.equals(oldName) || !Arrays.equals(parameterTypes, oldParameterTypes)) {
                        String newHandleIdentifier = jMethod.getHandleIdentifier();
                        String newHandleIdentifierPart = NameUtil.getHandleIdentifierPart(newHandleIdentifier);
                        String oldHandleIdentifier = this.getHandleIdentifier(this.myType, oldName, (String[])oldParameterTypes);
                        String oldHandleIdentifierPart = NameUtil.getHandleIdentifierPart(oldHandleIdentifier);
                        String st = newUniqueName.toString();
                        int index = st.indexOf(newName + ":" + newName);
                        st = st.substring(0, index) + oldName + ":" + oldHandleIdentifierPart;
                        UniqueName oldUniqueName = ModelAccess.createUniqueName((String)st);
                        JdtModelDeltaNode addedDeltaNode = new JdtModelDeltaNode(this.myModel, newUniqueName, oldUniqueName, ModelDeltaNodeKind.NEW, true);
                        this.myDeltaNodes.add(addedDeltaNode);
                        JdtModelDeltaNode removedDeltaNode = new JdtModelDeltaNode(this.myModel, oldUniqueName, newUniqueName, ModelDeltaNodeKind.DELETED, true);
                        this.myDeltaNodes.add(removedDeltaNode);
                        return;
                    }
                    this.addChangeDeltaNode(newUniqueName);
                }
            }
        }
        catch (Exception e) {
            this.myIsTotal = true;
        }
    }

    public void inspectType(JavaDiffElement type) {
        UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myRoot, this.myTypeFullName);
        this.addChangeDeltaNode(uniqueName);
    }

    public void inspectInnerType(JavaDiffElement innerType) {
        try {
            String content = innerType.getSource();
            String originalSource = innerType.getOriginalSource();
            if (content != null && originalSource != null) {
                IJavaElement javaElement;
                IDOMType newDomType = new DOMFactory().createType(content);
                IDOMType oldDomType = new DOMFactory().createType(originalSource);
                if (newDomType != null && oldDomType != null && this.myType != null && (javaElement = newDomType.getJavaElement((IJavaElement)this.myType)) instanceof IType) {
                    String oldName;
                    UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, (IType)javaElement);
                    String newName = newDomType.getName();
                    if (newName.equals(oldName = oldDomType.getName())) {
                        this.addChangeDeltaNode(uniqueName);
                    } else {
                        UniqueName addedUniqueName = uniqueName;
                        String st = uniqueName.toString();
                        int index = st.lastIndexOf(newName);
                        st = st.substring(0, index) + oldName;
                        UniqueName removedUniqueName = ModelAccess.createUniqueName((String)st);
                        JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, addedUniqueName, removedUniqueName, ModelDeltaNodeKind.NEW, true);
                        this.myDeltaNodes.add(deltaNode);
                        deltaNode = new JdtModelDeltaNode(this.myModel, removedUniqueName, addedUniqueName, ModelDeltaNodeKind.DELETED, true);
                        this.myDeltaNodes.add(deltaNode);
                    }
                }
            }
        }
        catch (Exception e) {
            this.myIsTotal = true;
        }
    }

    public void inspectSupplementaryType(JavaDiffElement supplementaryType) {
        try {
            IJavaElement javaElement;
            IDOMType domType;
            String content = supplementaryType.getSource();
            if (content != null && (domType = new DOMFactory().createType(content)) != null && this.myCompilationUnit != null && (javaElement = domType.getJavaElement((IJavaElement)this.myCompilationUnit)) instanceof IType) {
                UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, (IType)javaElement);
                this.addChangeDeltaNode(uniqueName);
            }
        }
        catch (Exception e) {
            this.myIsTotal = true;
        }
    }

    private String getHandleIdentifier(IType type, String name, String[] parameterTypes) {
        StringBuffer buff = new StringBuffer();
        buff.append(type.getHandleIdentifier());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(name);
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                buff.append(this.getHandleMementoDelimiter());
                buff.append(Signature.createTypeSignature((String)parameterTypes[i], (boolean)false));
                ++i;
            }
        }
        return buff.toString();
    }

    private char getHandleMementoDelimiter() {
        return '~';
    }

    private void addChangeDeltaNode(UniqueName uniqueName) {
        JdtModelDeltaNode deltaNode = new JdtModelDeltaNode(this.myModel, uniqueName, uniqueName, ModelDeltaNodeKind.CHANGED, true);
        this.myDeltaNodes.add(deltaNode);
    }

    public ModelDeltaNodeKind getNodeKind() {
        return ModelDeltaNodeKind.DELETED;
    }
}

