/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.delta;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.ElementsCache;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.internal.core.providers.java.SRTOptionListener;
import com.tssap.selena.internal.core.providers.java.delta.NonPublicTypesPatcher;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CacheUpdater
implements SRTOptionListener,
IElementChangedListener {
    private static CacheUpdater ourCacheUpdater;

    private CacheUpdater() {
    }

    public static void startup() {
        ourCacheUpdater = new CacheUpdater();
        JavaProviderPlugin.addSRTOptionListener(ourCacheUpdater);
        JavaCore.addElementChangedListener((IElementChangedListener)ourCacheUpdater);
    }

    public static void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)ourCacheUpdater);
        JavaProviderPlugin.removeSRTOptionListener(ourCacheUpdater);
    }

    public synchronized void onSRT() {
    }

    public synchronized void offSRT() {
    }

    public void elementChanged(ElementChangedEvent event) {
        this.updateCache(event.getDelta());
    }

    private void updateCache(IJavaElementDelta delta) {
        IJavaElementDelta[] childrenDeltas;
        int i;
        IJavaElement javaElement = delta.getElement();
        if (javaElement.getElementType() > 3) {
            IJavaProject[] referencedJavaProjects = ProjectUtil.getReferencingProjects(javaElement.getJavaProject());
            i = 0;
            while (i < referencedJavaProjects.length) {
                IJavaProject javaProject = referencedJavaProjects[i];
                UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
                ElementsCache elementCache = ElementCacheAccess.getElementsCache(modelUniqueName);
                if (javaElement.getElementType() > 5) {
                    ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit(javaElement);
                    if (compilationUnit != null) {
                        boolean isChangesFromEditor = EditorUtil.isChangedFromEditor(javaElement);
                        if (JavaProviderPlugin.isSRTEnabled() ? isChangesFromEditor && !EditorUtil.isEditorDirty(javaElement) : isChangesFromEditor) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                try {
                    this.updateCacheElement(delta, javaProject, elementCache);
                }
                catch (JavaModelException e) {
                    JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                }
                ++i;
            }
        }
        if ((childrenDeltas = delta.getAffectedChildren()) != null) {
            i = 0;
            while (i < childrenDeltas.length) {
                this.updateCache(childrenDeltas[i]);
                ++i;
            }
        }
    }

    private void updateCacheElement(IJavaElementDelta delta, IJavaProject javaProject, ElementsCache elementsCache) throws JavaModelException {
        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
        IJavaElement javaElement = delta.getElement();
        boolean changesFromEditor = EditorUtil.isChangedFromEditor(javaElement);
        String rootLocation = this.getRootLocation(javaProject, javaElement);
        switch (delta.getKind()) {
            case 1: {
                if (this.isDuplicatedElement(javaElement, true)) {
                    return;
                }
                if (changesFromEditor) {
                    if (javaElement instanceof IType) {
                        IType type = (IType)javaElement;
                        UniqueName uniqueName = NameUtil.getTypeUniqueName(javaProject, type);
                        elementsCache.putTemporarilyElement(uniqueName, (IJavaElement)type);
                        elementsCache.addTemporarilyTopLevelChildren(type.getCompilationUnit(), type);
                        break;
                    }
                    if (javaElement instanceof IMethod) {
                        IMethod method = (IMethod)javaElement;
                        UniqueName uniqueName = NameUtil.getMethodUniqueName(javaProject, method);
                        elementsCache.putTemporarilyElement(uniqueName, (IJavaElement)method);
                        break;
                    }
                    if (!(javaElement instanceof IField)) break;
                    IField field = (IField)javaElement;
                    UniqueName uniqueName = NameUtil.getFieldUniqueName(javaProject, field);
                    elementsCache.putTemporarilyElement(uniqueName, (IJavaElement)field);
                    break;
                }
                if (javaElement instanceof IPackageFragment) {
                    IPackageFragment packageFragment = (IPackageFragment)javaElement;
                    UniqueName uniqueName = NameUtil.getJavaElementUniqueName(javaProject, (IJavaElement)packageFragment);
                    IPackageFragment[] packageFragments = rootLocation.equals("src") ? ElementUtil.getPackageFragmentsByUniqueName(javaProject, uniqueName, false) : ElementUtil.getRefPackageFragmentsByUniqueName(javaProject, uniqueName, false);
                    elementsCache.putPackages(uniqueName, packageFragments);
                    break;
                }
                Element newElement = ElementUtil.getModelElement(modelUniqueName, javaElement);
                if (newElement == null) break;
                UniqueName uniqueName = newElement.getUniqueName();
                elementsCache.putPermanentElement(uniqueName, javaElement);
                break;
            }
            case 2: {
                if (this.isDuplicatedElement(javaElement, false)) {
                    return;
                }
                if (javaElement instanceof IPackageFragment) {
                    IPackageFragment packageFragment = (IPackageFragment)javaElement;
                    UniqueName uniqueName = NameUtil.getJavaElementUniqueName(javaProject, (IJavaElement)packageFragment);
                    elementsCache.removePackage(uniqueName, packageFragment);
                    break;
                }
                if (javaElement instanceof ICompilationUnit) {
                    if (changesFromEditor) break;
                    IPackageFragment packageFragment = (IPackageFragment)javaElement.getParent();
                    String packageFullName = NameUtil.getPackageQualifiedName(packageFragment);
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                    String[] oldTypesNames = NonPublicTypesPatcher.getTypes(compilationUnit);
                    IType[] addedTypes = elementsCache.getAddedTemporarilyTopLevelChildren(compilationUnit);
                    IType[] removedTypes = elementsCache.getRemovedTemporarilyTopLevelChildren(compilationUnit);
                    String[] addedTypesNames = CacheUpdater.getNames(addedTypes);
                    String[] removedTypesNames = CacheUpdater.getNames(removedTypes);
                    ArrayList typesNames = CacheUpdater.buildsDifference(oldTypesNames, addedTypesNames, removedTypesNames);
                    int i = 0;
                    while (i < typesNames.size()) {
                        String oldTypeName = (String)typesNames.get(i);
                        String typeName = "".equals(packageFullName) ? oldTypeName : packageFullName + "." + oldTypeName;
                        UniqueName uniqueName = NameUtil.getTypeUniqueName(rootLocation, typeName);
                        elementsCache.removePermanentElement(uniqueName);
                        ++i;
                    }
                    elementsCache.dropTemporarilyTopLevelChildren(compilationUnit);
                    break;
                }
                if (javaElement instanceof IType) {
                    IType type = (IType)javaElement;
                    UniqueName uniqueName = NameUtil.getTypeUniqueName(javaProject, type);
                    if (changesFromEditor) {
                        elementsCache.removeTemporarilyElement(uniqueName);
                        elementsCache.removeTemporarilyTopLevelChildren(type.getCompilationUnit(), type);
                        break;
                    }
                    elementsCache.removePermanentElement(uniqueName);
                    break;
                }
                if (javaElement instanceof IMethod) {
                    IMethod method = (IMethod)javaElement;
                    UniqueName uniqueName = NameUtil.getMethodUniqueName(javaProject, method);
                    if (changesFromEditor) {
                        elementsCache.removeTemporarilyElement(uniqueName);
                        break;
                    }
                    elementsCache.removePermanentElement(uniqueName);
                    break;
                }
                if (!(javaElement instanceof IField)) break;
                IField field = (IField)javaElement;
                UniqueName uniqueName = NameUtil.getFieldUniqueName(javaProject, field);
                if (changesFromEditor) {
                    elementsCache.removeTemporarilyElement(uniqueName);
                    break;
                }
                elementsCache.removePermanentElement(uniqueName);
            }
        }
    }

    private static String[] getNames(IType[] types) {
        if (types != null) {
            String[] names = new String[types.length];
            int i = 0;
            while (i < types.length) {
                IType type = types[i];
                names[i] = type.getElementName();
                ++i;
            }
            return names;
        }
        return new String[0];
    }

    private static ArrayList buildsDifference(String[] typesNames, String[] addedTypesNames, String[] removedTypesNames) {
        ArrayList oldList = ArrayUtil.toList(typesNames);
        int i = 0;
        while (i < removedTypesNames.length) {
            ((AbstractCollection)oldList).remove(removedTypesNames[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < addedTypesNames.length) {
            oldList.add(addedTypesNames[i2]);
            ++i2;
        }
        return oldList;
    }

    private boolean isDuplicatedElement(IJavaElement javaElement, boolean whileAdding) throws JavaModelException {
        IJavaElement parentElement;
        String handleIdentifier = javaElement.getHandleIdentifier();
        if (javaElement instanceof IMember && (parentElement = javaElement.getParent()) instanceof IParent) {
            IJavaElement[] chidren = ((IParent)parentElement).getChildren();
            if (whileAdding) {
                int n = 0;
                int i = 0;
                while (i < chidren.length) {
                    if (chidren[i].getHandleIdentifier().equals(handleIdentifier)) {
                        ++n;
                    }
                    ++i;
                }
                return n > 1;
            }
            int i = 0;
            while (i < chidren.length) {
                if (chidren[i].getHandleIdentifier().equals(handleIdentifier)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    private String getRootLocation(IJavaProject javaProject, IJavaElement javaElement) {
        if (javaElement.getJavaProject().equals(javaProject)) {
            return "src";
        }
        return "ref";
    }
}

