/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.ElementsCache;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class WorkingCopyUtil {
    public static void initWorkingCopy(IJavaProject javaProject, IJavaElement javaElement) {
        if (!JavaProviderPlugin.isSaveResources()) {
            try {
                IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)javaElement);
                if (editorPart instanceof CompilationUnitEditor) {
                    CompilationUnitEditor compilationUnitEditor = (CompilationUnitEditor)editorPart;
                    IEditorInput editorInput = compilationUnitEditor.getEditorInput();
                    ICompilationUnit compilationUnit = JavaUI.getWorkingCopyManager().getWorkingCopy(editorInput);
                    if (compilationUnit != null) {
                        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
                        ElementsCache elementCache = ElementCacheAccess.getElementsCache(modelUniqueName);
                        UniqueName uniqueName = NameUtil.getJavaElementUniqueName(javaProject, javaElement);
                        WorkingCopyUtil.processWorkingCopy(elementCache, (IJavaElement)compilationUnit, true);
                    }
                }
            }
            catch (PartInitException e) {
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public static void dropWorkingCopies(IJavaElement javaElement) {
        ICompilationUnit compilationUnit;
        if (javaElement != null && (compilationUnit = JDTUtil.getCompilationUnit(javaElement)) != null && !EditorUtil.isChangedFromEditor(javaElement)) {
            IJavaProject javaProject = compilationUnit.getJavaProject();
            UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
            ElementsCache elementCache = ElementCacheAccess.getElementsCache(modelUniqueName);
            WorkingCopyUtil.processWorkingCopy(elementCache, (IJavaElement)compilationUnit, false);
            elementCache.dropTemporarilyTopLevelChildren(compilationUnit);
            String[] referencingProjectsNames = ProjectUtil.getReferencingProjectsNames(javaProject);
            int i = 0;
            while (i < referencingProjectsNames.length) {
                String projectsName = referencingProjectsNames[i];
                modelUniqueName = ModelUinSupport.createModelUin((String)projectsName);
                elementCache = ElementCacheAccess.getElementsCache(modelUniqueName);
                WorkingCopyUtil.processWorkingCopy(elementCache, (IJavaElement)compilationUnit, false);
                elementCache.dropTemporarilyTopLevelChildren(compilationUnit);
                ++i;
            }
        }
    }

    public static void dropWorkingCopy(IJavaProject javaProject, IJavaElement javaElement) {
        ICompilationUnit compilationUnit;
        if (javaElement != null && (compilationUnit = JDTUtil.getCompilationUnit(javaElement)) != null && !EditorUtil.isChangedFromEditor(javaElement)) {
            UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
            ElementsCache elementCache = ElementCacheAccess.getElementsCache(modelUniqueName);
            WorkingCopyUtil.processWorkingCopy(elementCache, (IJavaElement)compilationUnit, false);
            elementCache.dropTemporarilyTopLevelChildren(compilationUnit);
        }
    }

    public static IJavaElement getWorkingCopy(IJavaElement javaElement) {
        IJavaProject javaProject = javaElement.getJavaProject();
        UniqueName uniqueName = NameUtil.getJavaElementUniqueName(javaProject, javaElement);
        Model model = ElementUtil.getModel(javaProject);
        IJavaElement workingJavaElement = ElementUtil.getJavaElement(model.getUniqueName(), uniqueName);
        return workingJavaElement != null ? workingJavaElement : javaElement;
    }

    public static void processWorkingCopy(ElementsCache elementsCache, IJavaElement javaElement, boolean put) {
        if (javaElement != null) {
            UniqueName uniqueName = NameUtil.getJavaElementUniqueName(javaElement, "src");
            if (uniqueName != null) {
                if (put) {
                    elementsCache.putTemporarilyElement(uniqueName, javaElement);
                } else {
                    elementsCache.removeTemporarilyElement(uniqueName);
                }
            }
            if (javaElement instanceof IParent) {
                try {
                    IJavaElement[] javaElements = ((IParent)javaElement).getChildren();
                    int i = 0;
                    while (i < javaElements.length) {
                        WorkingCopyUtil.processWorkingCopy(elementsCache, javaElements[i], put);
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                }
            }
        }
    }
}

