/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.ElementsCache;
import com.tssap.selena.internal.core.providers.java.GenericParentProvider;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.LinksCache;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.delta.NonPublicTypesPatcher;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.HashSet;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeProvider
extends GenericParentProvider
implements ChildrenProvider {
    private LinksCache myLinksCache;

    public void registered(Model model) {
        super.registered(model);
        this.myLinksCache = ElementCacheAccess.getLinksCache(this.myModelUniqueName);
    }

    public void unregistered(Model model) {
        this.myLinksCache = null;
        super.unregistered(model);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        block19: {
            UniqueName parentUniqueName = parent.getUniqueName();
            try {
                if (NameUtil.isTypeUniqueName(parentUniqueName)) {
                    IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
                    if (!(javaElement instanceof IType)) break block19;
                    IType type = (IType)javaElement;
                    HashSet<UniqueName> classes = new HashSet<UniqueName>();
                    IJavaElement[] javaElements = this.myElementsCache.getTemporarilyChildren(parentUniqueName);
                    if (javaElements.length > 0) {
                        int i = 0;
                        while (i < javaElements.length) {
                            if (javaElements[i] instanceof IType) {
                                IType innerType = (IType)javaElements[i];
                                UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, innerType);
                                classes.add(uniqueName);
                                this.addTemporarilyGeneralizationLinks(innerType);
                            }
                            ++i;
                        }
                    } else {
                        IType[] types = type.getTypes();
                        int i = 0;
                        while (i < types.length) {
                            IType innerType = types[i];
                            UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, innerType);
                            this.myElementsCache.putPermanentElement(uniqueName, (IJavaElement)innerType);
                            classes.add(uniqueName);
                            this.addPermanentGeneralizationLinks(innerType);
                            ++i;
                        }
                    }
                    return EnumerationConverter.toUniqueNameEnumeration(classes.iterator());
                }
                if (NameUtil.isPackageUniqueName(parentUniqueName) || NameUtil.isRefPackageUniqueName(parentUniqueName) || NameUtil.isRefRootUniqueName(parentUniqueName) || this.myModelUniqueName.equals(parentUniqueName)) {
                    IPackageFragment[] packageFragments = NameUtil.isRefPackageUniqueName(parentUniqueName) || NameUtil.isRefRootUniqueName(parentUniqueName) ? ElementUtil.getRefPackageFragmentsByUniqueName(this.myJavaProject, parentUniqueName) : ElementUtil.getPackageFragmentsByUniqueName(this.myJavaProject, parentUniqueName);
                    HashSet<UniqueName> classes = new HashSet<UniqueName>();
                    int p = 0;
                    while (p < packageFragments.length) {
                        IPackageFragment packageFragment = packageFragments[p];
                        ICompilationUnit[] compilationUnits = packageFragment.getCompilationUnits();
                        int i = 0;
                        while (i < compilationUnits.length) {
                            ICompilationUnit compilationUnit = compilationUnits[i];
                            NonPublicTypesPatcher.cacheNonPublicTypes(compilationUnit);
                            IType[] types = compilationUnit.getTypes();
                            int j = 0;
                            while (j < types.length) {
                                IType type = types[j];
                                UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, type);
                                this.myElementsCache.putPermanentElement(uniqueName, (IJavaElement)type);
                                classes.add(uniqueName);
                                this.addPermanentGeneralizationLinks(type);
                                ++j;
                            }
                            ++i;
                        }
                        int i2 = 0;
                        while (i2 < compilationUnits.length) {
                            ElementsCache elementsCache = ElementCacheAccess.getElementsCache(this.myModelUniqueName);
                            IType[] types = elementsCache.getAddedTemporarilyTopLevelChildren(compilationUnits[i2]);
                            int j = 0;
                            while (j < types.length) {
                                IType type = types[j];
                                UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, type);
                                classes.add(uniqueName);
                                this.addTemporarilyGeneralizationLinks(type);
                                ++j;
                            }
                            types = elementsCache.getRemovedTemporarilyTopLevelChildren(compilationUnits[i2]);
                            int j2 = 0;
                            while (j2 < types.length) {
                                IType type = types[j2];
                                UniqueName uniqueName = NameUtil.getTypeUniqueName(this.myJavaProject, type);
                                classes.remove(uniqueName);
                                this.removeTemporarilyGeneralizationLinks(type);
                                ++j2;
                            }
                            ++i2;
                        }
                        ++p;
                    }
                    return EnumerationConverter.toUniqueNameEnumeration(classes.iterator());
                }
                if (NameUtil.isJarRootUniqueName(parentUniqueName) || NameUtil.isJarPackageUniqueName(parentUniqueName)) {
                    IPackageFragment[] packageFragments = ElementUtil.getJarPackageFragmentsByUniqueName(this.myJavaProject, parentUniqueName);
                    HashSet<UniqueName> classes = new HashSet<UniqueName>();
                    int p = 0;
                    while (p < packageFragments.length) {
                        IPackageFragment packageFragment = packageFragments[p];
                        IClassFile[] classFiles = packageFragment.getClassFiles();
                        int i = 0;
                        while (i < classFiles.length) {
                            IType type = classFiles[i].getType();
                            UniqueName uniqueName = NameUtil.getTypeUniqueName("bin", NameUtil.getTypeQualifiedName(type));
                            if (!NameUtil.isInnerElement(uniqueName)) {
                                this.myElementsCache.putPermanentElement(uniqueName, (IJavaElement)type);
                                classes.add(uniqueName);
                            }
                            ++i;
                        }
                        ++p;
                    }
                    return EnumerationConverter.toUniqueNameEnumeration(classes.iterator());
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return EmptyEnumeration.getUniqueNameEnumeration();
    }

    private void addPermanentGeneralizationLinks(IType type) {
        try {
            if (type.isClass()) {
                String[] values;
                String superclassName = type.getSuperclassName();
                if (superclassName != null) {
                    values = new String[]{superclassName};
                    this.myLinksCache.addPermanentGeneralizationLinks(type, values);
                }
                if ((values = type.getSuperInterfaceNames()).length > 0) {
                    this.myLinksCache.addPermanentImplementationLinks(type, values);
                }
            } else {
                String[] values = type.getSuperInterfaceNames();
                if (values.length > 0) {
                    this.myLinksCache.addPermanentGeneralizationLinks(type, values);
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    private void addTemporarilyGeneralizationLinks(IType type) {
        try {
            if (!type.exists()) {
                return;
            }
            if (type.isClass()) {
                String[] values;
                String superclassName = type.getSuperclassName();
                if (superclassName != null) {
                    values = new String[]{superclassName};
                    this.myLinksCache.addTemporarilyGeneralizationLinks(type, values);
                }
                if ((values = type.getSuperInterfaceNames()).length > 0) {
                    this.myLinksCache.addTemporarilyImplementationLinks(type, values);
                }
            } else {
                String[] values = type.getSuperInterfaceNames();
                if (values.length > 0) {
                    this.myLinksCache.addTemporarilyGeneralizationLinks(type, values);
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    private void removeTemporarilyGeneralizationLinks(IType type) {
        try {
            if (type.exists() && type.isClass()) {
                if (type.isClass()) {
                    String[] values;
                    String superclassName = type.getSuperclassName();
                    if (superclassName != null) {
                        values = new String[]{superclassName};
                        this.myLinksCache.removeTemporarilyGeneralizationLinks(type);
                    }
                    if ((values = type.getSuperInterfaceNames()).length > 0) {
                        this.myLinksCache.removeTemporarilyImplementationLinks(type);
                    }
                } else {
                    String[] values = type.getSuperInterfaceNames();
                    if (values.length > 0) {
                        this.myLinksCache.removeTemporarilyGeneralizationLinks(type);
                    }
                }
            } else {
                this.myLinksCache.removeTemporarilyGeneralizationLinks(type);
                this.myLinksCache.removeTemporarilyImplementationLinks(type);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }
}

