/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import java.util.HashSet;

public class TypeNameUtil {
    static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"};
    static final HashSet ourPrimitiveTypes = new HashSet();

    public static boolean isVoid(String typeName) {
        return "void".equals(typeName);
    }

    public static boolean isPrimitiveType(String typeName) {
        if (typeName == null) {
            return true;
        }
        if (TypeNameUtil.isArrayType(typeName)) {
            typeName = TypeNameUtil.getClearType(typeName);
        }
        return ourPrimitiveTypes.contains(typeName);
    }

    public static boolean isNonPrimitiveType(String typeName) {
        if (TypeNameUtil.isPrimitiveType(typeName)) {
            return false;
        }
        if (TypeNameUtil.isVoid(typeName)) {
            return false;
        }
        if (typeName != null && typeName.length() > 0) {
            char firstChar;
            if (typeName.indexOf("..") != -1) {
                return false;
            }
            if (TypeNameUtil.isArrayType(typeName)) {
                typeName = TypeNameUtil.getClearType(typeName);
            }
            if (!Character.isJavaIdentifierStart(firstChar = typeName.charAt(0))) {
                return false;
            }
            int i = 1;
            while (i < typeName.length()) {
                firstChar = typeName.charAt(i);
                if ('.' != firstChar && !Character.isJavaIdentifierPart(firstChar)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String getClearType(String typeName) {
        int index = typeName.indexOf("[");
        if (index != -1) {
            typeName = typeName.substring(0, index).trim();
        }
        return typeName;
    }

    public static boolean isArrayType(String typeName) {
        typeName = typeName.trim();
        int left = typeName.indexOf("[");
        int right = typeName.indexOf("]");
        return typeName.endsWith("]") && left < right;
    }

    public static String getArrayType(String typeName, int rank) {
        typeName = typeName.trim();
        int i = 0;
        while (i < rank) {
            typeName = typeName + "[]";
            ++i;
        }
        return typeName;
    }

    static {
        int i = 0;
        while (i < PRIMITIVE_TYPES.length) {
            ourPrimitiveTypes.add(PRIMITIVE_TYPES[i]);
            ++i;
        }
    }
}

