/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeNameResolver {
    public static String[] resolveTypes(Model model, IType type, String[] typeNames) {
        HashSet<String> classes = new HashSet<String>();
        int i = 0;
        while (i < typeNames.length) {
            String resolvedType = TypeNameResolver.resolveType(model, type, typeNames[i], true);
            if (resolvedType != null) {
                classes.add(resolvedType);
            }
            ++i;
        }
        String[] resolvedTypes = new String[classes.size()];
        ((AbstractCollection)classes).toArray(resolvedTypes);
        return resolvedTypes;
    }

    public static String resolveTypeName(IType type, String typeName) {
        String[] resolveNames = TypeNameResolver.innerResolveTypeName(type, typeName);
        return TypeNameResolver.getFullName(resolveNames);
    }

    public static String resolveType(Model model, IType type, String typeName, boolean returnUniqueName) {
        if (type == null || typeName == null) {
            return null;
        }
        String[] resolvedName = TypeNameResolver.innerResolveTypeName(type, typeName = TypeNameUtil.getClearType(typeName));
        if (resolvedName == null) {
            return null;
        }
        String fullResolvedName = TypeNameResolver.getFullName(resolvedName);
        if (returnUniqueName) {
            IJavaProject javaProject = ElementUtil.getJavaProject(model.getUniqueName());
            int kind = TypeNameResolver.resolveRoot(javaProject, resolvedName[0], resolvedName[1]);
            UniqueName uniqueName = kind == 1 ? NameUtil.getTypeUniqueName("src", fullResolvedName) : (kind == 2 ? NameUtil.getTypeUniqueName("bin", fullResolvedName) : NameUtil.getTypeUniqueName("ref", fullResolvedName));
            return uniqueName.toString();
        }
        return fullResolvedName;
    }

    private static String[] innerResolveTypeName(IType type, String typeName) {
        block9: {
            if (TypeNameUtil.isPrimitiveType(typeName) || TypeNameUtil.isVoid(typeName)) {
                return null;
            }
            typeName = NameUtil.fixupTypeNameForJDT(typeName);
            if (type.getClassFile() != null) {
                String packageName = NameUtil.getFirstPart(typeName, false);
                String typeShortName = NameUtil.getSecondPart(typeName, false);
                return new String[]{packageName, typeShortName};
            }
            String packageName = type.getPackageFragment().getElementName();
            String typeFullName = type.getFullyQualifiedName('.');
            String typeShortName = type.getElementName();
            packageName = packageName.length() == 0 ? "" : packageName + ".";
            try {
                if (typeName.indexOf(46) == -1) {
                    if (typeShortName.equals(typeName)) {
                        return new String[]{type.getPackageFragment().getElementName(), typeShortName};
                    }
                    String[][] resolvedNames = type.resolveType(typeName);
                    if (resolvedNames != null) {
                        return TypeNameResolver.getFullName(resolvedNames);
                    }
                    resolvedNames = TypeNameResolver.resolveInDefaultPackage(type.getJavaProject(), typeName);
                    if (resolvedNames != null) {
                        return TypeNameResolver.getFullName(resolvedNames);
                    }
                    break block9;
                }
                String[][] resolvedNames = type.resolveType(typeName);
                if (resolvedNames != null) {
                    return TypeNameResolver.getFullName(resolvedNames);
                }
                typeName = packageName + typeName;
                resolvedNames = type.resolveType(typeName);
                return TypeNameResolver.getFullName(resolvedNames);
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return null;
    }

    private static String[] getFullName(String[][] resolvedNames) {
        if (resolvedNames != null) {
            return new String[]{resolvedNames[0][0], resolvedNames[0][1]};
        }
        return null;
    }

    private static String[][] resolveInDefaultPackage(IJavaProject javaProject, String typeName) {
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < allPackageFragmentRoots.length) {
                IClassFile classFile;
                ICompilationUnit compilationUnit;
                IPackageFragmentRoot packageFragmentRoot = allPackageFragmentRoots[i];
                IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment("");
                if (packageFragmentRoot.getKind() == 1 ? (compilationUnit = packageFragment.getCompilationUnit(typeName + ".java")) != null && compilationUnit.exists() : (classFile = packageFragment.getClassFile(typeName + ".class")) != null && classFile.exists()) {
                    return new String[][]{{"", typeName}, new String[0]};
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    private static String getFullName(String[] resolvedName) {
        if (resolvedName != null) {
            String resolvedPackageName = resolvedName[0];
            String resolvedTypeName = resolvedName[1];
            resolvedTypeName = NameUtil.fixupTypeNameForUIN(resolvedTypeName);
            resolvedTypeName = resolvedTypeName.replace('.', '$');
            return resolvedPackageName.length() > 0 ? resolvedPackageName + "." + resolvedTypeName : resolvedTypeName;
        }
        return null;
    }

    private static int resolveRoot(IJavaProject javaProject, String packageName, String typeName) {
        try {
            IPackageFragmentRoot[] packageFragmentRoots = JDTUtil.getPackageFragmentRoots(javaProject, 1);
            int i = 0;
            while (i < packageFragmentRoots.length) {
                IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[i];
                IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
                if (packageFragment != null && packageFragment.exists()) {
                    ICompilationUnit[] compilationUnits = packageFragment.getCompilationUnits();
                    String publicTypeName = typeName;
                    int index = publicTypeName.indexOf(46);
                    if (index != -1) {
                        publicTypeName = publicTypeName.substring(0, index);
                    }
                    int j = 0;
                    while (j < compilationUnits.length) {
                        IType type = compilationUnits[j].getType(publicTypeName);
                        if (type != null && type.exists()) {
                            return 1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            packageFragmentRoots = JDTUtil.getPackageFragmentRoots(javaProject, 2);
            int i2 = 0;
            while (i2 < packageFragmentRoots.length) {
                IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[i2];
                IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
                IClassFile classFile = packageFragment.getClassFile(typeName + ".class");
                if (classFile != null && classFile.exists()) {
                    return 2;
                }
                ++i2;
            }
            return 3;
        }
        catch (JavaModelException e) {
            return 0;
        }
    }
}

