/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.TypeHelper;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import org.eclipse.jdt.core.jdom.IDOMType;

public class TypeHelper {
    private static final String EXTENDS_CLAUSE = "extends";
    private static final String IMPLEMENTS_CLAUSE = "implements";

    public static String removeUnnecessarySpaces(String content) {
        String STR_TO_PATCH = "  implements ";
        if (content != null) {
            int index = content.indexOf(STR_TO_PATCH);
            if (index != -1) {
                int i = index;
                while (i > 0) {
                    char ch = content.charAt(i);
                    if (!Character.isSpaceChar(ch)) {
                        ++i;
                        break;
                    }
                    --i;
                }
                content = content.substring(0, i) + " implements " + content.substring(index + STR_TO_PATCH.length(), content.length());
            }
            return content;
        }
        return null;
    }

    public static String removeSuperclass(IDOMType type) {
        if (type.getSuperclass() != null) {
            return TypeHelper.removeSuperClause(type, EXTENDS_CLAUSE, type.getSuperclass().trim());
        }
        return null;
    }

    public static String removeLastSuperinterface(IDOMType type) {
        String[] superIFace = type.getSuperInterfaces();
        if (superIFace != null && superIFace.length == 1) {
            return TypeHelper.removeSuperClause(type, type.isClass() ? IMPLEMENTS_CLAUSE : EXTENDS_CLAUSE, superIFace[0].trim());
        }
        return null;
    }

    private static String removeSuperClause(IDOMType type, String clause, String typeName) {
        String result = null;
        String source = type.getContents();
        int index1 = TypeHelper.findFirstToken(source, 0, clause);
        if (index1 == -1) {
            return null;
        }
        int index2 = TypeHelper.findFirstToken(source, index1, typeName);
        if (index2 == -1) {
            return null;
        }
        index2 += index1;
        StringBuffer sb = new StringBuffer(source.length());
        sb.append(source.substring(0, index1));
        int toAdd = 0;
        if (source.charAt(index1 + clause.length()) == ' ') {
            toAdd = 1;
        }
        sb.append(source.substring(index1 + clause.length() + toAdd, index2));
        toAdd = source.charAt(index2 + typeName.length()) == ' ' ? 1 : 0;
        sb.append(source.substring(index2 + typeName.length() + toAdd));
        result = sb.toString();
        return result;
    }

    private static int findFirstToken(String source, int from, String token) {
        String substring = source.substring(from);
        char[] chars = new char[substring.length()];
        substring.getChars(0, chars.length, chars, 0);
        class MyCharArrayReader
        extends CharArrayReader {
            private final /* synthetic */ char[] val$chars;

            MyCharArrayReader(char[] val$chars) {
                super(val$chars);
                this.val$chars = val$chars;
            }

            public int currentPos() {
                return this.pos;
            }
        }
        MyCharArrayReader mcar = new MyCharArrayReader(chars);
        StreamTokenizer st = new StreamTokenizer(mcar);
        st.wordChars(95, 95);
        try {
            while (st.nextToken() != -1) {
                if (st.ttype != -3 || !st.sval.equals(token)) continue;
                return mcar.currentPos() - token.length() - 1;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return -1;
    }
}

