/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class SiblingUtil {
    public static final String DEFAULT_MEMBER_ORDER = "default_member_order";
    public static final String DEFAULT_VISIBILITY_ORDER = "default_visibility_order";
    private static final String FIELD_STR = "Field";
    private static final String CONSTRUCTOR_STR = "Constructor";
    private static final String METHOD_STR = "Method";
    private static final String INNER_CLASS_STR = "Inner Class";
    private static final String INNER_INTERFACE_STR = "Inner Interface";
    public static final int FIELD = 0;
    public static final int CONSTRUCTOR = 1;
    public static final int METHOD = 2;
    public static final int INNER_CLASS = 3;
    public static final int INNER_INTERFACE = 4;
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACAGE_LOCAL = 2;
    public static final int PRIVATE = 3;

    public static IJavaElement getSibling(IType type, int memberKind, int visibilityKind) {
        try {
            IJavaElement[] javaElements = type.getChildren();
            if (javaElements.length == 0) {
                return null;
            }
            IJavaElement firstJavaElements = javaElements[0];
            IJavaElement lastJavaElements = javaElements[javaElements.length - 1];
            int[] order = SiblingUtil.getMemberOrder();
            int pos = -1;
            int i = 0;
            while (i < order.length) {
                if (order[i] == memberKind) {
                    pos = i;
                }
                ++i;
            }
            if (pos == -1) {
                return null;
            }
            return SiblingUtil.getNextMember(javaElements, order, pos);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    private static IJavaElement getNextMember(IJavaElement[] javaElements, int[] order, int pos) throws JavaModelException {
        int i = pos;
        while (i < order.length) {
            int kind = order[i];
            IJavaElement javaElement = SiblingUtil.getFirstMember(javaElements, kind);
            if (javaElement != null) {
                return javaElement;
            }
            ++i;
        }
        return null;
    }

    private static IJavaElement getFirstMember(IJavaElement[] javaElements, int kind) throws JavaModelException {
        block11: {
            block14: {
                block13: {
                    block12: {
                        block10: {
                            if (kind != 0) break block10;
                            int i = 0;
                            while (i < javaElements.length) {
                                IJavaElement javaElement = javaElements[i];
                                if (javaElement instanceof IField) {
                                    return (IMember)javaElement;
                                }
                                ++i;
                            }
                            break block11;
                        }
                        if (kind != 1) break block12;
                        int i = 0;
                        while (i < javaElements.length) {
                            IJavaElement javaElement = javaElements[i];
                            if (javaElement instanceof IMethod && ((IMethod)javaElement).isConstructor()) {
                                return (IMember)javaElement;
                            }
                            ++i;
                        }
                        break block11;
                    }
                    if (kind != 2) break block13;
                    int i = 0;
                    while (i < javaElements.length) {
                        IJavaElement javaElement = javaElements[i];
                        if (javaElement instanceof IMethod && !((IMethod)javaElement).isConstructor()) {
                            return (IMember)javaElement;
                        }
                        ++i;
                    }
                    break block11;
                }
                if (kind != 3) break block14;
                int i = 0;
                while (i < javaElements.length) {
                    IJavaElement javaElement = javaElements[i];
                    if (javaElement instanceof IType && ((IType)javaElement).isClass()) {
                        return (IMember)javaElement;
                    }
                    ++i;
                }
                break block11;
            }
            if (kind != 4) break block11;
            int i = 0;
            while (i < javaElements.length) {
                IJavaElement javaElement = javaElements[i];
                if (javaElement instanceof IType && ((IType)javaElement).isInterface()) {
                    return (IMember)javaElement;
                }
                ++i;
            }
        }
        return null;
    }

    private static int[] getMemberOrder() {
        ArrayList order = SiblingUtil.getOrder(DEFAULT_MEMBER_ORDER);
        int[] memberOrder = new int[order.size()];
        int i = 0;
        Iterator iter = ((AbstractList)order).iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            if (FIELD_STR.equals(element)) {
                memberOrder[i] = 0;
            } else if (CONSTRUCTOR_STR.equals(element)) {
                memberOrder[i] = 1;
            } else if (METHOD_STR.equals(element)) {
                memberOrder[i] = 2;
            } else if (INNER_CLASS_STR.equals(element)) {
                memberOrder[i] = 3;
            } else if (INNER_INTERFACE_STR.equals(element)) {
                memberOrder[i] = 4;
            }
            ++i;
        }
        return memberOrder;
    }

    private static ArrayList getOrder(String preferenceName) {
        String value = JavaProviderPlugin.getPreferenceStore().getString(preferenceName);
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (list.contains(token)) continue;
                list.add(token);
            }
        }
        return list;
    }
}

