/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.refactor.RefactorPerformer;
import com.tssap.selena.internal.core.providers.java.refactor.RenameRefactoringFactory;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;

public class RenameUtil {
    public static boolean canSetName(IJavaElement javaElement, String propertyValue) {
        return RenameUtil.canSetName(javaElement, propertyValue, false);
    }

    public static boolean canSetName(IJavaElement javaElement, String propertyValue, boolean allowDuplication) {
        String oldName = javaElement.getElementName();
        if (propertyValue.equals(oldName = NameUtil.getSecondPart(oldName, false))) {
            return true;
        }
        return RenameUtil.checkNewName(javaElement, propertyValue, allowDuplication);
    }

    private static boolean checkNewName(IJavaElement javaElement, String propertyValue, boolean allowDuplication) {
        if (!(javaElement instanceof ISourceManipulation) || !ElementUtil.isWritableElement(javaElement)) {
            return false;
        }
        if (propertyValue == null) {
            return false;
        }
        if (propertyValue.indexOf(".") != -1) {
            return false;
        }
        String oldName = javaElement.getElementName();
        if (javaElement instanceof IPackageFragment) {
            propertyValue = RenameUtil.getParentPackagePart(oldName) + propertyValue;
        }
        if (propertyValue.equals(oldName)) {
            return true;
        }
        try {
            IJavaElement parentJavaElement = javaElement.getParent();
            IStatus status = null;
            if (javaElement instanceof IPackageFragment) {
                ArrayList<String> usedNames = new ArrayList<String>();
                IJavaProject myJavaProject = javaElement.getJavaProject();
                IPackageFragment[] packageFragments = myJavaProject.getPackageFragments();
                int i = 0;
                while (i < packageFragments.length) {
                    usedNames.add(packageFragments[i].getElementName());
                    if (packageFragments[i].getElementName() != null && packageFragments[i].getElementName().equalsIgnoreCase(propertyValue)) {
                        return false;
                    }
                    ++i;
                }
                if (usedNames.contains(propertyValue)) {
                    return false;
                }
                status = JavaConventions.validatePackageName((String)propertyValue);
            } else if (javaElement instanceof IType) {
                ArrayList<String> usedNames = new ArrayList<String>();
                if (parentJavaElement instanceof IType) {
                    usedNames.add(parentJavaElement.getElementName());
                    IJavaElement[] children = ((IType)parentJavaElement).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IType) {
                            usedNames.add(children[i].getElementName());
                        }
                        ++i;
                    }
                    if (usedNames.contains(propertyValue)) {
                        return false;
                    }
                } else if (parentJavaElement instanceof ICompilationUnit) {
                    ICompilationUnit[] compilationUnits = ((IPackageFragment)parentJavaElement.getParent()).getCompilationUnits();
                    int i = 0;
                    while (i < compilationUnits.length) {
                        IType[] types = compilationUnits[i].getTypes();
                        int j = 0;
                        while (j < types.length) {
                            usedNames.add(types[j].getElementName());
                            if (types[j].getElementName() != null && types[j].getElementName().equalsIgnoreCase(propertyValue)) {
                                return false;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (usedNames.contains(propertyValue)) {
                        return false;
                    }
                } else {
                    return false;
                }
                status = JavaConventions.validateJavaTypeName((String)propertyValue);
            } else if (javaElement instanceof IMethod) {
                IMethod method = (IMethod)javaElement;
                IType type = method.getDeclaringType();
                if (type.isInterface() && type.getElementName().equals(propertyValue)) {
                    return false;
                }
                String methodName = method.getElementName();
                if (method.isConstructor()) {
                    return methodName.equals(propertyValue);
                }
                if (methodName.equals(propertyValue)) {
                    return false;
                }
                if (allowDuplication) {
                    String signature = method.getSignature();
                    IMethod[] methods = type.getMethods();
                    int i = 0;
                    while (i < methods.length) {
                        IMethod existingMethod = methods[i];
                        String existingMethodName = existingMethod.getElementName();
                        String existingMethodSignature = existingMethod.getSignature();
                        if (existingMethodName.equals(propertyValue) && existingMethodSignature.equals(signature)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                ArrayList<String> usedNames = new ArrayList<String>();
                IMethod[] methods = type.getMethods();
                int i = 0;
                while (i < methods.length) {
                    usedNames.add(methods[i].getElementName());
                    ++i;
                }
                if (usedNames.contains(propertyValue)) {
                    return false;
                }
                status = JavaConventions.validateMethodName((String)propertyValue);
            } else if (javaElement instanceof IField) {
                if (!(parentJavaElement instanceof IType)) {
                    return false;
                }
                ArrayList<String> usedNames = new ArrayList<String>();
                IField[] fields = ((IType)parentJavaElement).getFields();
                int i = 0;
                while (i < fields.length) {
                    usedNames.add(fields[i].getElementName());
                    ++i;
                }
                if (usedNames.contains(propertyValue)) {
                    return false;
                }
                status = JavaConventions.validateFieldName((String)propertyValue);
            }
            if (status != null && status.getSeverity() != 4) {
                return true;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return false;
    }

    private static boolean canRefactorToNewName(IJavaElement javaElement, String propertyValue) {
        IRenameRefactoring refactoring = RenameRefactoringFactory.getRenameRefactoring(javaElement);
        if (refactoring == null) {
            return false;
        }
        return RefactorPerformer.canPerformNaive(refactoring, propertyValue, RenameUtil.isRefactoringWarningsAllowed());
    }

    public static boolean setName(IJavaProject javaProject, IJavaElement javaElement, String propertyValue) {
        IJavaElement originalElement;
        String oldName = javaElement.getElementName();
        if (propertyValue.equals(oldName = NameUtil.getSecondPart(oldName, false))) {
            return true;
        }
        EditorUtil.saveAllEditors(true);
        ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit(javaElement);
        ICompilationUnit originalCompilationUnit = (ICompilationUnit)compilationUnit.getOriginalElement();
        if (originalCompilationUnit == null) {
            originalCompilationUnit = compilationUnit;
        }
        if (javaElement instanceof IType && javaElement.getParent() instanceof ICompilationUnit) {
            EditorUtil.saveEditorPartEvenIfNotDirty((IJavaElement)compilationUnit);
        }
        if ((originalElement = originalCompilationUnit.getOriginal(javaElement)) != null) {
            javaElement = originalElement;
        }
        boolean isUseRefactoring = true;
        if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            try {
                isUseRefactoring = !Flags.isNative((int)method.getFlags());
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        if (RenameUtil.canRefactorToNewName(javaElement, propertyValue) && isUseRefactoring) {
            return RenameUtil.refactorToNewName(javaProject, javaElement, propertyValue) != null;
        }
        return RenameUtil.setNameWithoutRefactoring(javaProject, javaElement, propertyValue);
    }

    private static UniqueName refactorToNewName(IJavaProject javaProject, IJavaElement javaElement, String propertyValue) {
        IRenameRefactoring refactoring = RenameRefactoringFactory.getRenameRefactoring(javaElement);
        if (refactoring == null) {
            return null;
        }
        if (!RefactorPerformer.perform(refactoring, propertyValue, RenameUtil.isRefactoringWarningsAllowed())) {
            return null;
        }
        try {
            IJavaElement newElement = (IJavaElement)refactoring.getNewElement();
            return NameUtil.getJavaElementUniqueName(javaProject, newElement);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    private static boolean setNameWithoutRefactoring(IJavaProject javaProject, IJavaElement javaElement, String propertyValue) {
        String oldName = javaElement.getElementName();
        if (javaElement instanceof IPackageFragment) {
            propertyValue = RenameUtil.getParentPackagePart(oldName) + propertyValue;
        }
        UniqueName oldUniqueName = NameUtil.getJavaElementUniqueName(javaProject, javaElement);
        if (propertyValue.equals(oldName)) {
            return true;
        }
        String newName = propertyValue;
        try {
            IJavaElement parent = javaElement.getParent();
            if (javaElement instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                packageFragment.rename(newName, true, null);
                return true;
            }
            if (javaElement instanceof IType && parent instanceof ICompilationUnit) {
                IType type = (IType)javaElement;
                type.rename(newName, true, null);
                return true;
            }
            if (javaElement instanceof IMember) {
                IMember member = (IMember)javaElement;
                member.rename(newName, true, null);
                return true;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return false;
    }

    private static String getParentPackagePart(String name) {
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex != -1) {
            return name.substring(0, dotIndex) + ".";
        }
        return "";
    }

    private static boolean isRefactoringWarningsAllowed() {
        return true;
    }
}

