/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ParticipantAdapter;
import org.eclipse.jdt.core.IType;

public class ReferenceParticipant
extends ParticipantAdapter {
    private String myMetaclass;
    private Model myModel;
    private IType myOwner;
    private String myShortTypeName;
    private String myFullTypeName;
    private String myFullName;
    private UniqueName myUniqueName;

    public ReferenceParticipant(String role, Model model, IType owner, String typeName) {
        this(role, model, owner, typeName, null);
    }

    public ReferenceParticipant(String role, Model model, IType owner, String typeName, String metaclass) {
        super(role);
        this.myModel = model;
        this.myOwner = owner;
        if (typeName != null) {
            this.myFullTypeName = typeName;
            if (typeName.lastIndexOf(46) >= 0) {
                this.myShortTypeName = typeName.substring(typeName.lastIndexOf(46) + 1);
                this.myFullName = typeName;
            } else {
                this.myShortTypeName = typeName;
            }
        }
        this.myFullTypeName = NameUtil.fixupTypeNameForUIN(this.myFullTypeName);
        this.myMetaclass = metaclass;
    }

    public String getPropertyValue(String propertyName) {
        if ("$name".equals(propertyName)) {
            return this.myShortTypeName;
        }
        if ("$metaclass".equals(propertyName)) {
            return this.myMetaclass;
        }
        if ("$fullName".equals(propertyName)) {
            return this.myFullName;
        }
        return null;
    }

    public UniqueName getUniqueName() {
        if (this.myUniqueName == null) {
            String uin = TypeNameResolver.resolveType(this.myModel, this.myOwner, this.myFullTypeName, true);
            this.myUniqueName = ModelAccess.createUniqueName((String)uin);
        }
        return this.myUniqueName;
    }
}

