/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ProjectUtil {
    public static Model[] getReferencingModels(IJavaProject[] javaProjects) {
        ArrayList<Model> list = new ArrayList<Model>();
        int i = 0;
        while (i < javaProjects.length) {
            UniqueName uniqueName;
            Model model;
            IJavaProject javaProject = javaProjects[i];
            if (javaProject.exists() && javaProject.isOpen() && (model = ModelAccess.createModel((UniqueName)(uniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName())))) != null && !model.isDeleted()) {
                list.add(model);
            }
            ++i;
        }
        return list.toArray(new Model[list.size()]);
    }

    public static String[] getReferencingProjectsNames(IJavaProject javaProject) {
        IJavaProject[] javaProjects = ProjectUtil.getReferencingProjects(javaProject);
        String[] projectsNames = new String[javaProjects.length];
        int i = 0;
        while (i < javaProjects.length) {
            projectsNames[i] = javaProjects[i].getElementName();
            ++i;
        }
        return projectsNames;
    }

    public static IJavaProject[] getReferencingProjects(IJavaProject javaProject) {
        try {
            if (javaProject == null || !javaProject.exists()) {
                return new IJavaProject[0];
            }
            ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
            list.add(javaProject);
            IProject project = javaProject.getProject();
            IProject[] projects = project.getReferencingProjects();
            if (project != null) {
                int i = 0;
                while (i < projects.length) {
                    IJavaProject refJavaProject;
                    IProject refProject = projects[i];
                    if (refProject.hasNature("org.eclipse.jdt.core.javanature") && (refJavaProject = JavaCore.create((IProject)refProject)).exists() && refJavaProject.isOpen()) {
                        list.add(refJavaProject);
                    }
                    ++i;
                }
            }
            return list.toArray(new IJavaProject[list.size()]);
        }
        catch (CoreException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return new IJavaProject[0];
        }
    }

    public static String[] getReferencedProjectsNames(IJavaProject javaProject) {
        IJavaProject[] javaProjects = ProjectUtil.getReferencedProjects(javaProject);
        String[] projectsNames = new String[javaProjects.length];
        int i = 0;
        while (i < javaProjects.length) {
            projectsNames[i] = javaProjects[i].getElementName();
            ++i;
        }
        return projectsNames;
    }

    public static IJavaProject[] getReferencedProjects(IJavaProject javaProject) {
        try {
            if (javaProject == null || !javaProject.exists()) {
                return new IJavaProject[0];
            }
            ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
            list.add(javaProject);
            IProject project = javaProject.getProject();
            IProject[] projects = project.getReferencedProjects();
            if (project != null) {
                int i = 0;
                while (i < projects.length) {
                    IJavaProject refJavaProject;
                    IProject refProject = projects[i];
                    if (refProject.isOpen() && refProject.hasNature("org.eclipse.jdt.core.javanature") && (refJavaProject = JavaCore.create((IProject)refProject)).exists()) {
                        list.add(refJavaProject);
                    }
                    ++i;
                }
            }
            return list.toArray(new IJavaProject[list.size()]);
        }
        catch (CoreException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return new IJavaProject[0];
        }
    }
}

