/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.delta.CompilationUnitPatcher;
import com.tssap.selena.internal.core.providers.java.delta.DropCacheListener;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.UniqueName;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;

public class ParsersCache
implements ModelAccessListener,
DropCacheListener {
    private static HashMap ourModel2Class = new HashMap();
    private ReferenceQueue queue = new ReferenceQueue();
    private HashMap ourElement2Parser = new HashMap();

    private ParsersCache() {
    }

    public static void startup() {
        ParsersCache parsersCache = new ParsersCache();
        ModelAccess.addModelAccessListener((ModelAccessListener)parsersCache);
        CompilationUnitPatcher.addWorkingCopyDropCacheListener(parsersCache);
    }

    public static void shutdown() {
    }

    public void dropCache(Model model, UniqueName uniqueName) {
        HashMap ourClass2ParsersCache = (HashMap)ourModel2Class.get(model);
        if (ourClass2ParsersCache != null) {
            Iterator itr = ourClass2ParsersCache.values().iterator();
            while (itr.hasNext()) {
                ParsersCache parsersCache = (ParsersCache)itr.next();
                parsersCache.delete(uniqueName);
            }
        }
    }

    public void modelCreated(ModelAccessEvent event) {
    }

    public void modelRemoved(ModelAccessEvent event) {
        Model model = event.getModel();
        ourModel2Class.remove(model);
    }

    public static ParsersCache getInstance(Model model, Class clazz) {
        ParsersCache parsersCache;
        HashMap<Class, ParsersCache> ourClass2ParsersCache = (HashMap<Class, ParsersCache>)ourModel2Class.get(model);
        if (ourClass2ParsersCache == null) {
            ourClass2ParsersCache = new HashMap<Class, ParsersCache>();
            ourModel2Class.put(model, ourClass2ParsersCache);
        }
        if ((parsersCache = (ParsersCache)ourClass2ParsersCache.get(clazz)) == null) {
            parsersCache = new ParsersCache();
            ourClass2ParsersCache.put(clazz, parsersCache);
        }
        return parsersCache;
    }

    public boolean contains(UniqueName uniqueName) {
        boolean result = false;
        WeakReference ref = (WeakReference)this.ourElement2Parser.get(uniqueName);
        result = ref != null && !ref.isEnqueued();
        return result;
    }

    public Object get(UniqueName uniqueName) {
        Object object = null;
        WeakReference ref = (WeakReference)this.ourElement2Parser.get(uniqueName);
        if (ref != null && !ref.isEnqueued()) {
            object = ref.get();
        }
        this.cleanup();
        return object;
    }

    public void put(UniqueName uniqueName, Object parser) {
        this.ourElement2Parser.put(uniqueName, new WeakReferenceEx(uniqueName, parser, this.queue));
    }

    public void delete(UniqueName uniqueName) {
        this.ourElement2Parser.remove(uniqueName);
    }

    protected void cleanup() {
        WeakReferenceEx ref = (WeakReferenceEx)this.queue.poll();
        while (ref != null) {
            this.ourElement2Parser.remove(ref.getUniqueName());
            ref = (WeakReferenceEx)this.queue.poll();
        }
    }

    private static class WeakReferenceEx
    extends WeakReference {
        private UniqueName myUniqueName;

        public WeakReferenceEx(UniqueName uniqueName, Object parser, ReferenceQueue queue) {
            super(parser, queue);
            this.myUniqueName = uniqueName;
        }

        public UniqueName getUniqueName() {
            return this.myUniqueName;
        }
    }
}

