/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.OldUniqueNameUtil;
import com.tssap.selena.internal.core.providers.java.delta.DeletedClassesDeltaPatch;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.ProjectRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;

public class PackageFragmentRootListener
implements IElementChangedListener {
    private IJavaProject myCurrentProject;
    private final HashSet myProjectsToReload = new HashSet();

    public PackageFragmentRootListener() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                JavaCore.addElementChangedListener((IElementChangedListener)PackageFragmentRootListener.this);
            }
        });
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        if (delta != null && delta.getElement() != null && delta.getElement().getElementType() == 1) {
            this.myCurrentProject = null;
            this.myProjectsToReload.clear();
            this.processDelta(delta);
            this.fireReloadRoots();
        }
    }

    private void processDelta(IJavaElementDelta delta) {
        IJavaElement changedElement = delta.getElement();
        if (changedElement == null) {
            return;
        }
        switch (changedElement.getElementType()) {
            case 1: {
                this.myCurrentProject = null;
                this.processSubDeltas(delta);
                break;
            }
            case 2: {
                if (PackageFragmentRootListener.testDeltaFlag(delta, 1536)) {
                    return;
                }
                this.myCurrentProject = (IJavaProject)changedElement;
                this.processSubDeltas(delta);
                break;
            }
            case 3: {
                if (this.isRootRemoved(delta) || this.isRootAdded(delta)) {
                    if (this.myCurrentProject.equals(changedElement.getJavaProject())) {
                        this.addProjectToReload(this.myCurrentProject);
                    }
                    if (!this.isRootRemoved(delta) || this.myCurrentProject == null) break;
                    UniqueName modelUin = ModelUinSupport.createModelUin((IResource)this.myCurrentProject.getProject());
                    ElementCacheAccess.getElementsCache(modelUin).dropAllPackages();
                    break;
                }
                this.processSubDeltas(delta);
                break;
            }
            case 4: {
                if (delta.getKind() != 2) break;
                this.synchronizeDesignRoot(delta, (IPackageFragment)changedElement);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void processSubDeltas(IJavaElementDelta delta) {
        IJavaElementDelta[] subdeltas = delta.getAffectedChildren();
        int i = 0;
        while (i < subdeltas.length) {
            this.processDelta(subdeltas[i]);
            ++i;
        }
    }

    private void synchronizeDesignRoot(IJavaElementDelta delta, IPackageFragment removedPackage) {
        if (this.myCurrentProject == null) {
            return;
        }
        DeletedClassesDeltaPatch.deletedClassesDeltaPatch(this.myCurrentProject, delta, true, true);
        if (delta.getKind() == 2 && this.isLastPackageFragmentRemoved(removedPackage)) {
            IPackageFragment newPackage;
            IPath javaFullPath = removedPackage.getPath();
            ProjectRelativePath javaRelativePath = ProjectRelativePath.valueOf((IPath)javaFullPath.removeFirstSegments(1));
            if (PackageFragmentRootListener.testDeltaFlag(delta, 32) && (newPackage = (IPackageFragment)delta.getMovedToElement()) != null && newPackage.exists() && newPackage.getJavaProject().equals(this.myCurrentProject)) {
                IPath javaMovedToPath = newPackage.getPath();
                ProjectRelativePath javaMovedToRelativePath = ProjectRelativePath.valueOf((IPath)javaMovedToPath.removeFirstSegments(1));
                Map substitutionMap = PackageFragmentRootListener.createStringsSubstitutionMap(removedPackage, newPackage);
                DesignRootAccess.getInstance((IProject)this.myCurrentProject.getProject()).getJavaPackageSynchronizer().handleJavaPackageRenaming((IProjectRelativePath)javaRelativePath, (IProjectRelativePath)javaMovedToRelativePath, substitutionMap);
                this.performParentFolderDeletion(removedPackage);
                return;
            }
            DesignRootAccess.getInstance((IProject)this.myCurrentProject.getProject()).getJavaPackageSynchronizer().handleJavaPackageDeletion((IProjectRelativePath)javaRelativePath);
            this.performParentFolderDeletion(removedPackage);
        }
    }

    private void performParentFolderDeletion(IPackageFragment deletedFragment) {
        IResource rootFolder = deletedFragment.getParent().getResource();
        if (rootFolder == null) {
            return;
        }
        IPath rootPath = rootFolder.getProjectRelativePath();
        String nextPakkageName = deletedFragment.getElementName();
        int lastDot = nextPakkageName.lastIndexOf(46);
        while (lastDot > 0) {
            nextPakkageName = nextPakkageName.substring(0, lastDot);
            lastDot = nextPakkageName.lastIndexOf(46);
            if (PackageFragmentRootListener.existsInSourceRoot(this.myCurrentProject, null, nextPakkageName)) break;
            ProjectRelativePath nextPackagePath = ProjectRelativePath.valueOf((IPath)rootPath.append(nextPakkageName.replace('.', '/')));
            DesignRootAccess.getInstance((IProject)this.myCurrentProject.getProject()).getJavaPackageSynchronizer().handleJavaPackageDeletion((IProjectRelativePath)nextPackagePath);
        }
    }

    private static boolean existsInSourceRoot(IJavaProject javaProject, IPackageFragmentRoot excludedRoot, String pakkageName) {
        IPackageFragmentRoot[] fragmentRoots;
        if (javaProject == null) {
            return false;
        }
        try {
            fragmentRoots = javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException rootsNotAvailable) {
            rootsNotAvailable.printStackTrace();
            return true;
        }
        int i = 0;
        while (i < fragmentRoots.length) {
            block10: {
                if (!fragmentRoots[i].equals(excludedRoot)) {
                    block9: {
                        try {
                            if (fragmentRoots[i].getKind() != 1) {
                            }
                            break block9;
                        }
                        catch (JavaModelException canNotResolveType) {
                            canNotResolveType.printStackTrace();
                        }
                        break block10;
                    }
                    IPackageFragment pakkage = fragmentRoots[i].getPackageFragment(pakkageName);
                    if (pakkage != null && pakkage.exists()) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isLastPackageFragmentRemoved(IPackageFragment removed) {
        String pakkageName;
        if (this.myCurrentProject == null) {
            return false;
        }
        IPackageFragmentRoot excludedRoot = (IPackageFragmentRoot)removed.getParent();
        return !PackageFragmentRootListener.existsInSourceRoot(this.myCurrentProject, excludedRoot, pakkageName = removed.getElementName());
    }

    private void addProjectToReload(IJavaProject project) {
        this.myProjectsToReload.add(project);
    }

    private static boolean testDeltaFlag(IJavaElementDelta delta, int flag) {
        return (delta.getFlags() & flag) > 0;
    }

    private boolean isRootRemoved(IJavaElementDelta delta) {
        return delta.getKind() == 2 || PackageFragmentRootListener.testDeltaFlag(delta, 128);
    }

    private boolean isRootAdded(IJavaElementDelta delta) {
        return delta.getKind() == 1 || PackageFragmentRootListener.testDeltaFlag(delta, 64);
    }

    private void fireReloadRoots() {
        if (!this.myProjectsToReload.isEmpty()) {
            Iterator it = this.myProjectsToReload.iterator();
            while (it.hasNext()) {
                IJavaProject next = (IJavaProject)it.next();
                final IProject project = next.getProject();
                ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

                    public void run() {
                        if (project.isAccessible()) {
                            RootManagerAccess.getRootManager((IProject)project).reloadAllRoots();
                        }
                    }
                });
            }
            this.myProjectsToReload.clear();
        }
    }

    private static Map createStringsSubstitutionMap(IPackageFragment oldPackage, IPackageFragment newPackage) {
        return OldUniqueNameUtil.createSubstitutionMapOnPackageRenaming(oldPackage, newPackage);
    }
}

