/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class NameUtil {
    protected static final String JDT_DOMAIN = "jdt";
    protected static final String JDT_ELEMENT_PREFIX = "e_";
    protected static final String JDT_LINK_PREFIX = "l_";
    protected static final String ROOT = "root";
    protected static final String PACKAGE = "package";
    protected static final String JAR_PACKAGE = "jar_package";
    protected static final String REF_PACKAGE = "ref_package";
    protected static final String TYPE = "class";
    protected static final String METHOD = "method";
    protected static final String FIELD = "field";
    protected static final String ASSOCIATION = "ast";
    protected static final String DEPENDENCY = "dpn";
    protected static final String GENERALIZATION = "gnt";
    protected static final String IMPLEMENTATION = "impl";
    private static final String E_ROOT_SUB_DOMAIN = "e_root";
    private static final String E_JAR_PACKAGE_SUB_DOMAIN = "e_jar_package";
    private static final String E_REF_PACKAGE_SUB_DOMAIN = "e_ref_package";
    private static final String E_TYPE_SUB_DOMAIN = "e_class";
    private static final String E_METHOD_SUB_DOMAIN = "e_method";
    private static final String E_FIELD_SUB_DOMAIN = "e_field";
    protected static final String E_ASSOCIATION_SUB_DOMAIN = "l_ast";
    protected static final String E_DEPENDENCY_SUB_DOMAIN = "l_dpn";
    protected static final String E_GENERALIZATION_SUB_DOMAIN = "l_gnt";
    protected static final String E_IMPLEMENTATION_SUB_DOMAIN = "l_impl";
    static final String SIGNATURE_SEPARATOR = "~";
    public static final String INNER_CLASS_STRING = "$";
    public static final char INNER_CLASS_CHARSTER = '$';
    private static final String EMPTY_LOCATION = null;
    static final String[] EMPTY_PARAMETERS = new String[0];
    public static final String JAVA_FILE_EXTENSION = ".java";
    static final UniqueName BIN_ROOT_UNIQUE_NAME = NameUtil.getRootUniqueName("bin");
    static final UniqueName REF_ROOT_UNIQUE_NAME = NameUtil.getRootUniqueName("ref");

    public static UniqueName getParentUniqueName(UniqueName modelUniqueName, UniqueName uniqueName) {
        if (!NameUtil.isJavaUniqueName(uniqueName)) {
            return null;
        }
        String parentLocation = uniqueName.getLocation();
        if (NameUtil.isJavaElementUniqueName(uniqueName, false)) {
            String qualifiedName = uniqueName.getName();
            if (NameUtil.isTypeUniqueName(uniqueName)) {
                if (NameUtil.isInnerElement(uniqueName)) {
                    String parentQualifiedName = NameUtil.getFirstPart(qualifiedName, true);
                    return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)parentLocation, (String)parentQualifiedName, (String[])EMPTY_PARAMETERS);
                }
                String location = uniqueName.getLocation();
                String parentQualifiedName = NameUtil.getFirstPart(qualifiedName, false);
                if ("bin".equals(location)) {
                    if (parentQualifiedName != null) {
                        return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_JAR_PACKAGE_SUB_DOMAIN, (String)parentLocation, (String)parentQualifiedName, (String[])EMPTY_PARAMETERS);
                    }
                    return BIN_ROOT_UNIQUE_NAME;
                }
                if ("ref".equals(location)) {
                    if (parentQualifiedName != null) {
                        return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_REF_PACKAGE_SUB_DOMAIN, (String)parentLocation, (String)parentQualifiedName, (String[])EMPTY_PARAMETERS);
                    }
                    return REF_ROOT_UNIQUE_NAME;
                }
                IProject project = ModelUinSupport.getProject((UniqueName)modelUniqueName);
                IRootRelativePath path = NameUtil.getPathFromQualifiedName(parentQualifiedName);
                return RootManagerAccess.getRootManager((IProject)project).getUniqueName(path);
            }
            if (NameUtil.isMethodUniqueName(uniqueName)) {
                String parentQualifiedName = NameUtil.getFirstPart(qualifiedName, false);
                return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)parentLocation, (String)parentQualifiedName, (String[])EMPTY_PARAMETERS);
            }
            if (NameUtil.isFieldUniqueName(uniqueName)) {
                String parentQualifiedName = NameUtil.getFirstPart(qualifiedName, false);
                return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)parentLocation, (String)parentQualifiedName, (String[])EMPTY_PARAMETERS);
            }
            if (NameUtil.isRootUniqueName(uniqueName)) {
                return modelUniqueName;
            }
            if (NameUtil.isJarPackageUniqueName(uniqueName)) {
                String parentQualifiedName = NameUtil.getFirstPart(qualifiedName, false);
                if (parentQualifiedName == null) {
                    return BIN_ROOT_UNIQUE_NAME;
                }
                return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_JAR_PACKAGE_SUB_DOMAIN, (String)parentLocation, (String)parentQualifiedName, (String[])EMPTY_PARAMETERS);
            }
            if (NameUtil.isRefPackageUniqueName(uniqueName)) {
                String parentQualifiedName = NameUtil.getFirstPart(qualifiedName, false);
                if (parentQualifiedName == null) {
                    return REF_ROOT_UNIQUE_NAME;
                }
                return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_REF_PACKAGE_SUB_DOMAIN, (String)parentLocation, (String)parentQualifiedName, (String[])EMPTY_PARAMETERS);
            }
        } else if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            if (NameUtil.isAssociationUniqueName(uniqueName)) {
                return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)parentLocation, (String)uniqueName.getName(), (String[])EMPTY_PARAMETERS);
            }
            if (NameUtil.isGeneralizationUniqueName(uniqueName) || NameUtil.isImplementationUniqueName(uniqueName)) {
                return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)parentLocation, (String)uniqueName.getName(), (String[])EMPTY_PARAMETERS);
            }
            if (NameUtil.isDependencyUniqueName(uniqueName)) {
                return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)parentLocation, (String)uniqueName.getName(), (String[])EMPTY_PARAMETERS);
            }
        }
        return null;
    }

    public static UniqueName getJavaElementUniqueName(IJavaProject javaProject, IJavaElement javaElement) {
        String rootLocation = NameUtil.getRootLocation(javaProject, javaElement);
        return NameUtil.getJavaElementUniqueName(javaElement, rootLocation);
    }

    public static UniqueName getRenamedUniqueName(UniqueName oldUin, String newName) {
        Assert.isLegal((boolean)NameUtil.isJavaUniqueName(oldUin));
        String curQualifiedName = oldUin.getName();
        int afterLastDot = curQualifiedName.lastIndexOf(".") + 1;
        String newQuailfiedName = curQualifiedName.substring(0, afterLastDot) + newName;
        String location = oldUin.getLocation();
        String prefix = oldUin.getSubDomain();
        LinkedList<String> parameters = new LinkedList<String>();
        if (NameUtil.isMethodUniqueName(oldUin)) {
            int length = curQualifiedName.length() - afterLastDot;
            String oldParameter = oldUin.getParameter(0);
            oldParameter = newName + oldParameter.substring(length);
            parameters.add(oldParameter);
        } else {
            int i = 0;
            while (i < oldUin.getParametersCount()) {
                parameters.add(oldUin.getParameter(i));
                ++i;
            }
        }
        return NameUtil.getUniqueName(location, newQuailfiedName, prefix, parameters.toArray(new String[parameters.size()]));
    }

    public static UniqueName getJavaElementUniqueName(IJavaElement javaElement, String rootLocation) {
        int elementType = javaElement.getElementType();
        if (elementType == 7) {
            return NameUtil.getTypeUniqueName((IType)javaElement, rootLocation);
        }
        if (elementType == 9) {
            return NameUtil.getMethodUniqueName((IMethod)javaElement, rootLocation);
        }
        if (elementType == 8) {
            return NameUtil.getFieldUniqueName((IField)javaElement, rootLocation);
        }
        if (elementType == 4) {
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            if ("src".equals(rootLocation)) {
                return NameUtil.getPackageUniqueName(packageFragment);
            }
            if ("bin".equals(rootLocation)) {
                return NameUtil.getJarPackageUniqueName(packageFragment);
            }
            return NameUtil.getRefPackageUniqueName(packageFragment);
        }
        if (elementType == 2) {
            return ModelUinSupport.createModelUin((String)javaElement.getElementName());
        }
        return null;
    }

    public static boolean isJavaUniqueName(UniqueName uniqueName) {
        return uniqueName != null && JDT_DOMAIN.equals(uniqueName.getDomain());
    }

    public static boolean isJavaElementUniqueName(UniqueName uniqueName, boolean clipboard) {
        if (uniqueName != null && uniqueName.getSubDomain() != null && uniqueName.getSubDomain().startsWith(JDT_ELEMENT_PREFIX)) {
            if (clipboard) {
                return uniqueName instanceof CopyUniqueName;
            }
            return !(uniqueName instanceof CopyUniqueName);
        }
        return false;
    }

    public static boolean isJavaLinkElementUniqueName(UniqueName uniqueName, boolean clipboard) {
        if (uniqueName != null && uniqueName.getSubDomain() != null && uniqueName.getSubDomain().startsWith(JDT_LINK_PREFIX)) {
            if (clipboard) {
                return uniqueName instanceof CopyUniqueName;
            }
            return !(uniqueName instanceof CopyUniqueName);
        }
        return false;
    }

    public static boolean isMemberUniqueName(UniqueName uniqueName) {
        return uniqueName != null && (E_FIELD_SUB_DOMAIN.equals(uniqueName.getSubDomain()) || E_METHOD_SUB_DOMAIN.equals(uniqueName.getSubDomain()));
    }

    public static boolean isInnerElement(UniqueName uniqueName) {
        return uniqueName != null && uniqueName.getName() != null && uniqueName.getName().indexOf(36) != -1;
    }

    public static boolean isInnerClass(UniqueName uniqueName) {
        return NameUtil.isInnerElement(uniqueName) && NameUtil.isTypeUniqueName(uniqueName);
    }

    public static String getRootLocation(IJavaProject javaProject, IJavaElement javaElement) {
        if (!javaProject.getElementName().equals(javaElement.getJavaProject().getElementName())) {
            return "ref";
        }
        try {
            switch (javaElement.getElementType()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    IMember member = (IMember)javaElement;
                    return member.getClassFile() == null ? "src" : "bin";
                }
                case 4: {
                    if (!javaElement.exists()) {
                        return "src";
                    }
                    return javaElement.getCorrespondingResource() != null ? "src" : "bin";
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public static int getRootKind(String location) {
        if ("src".equals(location)) {
            return 1;
        }
        if ("bin".equals(location)) {
            return 2;
        }
        return 3;
    }

    public static boolean isRootUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_ROOT_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getRootUniqueName(String qualifiedName) {
        return NameUtil.getUniqueName(qualifiedName, qualifiedName, E_ROOT_SUB_DOMAIN, EMPTY_PARAMETERS);
    }

    public static boolean isPackageUniqueName(UniqueName uniqueName) {
        return RootManagerAccess.isResourceUin((UniqueName)uniqueName);
    }

    public static UniqueName getPackageUniqueName(IPackageFragment packageFragment) {
        String path = packageFragment.getElementName();
        path = path.replace('.', '/');
        RootRelativePath rootRelativePath = RootRelativePath.valueOf((String)path);
        IProject project = packageFragment.getJavaProject().getProject();
        return RootManagerAccess.getRootManager((IProject)project).getUniqueName((IRootRelativePath)rootRelativePath);
    }

    public static String getPackageQualifiedName(UniqueName modelUniqueName, UniqueName uniqueName) {
        IProject project = ModelUinSupport.getProject((UniqueName)modelUniqueName);
        if (uniqueName.equals(modelUniqueName)) {
            return "";
        }
        IRootRelativePath path = RootManagerAccess.getRootManager((IProject)project).extractRootRelativePath(uniqueName);
        return NameUtil.getPackageQualifiedName((IPath)path);
    }

    public static String getPackageQualifiedName(IPath path) {
        String spath = path.toString();
        spath = spath.replace('\\', '.');
        spath = spath.replace('/', '.');
        return spath;
    }

    public static UniqueName getSourcePackageUniqueName(Model model, String qualifiedName) {
        IRootRelativePath path = NameUtil.getPathFromQualifiedName(qualifiedName);
        return RootManagerAccess.getRootManager((IProject)ModelUinSupport.getProject((UniqueName)model.getUniqueName())).getUniqueName(path);
    }

    static IRootRelativePath getPathFromQualifiedName(String qualifiedName) {
        qualifiedName = qualifiedName == null ? "" : qualifiedName.replace('.', '/');
        return RootRelativePath.valueOf((String)qualifiedName);
    }

    public static UniqueName getRefPackageUniqueName(IPackageFragment packageFragment) {
        String fullName = packageFragment.getElementName();
        if (fullName.length() > 0) {
            return NameUtil.getUniqueName("ref", fullName, E_REF_PACKAGE_SUB_DOMAIN, EMPTY_PARAMETERS);
        }
        return REF_ROOT_UNIQUE_NAME;
    }

    public static boolean isRefUniqueName(UniqueName uniqueName) {
        return "ref".equals(uniqueName.getLocation());
    }

    public static boolean isRefRootUniqueName(UniqueName uniqueName) {
        return NameUtil.isRootUniqueName(uniqueName) && "ref".equals(uniqueName.getLocation());
    }

    public static boolean isRefPackageUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_REF_PACKAGE_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getJarPackageUniqueName(IPackageFragment packageFragment) {
        String fullName = packageFragment.getElementName();
        if (fullName.length() > 0) {
            return NameUtil.getUniqueName("bin", fullName, E_JAR_PACKAGE_SUB_DOMAIN, EMPTY_PARAMETERS);
        }
        return BIN_ROOT_UNIQUE_NAME;
    }

    public static String getExtPackageQualifiedName(UniqueName uniqueName) {
        if (NameUtil.isJarPackageUniqueName(uniqueName) || NameUtil.isRefPackageUniqueName(uniqueName)) {
            return uniqueName.getName();
        }
        if (NameUtil.isJarRootUniqueName(uniqueName) || NameUtil.isRefRootUniqueName(uniqueName)) {
            return "";
        }
        return null;
    }

    public static boolean isJarRootUniqueName(UniqueName uniqueName) {
        return NameUtil.isRootUniqueName(uniqueName) && "bin".equals(uniqueName.getLocation());
    }

    public static boolean isJarPackageUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_JAR_PACKAGE_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static String getPackageQualifiedName(IPackageFragment packageFragment) {
        return packageFragment.getElementName();
    }

    public static String getPackageShortName(String name) {
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex != -1) {
            return name.substring(dotIndex + 1);
        }
        return name;
    }

    public static UniqueName getOldMemberUniqueName(UniqueName oldTypeUniqueName, UniqueName newTypeUniqueName, IMember newMember) {
        String oldLocation = oldTypeUniqueName.getLocation();
        String newTypeName = newTypeUniqueName.getName();
        String newShortTypeName = NameUtil.getShortName(newTypeName);
        String oldTypeName = oldTypeUniqueName.getName();
        String oldShortTypeName = NameUtil.getShortName(oldTypeName);
        UniqueName uniqueName = NameUtil.getJavaElementUniqueName((IJavaElement)newMember, oldLocation);
        String name = uniqueName.toString();
        int index = name.indexOf(":" + newTypeName);
        if (index != -1) {
            name = name.substring(0, ++index) + oldTypeName + name.substring(index + newTypeName.length());
            String unresolvedNewTypeSignature = SIGNATURE_SEPARATOR + Signature.createTypeSignature((String)newShortTypeName, (boolean)false);
            String unresolvedOldTypeSignature = SIGNATURE_SEPARATOR + Signature.createTypeSignature((String)oldShortTypeName, (boolean)false);
            int oldIndex = -1;
            while ((index = name.indexOf(unresolvedNewTypeSignature)) != -1 && index != oldIndex) {
                name = name.substring(0, index) + unresolvedOldTypeSignature + name.substring(index + unresolvedNewTypeSignature.length());
                oldIndex = index;
            }
            String resolvedNewTypeSignature = "." + newShortTypeName + ";";
            String resolvedOldTypeSignature = "." + oldShortTypeName + ";";
            oldIndex = -1;
            while ((index = name.indexOf(resolvedNewTypeSignature)) != -1 && index != oldIndex) {
                name = name.substring(0, index) + resolvedOldTypeSignature + name.substring(index + resolvedNewTypeSignature.length());
                oldIndex = index;
            }
            return ModelAccess.createUniqueName((String)name);
        }
        return null;
    }

    public static UniqueName getTypeUniqueName(IJavaProject javaProject, IType type) {
        String rootLocation = NameUtil.getRootLocation(javaProject, (IJavaElement)type);
        return NameUtil.getTypeUniqueName(type, rootLocation);
    }

    private static UniqueName getTypeUniqueName(IType type, String rootLocation) {
        return NameUtil.getUniqueName(rootLocation, NameUtil.getTypeQualifiedName(type), E_TYPE_SUB_DOMAIN, EMPTY_PARAMETERS);
    }

    public static UniqueName getResolvedTypeUniqueName(Model model, String qualifiedName) {
        UniqueName uniqueName = NameUtil.getTypeUniqueName("src", qualifiedName);
        if (model.findEntity(uniqueName) != null) {
            return uniqueName;
        }
        return NameUtil.getTypeUniqueName("bin", qualifiedName);
    }

    public static UniqueName getTypeUniqueName(String rootLocation, String qualifiedName) {
        return NameUtil.getUniqueName(rootLocation, qualifiedName, E_TYPE_SUB_DOMAIN, EMPTY_PARAMETERS);
    }

    public static String getTypeQualifiedName(IType type) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        if (fullyQualifiedName.indexOf(INNER_CLASS_STRING) != -1 && type.getParent().getElementType() == 5) {
            fullyQualifiedName = NameUtil.fixupTypeNameForUIN(fullyQualifiedName);
        }
        return fullyQualifiedName;
    }

    public static String fixupTypeNameForUIN(String qualifiedName) {
        return qualifiedName.replace('$', '#');
    }

    public static String fixupTypeNameForJDT(String qualifiedName) {
        return qualifiedName.replace('#', '$');
    }

    public static String getTypeQualifiedName(UniqueName uniqueName) {
        if (NameUtil.isTypeUniqueName(uniqueName)) {
            String name = uniqueName.getName();
            return NameUtil.fixupTypeNameForJDT(name);
        }
        return null;
    }

    public static String getTypeShortName(IType type, String typeName) {
        boolean keepFullName = NameUtil.keepFullName(type, typeName);
        return keepFullName ? typeName : NameUtil.innerGetTypeShortName(type, typeName);
    }

    private static boolean keepFullName(IType type, String typeName) {
        if (typeName != null) {
            String tName = type.getElementName();
            String sName = NameUtil.innerGetTypeShortName(type, typeName);
            IType someInnerType = type.getType(sName.replace('.', '$'));
            return tName.equals(sName) || someInnerType != null && someInnerType.exists();
        }
        return false;
    }

    private static String innerGetTypeShortName(IType type, String typeName) {
        if (typeName.indexOf(46) == -1) {
            return typeName;
        }
        typeName = typeName.replace('$', '.');
        try {
            String[][] resolvedNames;
            String packageName = type.getPackageFragment().getElementName();
            if (!typeName.startsWith(packageName)) {
                typeName = packageName + "." + typeName;
            }
            if ((resolvedNames = type.resolveType(typeName)) != null) {
                return resolvedNames[0][1];
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return NameUtil.getSecondPart(typeName, false);
    }

    public static String normalizeName(String typeName) {
        return typeName == null ? null : typeName.replace('$', '.');
    }

    public static boolean isTypeUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_TYPE_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getFieldUniqueName(IJavaProject javaProject, IField field) {
        String rootLocation = NameUtil.getRootLocation(javaProject, (IJavaElement)field);
        return NameUtil.getFieldUniqueName(field, rootLocation);
    }

    private static UniqueName getFieldUniqueName(IField field, String rootLocation) {
        return NameUtil.getFieldUniqueName(rootLocation, NameUtil.getFieldQualifiedName(field));
    }

    public static UniqueName getFieldUniqueName(String rootLocation, String qualifiedName) {
        return NameUtil.getUniqueName(rootLocation, qualifiedName, E_FIELD_SUB_DOMAIN, EMPTY_PARAMETERS);
    }

    public static String getFieldQualifiedName(IField field) {
        if (field == null) {
            return null;
        }
        String typeFullName = field.getDeclaringType().getFullyQualifiedName();
        return typeFullName + "." + field.getElementName();
    }

    public static String getFieldQualifiedName(UniqueName uniqueName) {
        if (NameUtil.isFieldUniqueName(uniqueName)) {
            return uniqueName.getName();
        }
        return null;
    }

    public static boolean isFieldUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_FIELD_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getMethodUniqueName(IJavaProject javaProject, IMethod method) {
        String rootLocation = NameUtil.getRootLocation(javaProject, (IJavaElement)method);
        return NameUtil.getMethodUniqueName(method, rootLocation);
    }

    private static UniqueName getMethodUniqueName(IMethod method, String rootLocation) {
        String[] pair = NameUtil.getMethodQualifiedName(method);
        if (pair == null) {
            return null;
        }
        if (pair[1] == null) {
            System.out.println("Method " + method.getHandleIdentifier() + " had a failing UniqueName, corrected");
            pair[1] = "";
        }
        return NameUtil.getUniqueName(rootLocation, pair[0], E_METHOD_SUB_DOMAIN, new String[]{pair[1]});
    }

    public static String[] getMethodQualifiedName(IMethod method) {
        String methodFullName;
        if (method == null) {
            return null;
        }
        String[] pair = new String[2];
        String typeFullName = method.getDeclaringType().getFullyQualifiedName();
        String handleIdentifier = method.getHandleIdentifier();
        handleIdentifier = NameUtil.getHandleIdentifierPart(handleIdentifier);
        pair[0] = methodFullName = typeFullName + "." + method.getElementName();
        pair[1] = handleIdentifier;
        return pair;
    }

    public static String getHandleIdentifierPart(String handleIdentifier) {
        int index = handleIdentifier.indexOf(SIGNATURE_SEPARATOR);
        if (index == -1) {
            return null;
        }
        return handleIdentifier.substring(index + 1);
    }

    public static String getMethodQualifiedName(UniqueName uniqueName) {
        if (NameUtil.isMethodUniqueName(uniqueName)) {
            return uniqueName.getName();
        }
        return null;
    }

    public static boolean isMethodUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_METHOD_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getDependencyNodeUniqueName(IType type, String name) {
        return NameUtil.getUniqueName("src", NameUtil.getTypeQualifiedName(type), E_DEPENDENCY_SUB_DOMAIN, new String[]{name});
    }

    public static boolean isDependencyUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_DEPENDENCY_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getAssociationNodeUniqueName(IJavaProject javaProject, IField field) {
        String rootLocation = NameUtil.getRootLocation(javaProject, (IJavaElement)field);
        return NameUtil.getAssociationNodeUniqueName(field, rootLocation);
    }

    public static String getFNFromDUIN(UniqueName uniqueName) {
        if (NameUtil.isDependencyUniqueName(uniqueName)) {
            return uniqueName.getParameter(0);
        }
        return null;
    }

    public static UniqueName getTUINFromDUIN(UniqueName uniqueName) {
        if (NameUtil.isDependencyUniqueName(uniqueName)) {
            String rootLocation = uniqueName.getLocation();
            return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)rootLocation, (String)uniqueName.getName(), (String[])EMPTY_PARAMETERS);
        }
        return null;
    }

    private static UniqueName getAssociationNodeUniqueName(IField field, String rootLocation) {
        return NameUtil.getUniqueName(rootLocation, NameUtil.getTypeQualifiedName(field.getDeclaringType()), E_ASSOCIATION_SUB_DOMAIN, new String[]{field.getElementName()});
    }

    public static boolean isAssociationUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_ASSOCIATION_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getFUINFromAUIN(UniqueName uniqueName) {
        if (NameUtil.isAssociationUniqueName(uniqueName)) {
            String rootLocation = uniqueName.getLocation();
            if (uniqueName instanceof CopyUniqueName) {
                return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_FIELD_SUB_DOMAIN, (String)rootLocation, (String)(uniqueName.getName() + "." + uniqueName.getParameter(1)), (String[])EMPTY_PARAMETERS);
            }
            return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_FIELD_SUB_DOMAIN, (String)rootLocation, (String)(uniqueName.getName() + "." + uniqueName.getParameter(0)), (String[])EMPTY_PARAMETERS);
        }
        return null;
    }

    public static UniqueName getGeneralizationNodeUniqueName(IJavaProject javaProject, IType type, String extendsType) {
        String rootLocation = NameUtil.getRootLocation(javaProject, (IJavaElement)type);
        return NameUtil.getGeneralizationNodeUniqueName(type, rootLocation, extendsType);
    }

    private static UniqueName getGeneralizationNodeUniqueName(IType type, String rootLocation, String extendsType) {
        return NameUtil.getUniqueName(rootLocation, NameUtil.getTypeQualifiedName(type), E_GENERALIZATION_SUB_DOMAIN, new String[]{extendsType});
    }

    public static boolean isGeneralizationUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_GENERALIZATION_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getTUINFromGUIN(UniqueName uniqueName) {
        if (NameUtil.isGeneralizationUniqueName(uniqueName)) {
            String rootLocation = uniqueName.getLocation();
            return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)rootLocation, (String)uniqueName.getName(), (String[])EMPTY_PARAMETERS);
        }
        return null;
    }

    public static UniqueName getImplementaionNodeUniqueName(IJavaProject javaProject, IType type, String implementsType) {
        String rootLocation = NameUtil.getRootLocation(javaProject, (IJavaElement)type);
        return NameUtil.getImplementaionNodeUniqueName(type, rootLocation, implementsType);
    }

    private static UniqueName getImplementaionNodeUniqueName(IType type, String rootLocation, String implementsType) {
        return NameUtil.getUniqueName(rootLocation, NameUtil.getTypeQualifiedName(type), E_IMPLEMENTATION_SUB_DOMAIN, new String[]{implementsType});
    }

    public static boolean isImplementationUniqueName(UniqueName uniqueName) {
        return uniqueName != null && E_IMPLEMENTATION_SUB_DOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getTUINFromIUIN(UniqueName uniqueName) {
        if (NameUtil.isImplementationUniqueName(uniqueName)) {
            String rootLocation = uniqueName.getLocation();
            return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)E_TYPE_SUB_DOMAIN, (String)rootLocation, (String)uniqueName.getName(), (String[])EMPTY_PARAMETERS);
        }
        return null;
    }

    public static String getRefTNFromLinkUIN(UniqueName uniqueName) {
        if (uniqueName instanceof CopyUniqueName) {
            return uniqueName.getParameter(1);
        }
        return uniqueName.getParameter(0);
    }

    private static UniqueName getUniqueName(String location, String qualifiedName, String uniqueNamePrefix, String[] params) {
        return ModelAccess.createUniqueName((String)JDT_DOMAIN, (String)uniqueNamePrefix, (String)location, (String)qualifiedName, (String[])params);
    }

    public static String getFirstPart(String name, boolean innerClass) {
        int dotIndex;
        if (name != null && name.length() > 0 && (dotIndex = innerClass ? name.lastIndexOf(36) : name.lastIndexOf(".")) != -1) {
            return name.substring(0, dotIndex);
        }
        return null;
    }

    public static String getSecondPart(String name, boolean innerClass) {
        if (name != null && name.length() > 0) {
            int dotIndex = innerClass ? name.lastIndexOf(36) : name.lastIndexOf(".");
            if (dotIndex != -1) {
                return name.substring(dotIndex + 1);
            }
            return name;
        }
        return null;
    }

    public static String getShortName(String fullName) {
        if (fullName != null && fullName.length() > 0) {
            int dotIndex = fullName.lastIndexOf(36);
            if (dotIndex != -1) {
                return fullName.substring(dotIndex + 1);
            }
            dotIndex = fullName.lastIndexOf(".");
            if (dotIndex != -1) {
                fullName = fullName.substring(dotIndex + 1);
            }
            fullName = NameUtil.fixupTypeNameForJDT(fullName);
            return fullName;
        }
        return null;
    }

    static UniqueName getModelUniqueNameByJavaElement(IJavaElement javaElement) {
        String name = javaElement.getJavaProject().getElementName();
        return ModelUinSupport.createModelUin((String)name);
    }
}

