/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.CodeUtil;
import com.tssap.selena.internal.core.providers.java.DefaultNameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;

final class MethodCreateParam {
    public static final int ABSTRACT_METHOD_MODIFIERS_ONLY = 2362;
    private String myComment = "";
    private int myModifiers = 1;
    private String myReturnType = "void";
    private String myMethodName = DefaultNameUtil.getDefaultMethodName();
    private String[][] myParameters = null;
    private String mySignature = "()V";
    private static final String[] METHOD_MODIFIERS = new String[]{"$public", "$private", "$protected", "$package_local", "$abstract", "$static", "$final", "$strictfp", "$native", "$synchronized"};
    private static final int[] METHOD_MODIFIER_VALUES = new int[]{1, 2, 4, 0, 1024, 8, 16, 2048, 256, 32};

    public static MethodCreateParam createFrom(Entity template) {
        String[][] params;
        MethodCreateParam rv = new MethodCreateParam();
        if (template.hasProperty("$comment")) {
            rv.setComment(template.getPropertyValue("$comment"));
        }
        if (MethodCreateParam.hasModifiers(template)) {
            rv.setModifiers(MethodCreateParam.getModifiers(template));
        }
        if (template.hasProperty("$returnType")) {
            rv.setReturnType(template.getPropertyValue("$returnType"));
        }
        if (template.hasProperty("$name")) {
            rv.setMethodName(template.getPropertyValue("$name"));
        }
        if ((params = MethodCreateParam.getParameters(template)).length > 0) {
            rv.setParameters(params);
        }
        return rv;
    }

    public void fillDelcaration(StringBuffer sb, int modifiersMask) {
        String comment = this.getComment();
        if (comment != null && comment.length() > 0) {
            String c = comment.trim();
            if (!c.startsWith("/**") || !c.endsWith("*/")) {
                sb.append("/**");
                sb.append(comment);
                sb.append("*/");
            } else {
                sb.append(comment);
            }
        }
        sb.append(Flags.toString((int)(this.getModifiers() & ~modifiersMask)));
        sb.append(' ');
        sb.append(this.getReturnType());
        sb.append(' ');
        sb.append(this.getMethodName());
        sb.append('(');
        sb.append(CodeUtil.getParametersString(this.getParameters()));
        sb.append(')');
    }

    public String getComment() {
        return this.myComment;
    }

    public void setComment(String comment) {
        this.myComment = comment;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public void setModifiers(int modifiers) {
        this.myModifiers = modifiers;
    }

    public boolean hasParameters() {
        return this.myParameters != null && this.myParameters.length > 0;
    }

    public String[][] getParameters() {
        if (this.myParameters == null) {
            return new String[0][0];
        }
        return this.myParameters;
    }

    public void setParameters(String[][] parameters) {
        this.myParameters = parameters;
        this.mySignature = null;
    }

    public String getReturnType() {
        return this.myReturnType;
    }

    public void setReturnType(String returnType) {
        this.myReturnType = returnType;
    }

    public String getSignature() {
        if (this.mySignature == null) {
            this.mySignature = this.createSignature();
        }
        return this.mySignature;
    }

    private String createSignature() {
        String[] parametersTypes;
        if (this.hasParameters()) {
            parametersTypes = new String[this.myParameters[0].length];
            int i = 0;
            while (i < parametersTypes.length) {
                String parameter = this.myParameters[0][i];
                int index = parameter.indexOf(" ");
                parametersTypes[i] = index == -1 ? parameter : parameter.substring(0, index);
                ++i;
            }
        } else {
            parametersTypes = new String[]{};
        }
        return Signature.createMethodSignature((String[])parametersTypes, (String)this.getReturnType());
    }

    public static String[][] getParameters(Entity template) {
        PropertyEnumeration propertyEnumeration = template == null ? EmptyEnumeration.getPropertyEnumeration() : template.properties("$parameter");
        ArrayList<String> list = new ArrayList<String>();
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            list.add(property.getValue());
        }
        String[][] parameters = new String[2][list.size()];
        int i = 0;
        while (i < list.size()) {
            String parameter = (String)list.get(i);
            int index = parameter.indexOf(" ");
            if (index == -1) {
                return new String[0][0];
            }
            parameters[0][i] = parameter.substring(0, index).trim();
            parameters[1][i] = parameter.substring(index + 1).trim();
            ++i;
        }
        return parameters;
    }

    private static boolean hasModifiers(Entity template) {
        int i = 0;
        while (i < METHOD_MODIFIERS.length) {
            if (template.hasProperty(METHOD_MODIFIERS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int getModifiers(Entity template) {
        int flags = 0;
        int i = 0;
        while (i < METHOD_MODIFIERS.length) {
            if (template.hasProperty(METHOD_MODIFIERS[i])) {
                flags |= METHOD_MODIFIER_VALUES[i];
            }
            ++i;
        }
        return flags;
    }
}

