/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.CodeUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.Messages;
import com.tssap.selena.internal.core.providers.java.SignatureUtil;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

public class MethodBodyUtil {
    private static final String COMMENTED = Messages.getString("commented");

    public static void fixupMethodBody(IDOMMethod domMethod, boolean emptyBody) {
        if (!emptyBody) {
            String body = domMethod.getBody();
            if (MethodBodyUtil.isEmptyBody(body)) {
                String typeName = domMethod.getReturnType();
                domMethod.setBody(MethodBodyUtil.arrangeBody(CodeUtil.getDefaultReturn(typeName, false)));
            }
        } else {
            domMethod.setBody(null);
        }
    }

    public static void fixupMethodBody(IMethod method, IDOMMethod domMethod, String newReturnType) {
        try {
            int flags;
            String oldReturnType = domMethod.getReturnType();
            domMethod.setReturnType(newReturnType);
            ImportStatementSupport.deleteImportStatament((IJavaElement)method.getDeclaringType(), (IDOMNode)domMethod, oldReturnType);
            if (method.getDeclaringType().isClass() && !Flags.isAbstract((int)(flags = method.getFlags())) && !Flags.isNative((int)flags)) {
                String oldBody = domMethod.getBody();
                oldBody = MethodBodyUtil.clearBody(oldBody);
                oldBody = MethodBodyUtil.commentBody(oldBody);
                String newBody = MethodBodyUtil.arrangeBody(CodeUtil.getDefaultReturn(newReturnType, false) + JavaProviderPlugin.EOL + oldBody);
                domMethod.setBody(newBody);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    public static String fixupMethodBody(String methodContent, boolean emptyBody) {
        IDOMMethod domMethod = new DOMFactory().createMethod(methodContent);
        if (domMethod == null) {
            return methodContent;
        }
        MethodBodyUtil.fixupMethodBody(domMethod, emptyBody);
        return domMethod.getContents() + (domMethod.getBody() == null ? JavaProviderPlugin.EOL : "");
    }

    public static String fixupMethodParameters(IType type, String methodContent, String signature) {
        try {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                if (method.isConstructor() && method.getSignature().equals(signature)) {
                    String[][] parameters = MethodBodyUtil.getFixedParameter(method);
                    IDOMMethod domMethod = new DOMFactory().createMethod(methodContent);
                    if (domMethod != null) {
                        domMethod.setParameters(parameters[0], parameters[1]);
                        return domMethod.getContents();
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return methodContent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEmptyBody(IDOMMethod domMethod, IMethod jdtMethod) {
        try {
            IDOMNode domNode = domMethod.getParent();
            if (domNode instanceof IDOMType) {
                IDOMType domType = (IDOMType)domNode;
                if (!domType.isClass()) return true;
                int flag = domMethod.getFlags();
                if (!Flags.isAbstract((int)flag) && !Flags.isNative((int)flag)) return false;
                return true;
            } else {
                IType type = jdtMethod.getDeclaringType();
                if (!type.isInterface()) return false;
                return true;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return false;
    }

    private static String[][] getFixedParameter(IMethod method) {
        try {
            String[] parameterNames;
            String name = method.getElementName();
            IType type = method.getDeclaringType();
            String[] parameterTypes = method.getParameterTypes();
            if (parameterTypes == null) {
                parameterTypes = new String[]{};
            }
            if ((parameterNames = method.getParameterNames()) == null) {
                parameterNames = new String[]{};
            }
            while (true) {
                int length = parameterTypes.length;
                String[] newParameterTypes = new String[length + 1];
                String[] newParameterNames = new String[length + 1];
                System.arraycopy(parameterTypes, 0, newParameterTypes, 0, length);
                System.arraycopy(parameterNames, 0, newParameterNames, 0, length);
                newParameterTypes[length] = String.valueOf('I');
                newParameterNames[length] = "i" + parameterTypes.length + 1;
                IMethod newMethod = type.getMethod(name, newParameterTypes);
                if (newMethod == null || !newMethod.exists()) {
                    return new String[][]{SignatureUtil.signatureToString(newParameterTypes), newParameterNames};
                }
                parameterTypes = newParameterTypes;
                parameterNames = newParameterNames;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static String commentBody(String body) {
        if (body == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(body, "\n\r");
        String commentedBody = MethodBodyUtil.getExplanationString();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!line.startsWith("//") && !line.trim().startsWith("//")) {
                line = "//" + line;
            }
            commentedBody = commentedBody + line + JavaProviderPlugin.EOL;
        }
        return commentedBody;
    }

    private static boolean isEmptyBody(String body) {
        if (body == null) {
            return true;
        }
        if (";".equals(body = body.trim())) {
            return true;
        }
        body = MethodBodyUtil.clearBody(body);
        return (body = body.trim()).length() == 0;
    }

    private static String clearBody(String body) {
        if (body == null) {
            return null;
        }
        if ((body = body.trim()).startsWith("{") && body.endsWith("}")) {
            body = body.substring(1, body.length() - 1);
        }
        return body;
    }

    private static String arrangeBody(String body) {
        return "{" + JavaProviderPlugin.EOL + body + "}" + JavaProviderPlugin.EOL;
    }

    private static String getExplanationString() {
        return "//" + COMMENTED + JavaProviderPlugin.EOL;
    }
}

