/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.LinksCache;
import java.util.Hashtable;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;

class LinksCacheImpl
implements LinksCache {
    private Hashtable myPermanentAssociationLinkCache = new Hashtable();
    private Hashtable myTemporarilyAssociationLinkCache = new Hashtable();
    private Hashtable myPermanentGeneralizationLinkCache = new Hashtable();
    private Hashtable myTemporarilyGeneralizationLinkCache = new Hashtable();
    private Hashtable myPermanentImplementationLinkCache = new Hashtable();
    private Hashtable myTemporarilyImplementationLinkCache = new Hashtable();

    LinksCacheImpl() {
    }

    public void addPermanentAssociationLink(IField field, String type) {
        if (field != null) {
            String handleIdentifier = field.getHandleIdentifier();
            this.myPermanentAssociationLinkCache.put(handleIdentifier, type);
        }
    }

    public void addTemporarilyAssociationLink(IField field, String type) {
        if (field != null) {
            String handleIdentifier = field.getHandleIdentifier();
            this.myTemporarilyAssociationLinkCache.put(handleIdentifier, type);
        }
    }

    public String getAssociationLinkType(IField field) {
        if (field != null) {
            String handleIdentifier = field.getHandleIdentifier();
            if (this.myTemporarilyAssociationLinkCache.containsKey(handleIdentifier)) {
                return (String)this.myTemporarilyAssociationLinkCache.get(handleIdentifier);
            }
            return (String)this.myPermanentAssociationLinkCache.get(handleIdentifier);
        }
        return null;
    }

    public void removePermanentAssociationLink(IField field) {
        if (field != null) {
            String handleIdentifier = field.getHandleIdentifier();
            this.myPermanentAssociationLinkCache.remove(handleIdentifier);
        }
    }

    public void removeTemporarilyAssociationLink(IField field) {
        if (field != null) {
            String handleIdentifier = field.getHandleIdentifier();
            this.myTemporarilyAssociationLinkCache.remove(handleIdentifier);
        }
    }

    public void addPermanentGeneralizationLinks(IType type, String[] types) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            this.myPermanentGeneralizationLinkCache.put(handleIdentifier, types);
        }
    }

    public void addTemporarilyGeneralizationLinks(IType type, String[] types) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            this.myTemporarilyGeneralizationLinkCache.put(handleIdentifier, types);
        }
    }

    public String[] getGeneralizationLinks(IType type) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            if (this.myTemporarilyGeneralizationLinkCache.containsKey(handleIdentifier)) {
                Object obj = this.myTemporarilyGeneralizationLinkCache.get(handleIdentifier);
                return obj != null ? (String[])obj : new String[]{};
            }
            Object obj = this.myPermanentGeneralizationLinkCache.get(handleIdentifier);
            return obj != null ? (String[])obj : new String[]{};
        }
        return new String[0];
    }

    public void removePermanentGeneralizationLinks(IType type) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            this.myPermanentGeneralizationLinkCache.remove(handleIdentifier);
        }
    }

    public void removeTemporarilyGeneralizationLinks(IType type) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            this.myTemporarilyGeneralizationLinkCache.remove(handleIdentifier);
        }
    }

    public void addPermanentImplementationLinks(IType type, String[] types) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            this.myPermanentImplementationLinkCache.put(handleIdentifier, types);
        }
    }

    public void addTemporarilyImplementationLinks(IType type, String[] types) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            this.myTemporarilyImplementationLinkCache.put(handleIdentifier, types);
        }
    }

    public String[] getImplementationLinks(IType type) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            if (this.myTemporarilyImplementationLinkCache.containsKey(handleIdentifier)) {
                Object obj = this.myTemporarilyImplementationLinkCache.get(handleIdentifier);
                return obj != null ? (String[])obj : new String[]{};
            }
            Object obj = this.myPermanentImplementationLinkCache.get(handleIdentifier);
            return obj != null ? (String[])obj : new String[]{};
        }
        return new String[0];
    }

    public void removePermanentImplementationLinks(IType type) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            this.myPermanentGeneralizationLinkCache.remove(handleIdentifier);
        }
    }

    public void removeTemporarilyImplementationLinks(IType type) {
        if (type != null) {
            String handleIdentifier = type.getHandleIdentifier();
            this.myTemporarilyImplementationLinkCache.remove(handleIdentifier);
        }
    }
}

