/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.ExtendsListUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;

class LinkDeleteUtil {
    private static IType ourType;
    private static IJavaProject ourJavaProject;
    private static ResultCollector ourResultCollector;

    LinkDeleteUtil() {
    }

    static void deleteLinks(IJavaProject javaProject, IType type) {
        if (JavaProviderPlugin.isDeleteAttributes() || JavaProviderPlugin.isUpdateExtendsList()) {
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
            ISearchPattern searchPattern = SearchEngine.createSearchPattern((IJavaElement)type, (int)3);
            SearchEngine searchEngine = new SearchEngine();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ourType = type;
            ourJavaProject = javaProject;
            try {
                searchEngine.search(workspace, searchPattern, searchScope, (IJavaSearchResultCollector)ourResultCollector);
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
    }

    static {
        ourResultCollector = new ResultCollector();
    }

    private static class ResultCollector
    implements IJavaSearchResultCollector {
        private ArrayList myFieldResultList = new ArrayList();
        private ArrayList myTypeResultList = new ArrayList();

        private ResultCollector() {
        }

        public void aboutToStart() {
            this.myFieldResultList.clear();
            this.myTypeResultList.clear();
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
            if (accuracy == 0) {
                if (enclosingElement instanceof IField) {
                    this.myFieldResultList.add(enclosingElement);
                } else if (enclosingElement instanceof IType) {
                    this.myTypeResultList.add(enclosingElement);
                }
            }
        }

        public void done() {
            if (JavaProviderPlugin.isDeleteAttributes()) {
                this.removeFields();
            }
            if (JavaProviderPlugin.isUpdateExtendsList()) {
                this.removeExtends();
            }
        }

        public IProgressMonitor getProgressMonitor() {
            return new NullProgressMonitor();
        }

        private void removeFields() {
            int i = 0;
            while (i < this.myFieldResultList.size()) {
                IField field = (IField)this.myFieldResultList.get(i);
                try {
                    if (ElementUtil.isWritableElement((IJavaElement)field)) {
                        field.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (JavaModelException e) {
                    JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                }
                ++i;
            }
        }

        private void removeExtends() {
            if (ourType == null) {
                return;
            }
            int i = 0;
            while (i < this.myTypeResultList.size()) {
                IType type = (IType)this.myTypeResultList.get(i);
                if (ElementUtil.isWritableElement((IJavaElement)type)) {
                    ExtendsListUtil.removeExtends(ourJavaProject, type, ourType);
                }
                ++i;
            }
        }
    }
}

