/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.AbstractCopyPasteProvider;
import com.tssap.selena.internal.core.providers.java.Clipboard;
import com.tssap.selena.internal.core.providers.java.ClipboardLink;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.IClipboardElement;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.PasteProvider;
import org.eclipse.jdt.core.IType;

public class LinkCopyPasteProvider
extends AbstractCopyPasteProvider
implements CopyProvider,
CutProvider,
PasteProvider {
    private boolean isCopyOrCutProviderApplicable(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return NameUtil.isJavaUniqueName(uniqueName) && NameUtil.isJavaLinkElementUniqueName(uniqueName, false);
    }

    public boolean isCopyProviderApplicable(Element element) {
        return this.isCopyOrCutProviderApplicable(element);
    }

    public boolean isCutProviderApplicable(Element element) {
        return this.isCopyOrCutProviderApplicable(element);
    }

    public boolean canCopy(Element element) {
        return true;
    }

    public void copy(Element element, CopyUniqueName copyUin) {
        UniqueName uniqueName = element.getUniqueName();
        ClipboardLink clipboardLink = ClipboardLink.createClipboardLink((Entity)element, copyUin);
        if (clipboardLink != null && clipboardLink.isValid()) {
            uniqueName = clipboardLink.getUniqueName();
            Clipboard.putClipboardElement((UniqueName)copyUin, clipboardLink);
        }
    }

    public boolean canCut(Element element) {
        Entity parent = element.getParent();
        return AbstractCopyPasteProvider.canCutFrom(ElementUtil.getJavaElement((Element)parent)) && element.canDelete();
    }

    public void cut(Element element, CopyUniqueName copyUin) {
        this.copy(element, copyUin);
        element.delete();
    }

    public boolean isPasteProviderApplicable(Entity container) {
        UniqueName uniqueName = container.getUniqueName();
        return NameUtil.isJavaElementUniqueName(uniqueName, false) && NameUtil.isTypeUniqueName(uniqueName) && ElementUtil.getJavaElement((Element)container) instanceof IType;
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        if (element == null) {
            return false;
        }
        UniqueName pastingUin = element.getUniqueName();
        IClipboardElement clipboardElement = Clipboard.getClipboardElement(pastingUin);
        if (clipboardElement instanceof ClipboardLink) {
            IType javaParent = (IType)ElementUtil.getJavaElement((Element)container);
            return ((ClipboardLink)clipboardElement).canPaste(javaParent, container);
        }
        return false;
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        if (element == null) {
            return null;
        }
        UniqueName pastingUin = element.getUniqueName();
        IClipboardElement clipboardElement = Clipboard.getClipboardElement(pastingUin);
        if (clipboardElement instanceof ClipboardLink) {
            IType javaParent = (IType)ElementUtil.getJavaElement((Element)container);
            Element result = ((ClipboardLink)clipboardElement).paste(javaParent, container);
            return result == null ? null : result.getUniqueName();
        }
        return null;
    }
}

